<?php $__env->startSection('content'); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo e(asset('admin/assets/extra-libs/multicheck/datatable-checkbox-init.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/extra-libs/multicheck/jquery.multicheck.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/extra-libs/DataTables/datatables.min.js')); ?>"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('admin/assets/extra-libs/multicheck/multicheck.css')); ?>">
    <link href="<?php echo e(asset('admin/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css')); ?>" rel="stylesheet"> -->

    <main id="main" class="main">

        <?php if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA'): ?>
            <div class="page-breadcrumb">
                <div class="row">
                    <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                        <h4 class="page-title">Coupon</h4>
                        <div class="ml-auto text-right">
                            <a href="<?php echo e(url('admin/coupon/add/')); ?>/<?php echo e($site_id); ?>" class="btn btn-success">ADD Coupon</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(Session::has('alert-' . $msg)): ?>
                                        <h4 class="font-weight-light alert alert-<?php echo e($msg); ?>"><?php echo e(Session::get('alert-' . $msg)); ?></h4>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <h5 class="card-title">Testimonial Management</h5>
                                <?php if(count($result) > 0): ?>
                                <div class="table-responsive">
                                    <table id="zero_config" class="table table-striped table-bordered">
                                        <thead>
                                            <tr>
                                                <th style="width: 5%"><b>#</b></th>
                                                <th style="width: 10%"><b>Site</b></th>
                                                <th style="width: 15%"><b>Coupon Code</b></th>
                                                <th style="width: 5%"><b>Discount Type</b></th>
                                                <th style="width: 15%"><b>Discount Amount</b></th>
                                                <th style="width: 11%"><b>Start Date</b></th>
                                                <th style="width: 11%"><b>End Date</b></th>
                                                <th style="width: 6%"><b>Created</b></th>
                                                <th style="width: 6%"><b>Status</b></th>
                                                <th style="width: 9%">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i=1; ?>
                                            <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($i + $key); ?></td>
                                                <td><?php echo e($site->site_name); ?></td>
                                                <td><?php echo e($data->coupon_code); ?></td>
                                                <?php if($data->type == "F"): ?> 
                                                    <td>Flat</td>  
                                                <?php else: ?>  
                                                    <td>Percent</td>  
                                                <?php endif; ?>
                                                <td><?php echo e($data->amount); ?></td>
                                                <td><?php echo e($data->start_date); ?></td>
                                                <td><?php echo e($data->end_date); ?></td>
                                                <td><?php echo e(date('d-m-Y', strtotime($data->created_at))); ?></td>
                                                <td>
                                                    <label class="switch">
                                                        <input type="checkbox" class="blockstatus" name="stat" id="stat" data-id="<?php echo e(base64_encode($data->id)); ?>" <?php if($data->is_block == 'N'): ?> checked <?php endif; ?>>
                                                        <span class="slider roundsemi"></span>
                                                    </label>
                                                    <label id="status-info-<?php echo e($data->id); ?>" class="status-stat"></label>
                                                </td>
                                                <td >
                                                    <a href="<?php echo e(route('admin.coupon.edit', base64_encode($data->id).'?redirect='.urlencode($request->fullUrl()))); ?>">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a onclick="return confirm('Are you sure you want to delete the Coupon?')" href="<?php echo e(route('admin.coupon.delete', base64_encode($data->id))); ?>">
                                                        <i class="fas fa-trash-alt"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                                <?php else: ?>
                                    <div class="card">No Data Found...</div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>    
    </main><!-- End #main -->

    <script>

        /****************************************
         *       Basic Table                   *
         ****************************************/

        // $('#zero_config').DataTable({
        //     "order": [[5, "desc"]] 
        // });

        document.addEventListener("DOMContentLoaded", function () {
            const table = document.querySelector("#zero_config");
            const dataTable = new simpleDatatables.DataTable(table, {
                sortable: true,
                fixedHeight: true,
                columns: [
                    { select: 5, sort: "desc" } // Sort by the 6th column (index 5) descending
                ]
            });
        });

        $(function(){
            setTimeout(function(){ $('.alert').hide(); }, 3000);
            var status, id;
            $('#zero_config').on('change', '.blockstatus', function() {
            // $('.blockstatus').change(function(){
                if(this.checked){
                    status = 'Y';
                }else{
                    status = 'N'
                }
                id = $(this).attr('data-id');
                var ajaxurl = "<?php echo e(route('admin.coupon.status')); ?>"; 
                $.ajax({
                    type : 'POST',
                    url : ajaxurl,
                    data : { 'id' : id, 'status' : status },
                    headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success : function(response){
                        response = JSON.parse(response);
                        if(response.status == 1){
                            $('#status-info-'+response.id).html(response.event).fadeIn(100).delay(1000).fadeOut();
                        }
                    },
                    error : function(){
                        $('.selected_records_data').html('<span class="error-msg text-danger">There was an unexpected error!! Please try again later.</span>');
                    }
                });
            });
        })

    </script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/coupon/list.blade.php ENDPATH**/ ?>