@extends('layouts.admin.app')

@section('content')

<link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/extra-libs/multicheck/multicheck.css') }}">
<link href="{{ asset('admin/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css') }}" rel="stylesheet">

<main id="main" class="main">
    <div class="pagetitle">
      <h1>General Tables</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{route('admin.order.home')}}">Home</a></li>
          <li class="breadcrumb-item">Inbox</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
    <table  class="table table-striped table-bordered" style="font-size:14px;  border: none;">
        <form action="{{url('/admin/order/trash')}}" method="post">
            @csrf
            <tr>
                <th style="border:none;">
                    <input class="form-control" id="search_val" name="search_val" placeholder="Search By Name / Email / Ticket Id / Subject" required/>
                </th>
                <th style="border:none;"><button class="btn btn-primary" type="submit">Search</button></th>
                <th style="border:none; vertical-align:bottom;" > <div id="info" style="text-align:right;"></div></th>
            </tr>
            
            @if($search != 0)
            <tr>
                <td style="border:none; padding: 0.2rem 1rem;">
                    @if($search != 0)
                        <p><b>Searched By:</b>&nbsp;&nbsp; {{$search}} &nbsp;&nbsp;&nbsp;&nbsp;<a href="" class="badge badge-pill badge-danger" type="submit">Clear</a></p>
                    @endif 
                </td>
                <td colspan="2" style="border:none; padding: 0.2rem 1rem;"></td>
            </tr>
            @endif
        </form>
    </table>

</div>
    
<div class="container-fluid">
    
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                        @if(Session::has('alert-' . $msg))
                            <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
                        @endif
                    @endforeach
                    
                        @if(count($paginatedData) > 0)
                        <div class="table-responsive">
                            <table id="zero_config" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th style="width: 4%"><b>Site</b></th>
                                        <th style="width: 21%"><b>Name</b></th>
                                        <th style="width: 58%"><b>Ticket Id</b></th>
                                        <th style="width: 7%"><b>Date</b></th>
                                        <th style="width: 10%"></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @php $i=0; @endphp
                                    @foreach($paginatedData as $key => $data)
                                    
                                    @php $i++; @endphp

                                        @php
                                            $conversionCount = App\Http\pagginationHelper::conversionCount(strtolower($data->sitename), $data->id);
                                        @endphp
                                    
                                        <tr class = "{!! $data->view_status == 0 ? 'unreadmail' : 'readmail' !!} clickable-row" data-href="{{ url('/admin/order/view') }}/{{ strtolower($data->sitename) }}/{{ base64_encode($data->id) }}/{{base64_encode(url()->current())}}" >
                                            
                                            <td><span class="sitename <?php if($data->is_block == 'Y'){ ?>closedmatter<?php } ?>">{{ $data->sitename }}</span></td> 
                                            <td class="name">{{ $data->name }}
                                                @if(count($conversionCount) > 1)
                                                    <span>{{count($conversionCount)}}</span>
                                                @endif
                                                <span style="display:none;">{{ $data->email }}-{{ $data->mobile }}</span>
                                            </td>
                                            <td class="ticket">{{ $data->ticket_id }}
                                                <span> - 
                                                        @if(strlen($data->subject) > 95)
                                                            {!! substr($data->subject, 0, 94) !!}...
                                                        @else
                                                            {!! $data->subject !!}
                                                        @endif
                                                </span>
                                            </td> 
                                            <td style="text-align:right">{{ date('M j', strtotime($data->updated_at)) }}</td>

                                            <td style="text-align:right">
                                                
                                                <a href="{{url('/admin/order/markunread')}}/{{ strtolower($data->sitename) }}/{{ base64_encode($data->id) }}" ><i class="ri-mail-unread-line" title="Mark as Unread"></i></a>
                                                &nbsp;&nbsp;
                                                <a href="{{url('/admin/order/movetoinbox')}}/{{ strtolower($data->sitename) }}/{{ base64_encode($data->id) }}" ><i class="ri-inbox-archive-fill" title="Move to Inbox"></i></a>

                                                @if(Session::get('permissions.user_type') == 'C')
                                                    <span class="ms-2">
                                                        <a href="{{ url('/admin/order/view/delete') }}/{{ strtolower($data->sitename) }}/{{ base64_encode($data->id) }}">
                                                            <i class="bi bi-trash-fill" title="Delete Forever"></i>
                                                        </a>
                                                    </span>
                                                @endif

                                                
                                            </td>
                                        </tr>
                                    
                                    @endforeach
                                </tbody>

                            </table>
                        </div>

                    @else
                    <div class="card">No Data Found...</div>
                    @endif
                </div>
            </div>
        </div>
        <table  class="table table-striped table-bordered" style="font-size:14px;  border: none;">
            @if ($paginatedData->hasPages())
            <tr>
                <td style="width:auto; text-align:center; border:none;" >
                    <nav role="navigation" aria-label="Pagination Navigation" class="flex justify-between">
                    <span>
                        @if ($paginatedData->onFirstPage())
                            <span></span>
                        @else
                            <a href="{{ $paginatedData->previousPageUrl() }}" class="btn btn-primary" rel="prev">Previous</a>
                        @endif
                    </span>
                        @foreach(range(1, $paginatedData->lastPage()) as $i)
                            @if($i >= $paginatedData->currentPage() - 2 && $i <= $paginatedData->currentPage() + 2)
                                @if ($i == $paginatedData->currentPage())
                                <a href="" class="btn btn-primary" style="background: white;color: black;">{{ $i }}</a>
                                @else
                                <a href="{{ $paginatedData->url($i) }}" class="btn btn-primary">{{ $i }}</a>
                                @endif
                            @endif
                        @endforeach
                    <span>
                        @if ($paginatedData->hasMorePages())
                             <a href="{{ $paginatedData->nextPageUrl() }}" rel="next" class="btn btn-primary" >Next</a>
                        @else
                            <span></span>
                        @endif
                        </span>
                    </nav>
                </td>
            </tr>
            @endif   
        </table>
    </div>
</div>
</div>
</section>
  </main>
<!--  $i++; -->

<script src="{{ asset('admin/assets/extra-libs/multicheck/datatable-checkbox-init.js') }}"></script>
<script src="{{ asset('admin/assets/extra-libs/multicheck/jquery.multicheck.js') }}"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script>
    /****************************************
     *       Basic Table                   *
     ****************************************/
    
    $('#zero_config').DataTable({
        //"order": [[3, "desc"]],
        "ordering": false,
        "pageLength": 50,
        //"dom": '<"top"flp<"clear">>rt<"bottom"i<"clear">>'
        //dom: '<"top"i>rt<"bottom"flp><"clear">'
        //"dom":' <"top"f>rt<"bottom"ip><"clear">'
    });

    $(document).ready(function() {
        $("#search").html($(".dataTables_filter"));
        // $('#len').html($(".dataTables_length"));
        $('#info').html($(".dataTables_info"));
        $('#pagginate').html($(".rounded-md"));

        $('#zero_config tbody tr:odd').removeClass('odd');

        $(".clickable-row").click(function() {
            window.location = $(this).data("href");
        });

        $("#search").html($(".dataTables_filter"));
        // $('#len').html($(".dataTables_length"));
        $('#info').html($(".dataTables_info"));
        $('#pagginate').html($(".paging_simple_numbers"));
    });

    /******auto refresh HTML only if there has been no activity on a page******/

    var inactivityTimeout;
    var inactivityDuration = 600000; // 10 minutes in milliseconds

    function resetInactivityTimer() {
        clearTimeout(inactivityTimeout);
        inactivityTimeout = setTimeout(refreshPage, inactivityDuration);
    }

    function refreshPage() {
        location.reload();
    }

    // Event listeners to reset the inactivity timer
    document.addEventListener('mousemove', resetInactivityTimer);
    document.addEventListener('keydown', resetInactivityTimer);
    document.addEventListener('scroll', resetInactivityTimer);

    // Initial setup of the inactivity timer
    resetInactivityTimer();
    
    
</script>

<style type="text/css">
    
    @import url("https://fonts.googleapis.com/css2?family=Abel&family=Quicksand:wght@400;500;600&display=swap");

    #zero_config{font-family: 'Quicksand', sans-serif;}

    #zero_config{border: 0; border-collapse: collapse!important;}
    #zero_config thead{display: none;}
    #zero_config tr td{border-right: 0}
    .unreadmail{background: #eeeeee !important;font-size: 13px;font-weight: bolder !important; color: #000;}
    .readmail{background: #dad7d7 !important;font-size: 13px;font-weight: 500 !important; color: #000;}
    .unreadmail:hover { box-shadow: inset -1px -2px 7px 0px rgba(0,0,0,0.5); cursor: pointer; }
    .readmail:hover { box-shadow: inset -1px -2px 7px 0px rgba(0,0,0,0.5); cursor: pointer; }

    .table-bordered td, .table-bordered th {border: 1px solid #a4a4a4;}
    .card{background: #eeeeee}
    .card-body{padding: 0}
    .markunread{font-size: 16px; color: #9d9999; border: 2px solid #9d9999; border-radius: 100%; padding: 2px 5px;}
    .markunread:hover{color: #828181; border: 2px solid #828181;}
    .name span{padding-left: 5px; color:#676a6a;}
    .sitename{border: 2px solid #a09c9c;padding: 4px;border-radius: 14%;font-size: 12px;background-color: #a09c9cc7;color: #f3f3f3;}
    .unreadmail .ticket span{color:#676a6a;font-size: 15.5px;font-weight: 500 !important;}
    .readmail .ticket span{color:#676a6a;font-size: 15.5px;font-weight: 500 !important;}
    .closedmatter{background:#3d3d3d!important;}

    #zero_config_filter .form-control-sm{width:500px!important; }
    #zero_config_length{display:none;}
    .paging_simple_numbers{display:none;}
    .dataTables_filter{display: none !important; }

</style>




@endsection

