@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
{{--<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>--}}
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
    @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA')
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Addon Sub Group</h4>
                    <div class="ml-auto text-right">
                        <a href="{{ route('admin.addon.addon_sub_group_list') }}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                            @if(Session::has('alert-' . $msg))
                                <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
                            @endif
                        @endforeach
                        <form action="{{ route('admin.addon.addon_sub_edit', base64_encode($dataDetails->id).'?redirect='.urlencode($request->fullUrl())) }}" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <h4 class="card-title">Addon Sub Group Edit</h4>
                                <input type="hidden" name="formid" value="<?php echo $dataDetails->id; ?>">
                                
                                <div class="form-group m-t-20">
                                    <label>Addon Group<span>*</span></label>
                                    <select id="addon_group_id" name="addon_group_id" type="text" class="form-control"
                                        aria-required="true" aria-invalid="false" required>
                                        <option value="">Select Addon Group</option>
                                        @foreach ($addon_groups as $list)
                                            @if ($dataDetails->addon_group_id == $list->id)
                                            <option selected value="{{ $list->id }}">
                                            @else
                                                <option value="{{ $list->id }}">
                                            @endif
                                            {{ $list->title }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Name</label>
                                    <input type="text" class="form-control" id="name" name="name" value="{{$dataDetails->name}}" placeholder="Enter Addon Sub Group Name" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Sort</label>
                                    <input type="text" class="form-control" id="sort" name="sort" value="{{$dataDetails->sort}}" placeholder="Enter Sort" required>
                                </div>
                            </div>
                            <div class="border-top">
                                <div class="card-body">
                                    <input class="btn btn-primary" type="submit" value="UPDATE">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
</main>    

<script type="text/javascript">
    $.validator.setDefaults({
            submitHandler: function(form) {
                form.submit();
            }
    });
    $(function() {
        // validate the comment form when it is submitted
        $("#formadd").validate({
            ignore: [],
            errorPlacement: function(label, element) {
                label.addClass('mt-2 text-danger');
                label.insertAfter(element);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass('has-danger')
                $(element).addClass('form-control-danger')
            }

          });
    });

</script>     

@endsection