<?php

namespace App\Http;
use Illuminate\Support\Facades\DB;

use App\Models\Product;
use App\Models\ProductImage;
use App\Models\OrderDetail;
use App\Models\PersonalizedImageDetail;
use App\Models\PersonalizedTextDetail;
use App\Models\Currency;
use App\Models\AssignOrderDetail;



class Helper1{

    public static function get_SiteInfo($sort_code = null){
        $result = DB::connection('mysql')->table('site_details')
                                    ->where(['site_sort_name' => $sort_code])->first();

        return $result;
    }


    public static function get_image($id = 0){

        $result = DB::connection('mysql')->table('product_images')

                  ->where(['product_id' => $id, 'default_image' => 'Y'])->first();

        return $result;

    }

    public static function product_relatated_category_list($productid = 0){

        $result = [];

        $getCategoryId = DB::connection('mysql')->table('product_categories')->where('product_id', $productid)->pluck('category_id');

        if(isset($getCategoryId) && count($getCategoryId) > 0){

            $result = DB::connection('mysql')->table('categories')->whereIn('id', $getCategoryId)->pluck('name');

        }

        return $result;

    }

    public static function get_reviewDtlsbyProduct($id = 0){

        $result = DB::connection('mysql')->table('product_rating')

                                        ->where(['product_id' => $id])->get();

        return $result;

    }



    public static function get_vendorDtl($vname = null){

        $result = DB::connection('mysql')->table('vendor_details')

                                        ->where(['vendor_code' => $vname])->first();

        return $result;

    }



    public static function get_productStatus($id = 0){

        $stat = '';

        $result = DB::connection('mysql')->table('product_live_status')

                                        ->where(['product_id' => $id])->first();



        $stat_aof = $result->aof_is_block == 'N' ? '<span class="badge rounded-pill bg-info">AOF</span>' : '<span class="badge rounded-pill bg-danger">AOF</span>';

        $stat_bof = $result->bof_is_block == 'N' ? '<span class="badge rounded-pill bg-info">BOF</span>' : '<span class="badge rounded-pill bg-danger">BOF</span>';

        $stat_cof = $result->cof_is_block == 'N' ? '<span class="badge rounded-pill bg-info">COF</span>' : '<span class="badge rounded-pill bg-danger">COF</span>';

        $stat_dof = $result->dof_is_block == 'N' ? '<span class="badge rounded-pill bg-info">DOF</span>' : '<span class="badge rounded-pill bg-danger">DOF</span>';

        $stat_hof = $result->hof_is_block == 'N' ? '<span class="badge rounded-pill bg-info">HOF</span>' : '<span class="badge rounded-pill bg-danger">HOF</span>';

        $stat_kof = $result->kof_is_block == 'N' ? '<span class="badge rounded-pill bg-info">KOF</span>' : '<span class="badge rounded-pill bg-danger">KOF</span>';

        $stat_mof = $result->mof_is_block == 'N' ? '<span class="badge rounded-pill bg-info">MOF</span>' : '<span class="badge rounded-pill bg-danger">MOF</span>';

        $stat_pof = $result->pof_is_block == 'N' ? '<span class="badge rounded-pill bg-info">POF</span>' : '<span class="badge rounded-pill bg-danger">POF</span>';





        $stat = $stat_aof . ' '. $stat_bof . ' '. $stat_cof . ' '. $stat_dof . ' '. $stat_hof . ' '. $stat_kof . ' '. $stat_mof . ' '. $stat_pof;

        return $stat;

    }

    public static function reportOrderDtl($id = null){
        
        $dd = $di = '';

        $orderDtl = OrderDetail::where(['order_id'=>$id])->get();

        $result = [];
        $result['deliveryDate'] = '';
        $result['deliveryItem'] = '';

        foreach($orderDtl as $order){
            if($result['deliveryDate'] != ''){ $dd = '<br>'; } else { $dd = ''; }
            if($result['deliveryItem'] != ''){ $di = '<br>'; } else { $di = ''; }
            $result['deliveryDate'] = $result['deliveryDate'] . $dd . date('jS M,Y' , strtotime($order->delivery_date));

            if( $order->product_id == 0 && $order->order_details_id_giftaddon > 0 ){
                $result['deliveryItem'] = $result['deliveryItem'] . $di . self::get_productName($order->gift_addon_id) . '<em>'.$order->qty.'</em>';
            }else{
                $result['deliveryItem'] = $result['deliveryItem'] . $di . self::get_productName($order->product_id) . '<em>'.$order->qty.'</em>';
            }
            
        }

        //dd($result);
        return $result;
    }

    public static function getPersonalizeImg($oid, $pid){
        $result = [];
        $result = PersonalizedImageDetail::where(['order_detail_id' => $oid, 'product_id' => $pid])->get();

        return $result;
    }

    public static function getPersonalizeTxt($oid, $pid){
        $result = [];
        $result = PersonalizedTextDetail::where(['order_detail_id' => $oid, 'product_id' => $pid])->first();

        return $result;
    }

    public static function get_productName($id = null){
        $result = Product::where(['id'=>$id])->first();
        return $result->product_name;
    }

    public static function assignOrderDtl($oid = null){
        $result = AssignOrderDetail::where(['order_id' => $oid])->first();
        return $result;
    }

    public static function getAgentDtl($id = null){
        $result = DB::connection('mysql')->table('agents')->where(['id' => $id])->first();
        return $result;
    }

    public static function getOrderDtl($id = null){
        $result = DB::connection('mysql')->table('orders')->where(['id' => $id])->first();
        return $result;
    }

    // public static function getAgentPlaceProductDtl($id = null){
    //     $result = DB::connection('mysql')->table('assigned_agent_product_map')
    //                 ->join('agent_product_list', 'assigned_agent_product_map.product_id', '=', 'agent_product_list.id')->where(['agent_assinged_id' => $id])->get();
    //     return $result;
    // }

    public static function getAgentPlaceProductDtl($id = null){
        $result = DB::connection('mysql')->table('assigned_agent_product_map')
                    ->join('agent_product_details', 'assigned_agent_product_map.product_id', '=', 'agent_product_details.id')->where(['agent_assinged_id' => $id])->get();
        return $result;
    }

    public static function get_orderPlacedInfo($id = null){
        $getAssignDtl = DB::connection('mysql')->table('agent_assinged')->where(['OID' => $id])->first();

        $result = DB::connection('mysql')->table('admins')->where(['id' => $getAssignDtl->placed_userid])->first();
        return $result;
    }

    public static function getProductDetails($id = null){
        
        // $assigned_agent_product_map = DB::connection('mysql')->table('assigned_agent_product_map')->where('agent_assinged_id', $id)->get();
        // // $productIds = $assigned_agent_product_map->pluck('product_id');

        // foreach($assigned_agent_product_map as $map){
        //     $products = DB::connection('mysql')->table('agent_product_details')->whereIn('id', $map->id)->first();
        // } 

        // $products = DB::table('agent_assinged')
        //           ->join('assigned_agent_product_map','agent_assinged.id','=','assigned_agent_product_map.agent_assinged_id')
        //           ->join('agent_product_details','agent_product_details.id','=','assigned_agent_product_map.product_id')
        //           ->join('products','agent_product_details.fnid','=','products.fnid')
        //           // ->orderBy('blogs.created_at','desc')
        //           ->where('agent_assinged.id', '=', $id)
        //           ->select(["agent_assinged.id as aid","agent_assinged.status as as", "agent_product_details.fnid as fnid", "products.name as pname"])
        //           // ->get(["sites.site_name","blogs.*"]);

        $products = DB::table('agent_assinged')
                    ->join('assigned_agent_product_map', 'agent_assinged.id', '=', 'assigned_agent_product_map.agent_assinged_id')
                    ->join('agent_product_details', 'agent_product_details.id', '=', 'assigned_agent_product_map.product_id')
                    ->join('products', 'agent_product_details.fnid', '=', 'products.fnid')
                    ->where('agent_assinged.OID', '=', $id)
                    ->select([
                        'agent_assinged.*',
                        'agent_product_details.fnid as fnid',
                        'products.product_name as pname'
                    ])
                    ->get();



        return $products;
    }

    public static function get_imagelink($id = null){
        $imgDtl = DB::connection('mysql')->table('agent_product_details')->where('id', $id)->first();

        $result = 'https://giftbasketsbrazil.rightflorist.org/uploaded/product/'.$imgDtl->fnid . '.webp';
        return $result;
    }

    public static function get_item_detail($id = null){
        $result = '';
        $result = DB::connection('mysql')->table('agent_product_details')->where('id',$id)->first();
       
        return $result;
    }

    public static function get_order_messages($id = null){
        $result = DB::connection('mysql')->table('order_messages')->where(['order_id'=>$id])->first();
        return $result;
    }

}