<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\Testimonial;
use App\Models\Site;
use Illuminate\Support\Facades\Auth;

class TestimonialController extends Controller
{
	public function list($id=null, Request $request)
	{
		$site_id=$id;
        $result = Testimonial::where('site_id', $site_id)->orderBy('created_at', 'desc')->get();
        $site = Site::where('id', $site_id)->first();
        return view('admin.testimonial.list', ['result' => $result, 'request' => $request, 'site_id' => $site_id, 'site' => $site]);
    }

    public function add($id=null, Request $request)
    {
    	$site_id = $id;
        $obj = new Testimonial;

        if($request->isMethod('POST')){
            $request->validate([
                'name'=>'required',
                'send_place'=>'required',
                'from_place'=>'required',
                'content'=>'required',
                'rating' =>'required'
            ]);

            if($testimonal = $obj->create([
            		'site_id' => $site_id,
                    'name' => $request->name, 
                    'send_place' => $request->send_place, 
                    'place' => $request->from_place,
                    'content' => $request->content, 
                    'rating' => $request->rating,
                    'created_by' => Auth::guard('AdminLogin')->user()->id
                ]))
            {
                $request->session()->flash('alert-success', 'Testimonial Successfully Added.');
                return redirect()->route('admin.testimonial.list', ['id' => $site_id]);
            }else{
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back()->with($request->except(['_method', '_token']));
            }
            
        }

        return view('admin.testimonial.add', ['request' => $request, 'site_id' => $site_id]);
    }

    public function edit($id = null, Request $request){

        $id = base64_decode($id);
		$dataDetails  = Testimonial::where('id',$id)->first();
		$siteId = $dataDetails->site_id;

        if($request->isMethod('POST')){
            $request->validate([
                'name'=>'required',
                'send_place'=>'required',
                'from_place'=>'required',
                'content'=>'required',
                'rating' =>'required'
            ]);
            
            $update_arr['name'] = $request->name;
            $update_arr['send_place'] = $request->send_place;
            $update_arr['place'] = $request->from_place;
            $update_arr['content'] = $request->content;
            $update_arr['rating'] = $request->rating;

            if(Testimonial::where(['id' => $request->formid])->update($update_arr)){
                   
                $request->session()->flash('alert-success', 'Testimonial Successfully Updated.');
                return redirect()->route('admin.testimonial.list', ['id' => $siteId]);
            }else{
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back()->with($request->except(['_method', '_token']));
            }
        }

        return view('admin.testimonial.edit', ['dataDetails' => $dataDetails, 'request' => $request, 'siteId' => $siteId]);
    }

    public function delete($id = null, Request $request)
    {
        if($id == null){
        	return redirect()->back();
            // return redirect()->route('admin.testimonial.list', ['id' => 1]);
        }
        $id = base64_decode($id);

        //@unlink(public_path() . '/uploaded/event_images/' . $event_details->eimg);

        if( Testimonial::where(['id' => $id])->delete()){
            $request->session()->flash('alert-success', 'Testimonial deleted successfully.');
            return redirect()->back();
        }else{
            $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
            return redirect()->back();
        }
    }

    public function status(Request $request)
    {
        if($request->id == null || $request->status == null){
            // return redirect()->route('admin.category.list');
        }
        $id = base64_decode($request->id);
        switch($request->status){
            case 'N':
                $block = 'Y';
                $blockText = 'Block';
                break;
            case 'Y':
                $block = 'N';
                $blockText = 'Unblock';
                break;
            default:
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back();
        }

        if(Testimonial::where(['id' => $id])->update(['is_block' => $block])){
            $prompt = array('status' => 1, 'id' => $id, 'event' => $blockText);
            echo json_encode($prompt);
        }else{
            $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
            return redirect()->back();
        }
    }
}