<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;
use Illuminate\Session\TokenMismatchException;
use Illuminate\Support\Str;

class Handler extends ExceptionHandler
{
    /**
     * The list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    // public function render($request, Throwable $exception)
    // {
    //     if ($exception instanceof TokenMismatchException) {
    //         return redirect()->route('admin.login')->with('error', 'Session expired. Please login again.');
    //     }

    //     return parent::render($request, $exception);
    // }

    public function render($request, Throwable $exception)
    {
        if ($exception instanceof TokenMismatchException) {
            $path = $request->path(); // e.g., "admin/login" or "agent/login"

            if (Str::startsWith($path, 'admin')) {
                return redirect()->route('admin.login')->with('error', 'Session expired. Please login again.');
            } elseif (Str::startsWith($path, 'agent')) {
                return redirect()->route('agent.login')->with('error', 'Session expired. Please login again.');
            }

            return redirect->route('admin.login')->with('error', 'Session expired. Please login again.');
        }

        return parent::render($request, $exception);
    }
}
