
<?php $__env->startSection('content'); ?>

<main id="main" class="main">
    

    
    <?php if($productdetails): ?>
        <div class="card">
            <div class="card-body">

                <div class="col-12 d-flex no-block align-items-center justify-content-between mb-2">
                    <h5 class="card-title"><?php echo e($productdetails->fnid); ?> - Product Information <?php echo $productdetails->product_type == 'A' ? '<span class="badge rounded-pill bg-warning text-dark">Addon</span>' : ''; ?></h5>

                    <div class="ml-auto text-right">
                        <?php echo $productdetails->is_block == 'Y' ? '<span class="badge bg-danger">BLOCK</span>' : ''; ?>

                    </div>
                </div>

                <table style="width:100%">
                    <tr>
                        
                        <td colspan="2">
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-4"><strong>FNID : </strong><?php echo e($productdetails->fnid); ?> (<?php echo e($productdetails->id); ?>)</div>
                                    <div class="col-4"><strong>SKU : </strong><?php echo e($productdetails->sku); ?></div>
                                    <div class="col-4"><strong>OLD ID : </strong><?php echo e($productdetails->old_id); ?></div>
                                </div>
                            </div>
                        </td>

                        
                        <td rowspan="6">
                            <div class="image-box">
                                <img src="https://giftbasketsbrazil.rightflorist.org/uploaded/product/<?php echo e($productdetails->fnid); ?>.webp" style="width:200px; height: auto;">
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <?php if($productdetails->has_attribute == 'N'): ?>
                            <td><strong>Price : </strong>Rs. <?php echo e($productdetails->price); ?></td>
                            <td><strong>MRP : </strong>Rs. <?php echo e($productdetails->actual_price); ?></td>
                        <?php endif; ?>    
                    </tr>
                    <tr>
                        <td><strong>Delivery Type : </strong>
                            <?php echo e($productdetails->delivery_type == 'H' ? 'Hand Delivery' : 'Courier'); ?>

                        </td>
                        <td><strong>Delay Days : </strong><?php echo e($productdetails->delivery_delay_days); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Specification : </strong><?php echo e(ucwords($productdetails->specification)); ?></td>
                        <td><strong>Segregation : </strong><?php echo e(ucwords($productdetails->segregation)); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Vendor Name : </strong>
                            <?php echo e($productdetails->vendor_name == 'NORMAL' ? '' : $productdetails->vendor_name); ?>

                        </td>
                        <td><strong>Product Attribute : </strong><?php echo e($productdetails->has_attribute); ?></td>
                    </tr>
                    
                    <tr>
                        <?php if($productPersonalize): ?>
                        <td><strong>Personalize No of Images : </strong><?php echo e($productPersonalize->no_of_image); ?></td>
                        <td><strong>Personalize Text :</strong> </strong><?php echo e($productPersonalize->text_msg); ?></td>
                        <?php endif; ?>
                    </tr>

                    <tr>
                        <td colspan="3" style="padding: 0; border: 0px;">
                            <table style="width:100%">
                                <tr>
                                    <td style="width: 14%;"><strong>Slug : </strong></td>
                                    <td><?php echo e($productdetails->slug); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Title : </strong></td>
                                    <td><?php echo e($productdetails->product_name); ?></td>
                                </tr>

                                <tr>
                                    <td><strong>Description : </strong></td>
                                    <td><?php echo $productdetails->description; ?></td>
                                </tr>
                                <?php if($productdetails->has_attribute == 'Y'): ?>
                                    <tr>
                                        <td colspan="2">
                                            <p><strong>Variation:</strong></p>
                                            <?php if(!empty($productAttribute)): ?>
                                            <table class="table table-bordered">
                                                <thead>
                                                  <tr>
                                                    <th scope="col">Id</th>
                                                    <th scope="col">Old ID</th>
                                                    <th scope="col">Content</th>
                                                    <th scope="col">Price</th>
                                                    <th scope="col">MRP</th>
                                                  </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $productAttribute; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                      <tr>
                                                        <th scope="row"><?php echo e($data->id); ?></th>
                                                        <td><?php echo e($data->sku_old); ?></td>
                                                        <td><?php echo e($data->content); ?></td>
                                                        <td><?php echo e($data->price); ?></td>
                                                        <td><?php echo e($data->actual_price); ?></td>
                                                      </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <tr>
                                        <td><strong>Content : </strong></td>
                                        <td><?php echo $productdetails->content; ?></td>
                                    </tr>
                                <?php endif; ?>    
                                <tr>
                                    <td><strong>Alt Key : </strong></td>
                                    <td><?php echo $productdetails->alt_key; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Meta Title : </strong></td>
                                    <td><?php echo $productdetails->meta_title; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Meta Description : </strong></td>
                                    <td><?php echo $productdetails->meta_description; ?></td>
                                </tr>
                            </table>


                        </td>
                    </tr>
                    
                </table>
                
            </div>
        </div>
    <?php else: ?>
        <div class="card">
            <div class="card-body">
                <h6>No Product Found</h6>
            </div>
        </div>
    <?php endif; ?>    
   
</main>

<style>
    
    table {
        border-collapse: collapse;
        width: 1000px;
    }
    td {
        border: 1px solid #eaebec;
        padding: 2px 5px;
        text-align: left;
        vertical-align: middle;
    }
    .image-box {
        border: 2px solid red;
        height: 200px;
        width: 90px;
        margin: 0 auto;
        display: flex;
        align-items: center;
        justify-content: center;
        color: red;
    }
    
</style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/product/product_view.blade.php ENDPATH**/ ?>