@extends('layouts.admin.app')

@section('content')

    {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="{{ asset('admin/assets/extra-libs/multicheck/datatable-checkbox-init.js') }}"></script>
    <script src="{{ asset('admin/assets/extra-libs/multicheck/jquery.multicheck.js') }}"></script>
    <script src="{{ asset('admin/assets/extra-libs/DataTables/datatables.min.js') }}"></script> --}}

    <link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/extra-libs/multicheck/multicheck.css') }}">
    <link href="{{ asset('admin/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css') }}" rel="stylesheet">

    <main id="main" class="main">
        @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA' || Session::get('permissions.user_type') == 'E' || Session::get('permissions.user_type') == 'OP')
	        <div class="page-breadcrumb">
			    <div class="row">
			        <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                        @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA')
			        	<h4 class="page-title">
			                <a href="{{ route('admin.product.bulkproductedit') }}"><i class="fas fa-shekel-sign fawsm"></i></a>
			                Product
			            </h4>
			            <div class="ml-auto text-right">
                            <div id="export-status"></div>
                            <button id="start-export" class="btn btn-warning" ><i class="fas fa-file-excel"></i></button>
			            	{{--<a href="{{ route('admin.product.productexceldownload') }}" class="btn btn-warning" title="Download Excel"><i class="fas fa-file-excel"></i></a>--}}
                            
                            {{--<a href="" class="btn btn-info">Product Sort</a>--}}
			                <a href="{{route('admin.product.product-add')}}" class="btn btn-success">ADD Product</a>
			            </div>
                        @endif
			        </div>
			    </div>
			</div>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                                    @if(Session::has('alert-' . $msg))
                                        <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
                                    @endif
                                @endforeach
                                <div class="product-search">
                                    <div class="prod-search-title">
                                        <h5 class="card-title">
                                            Product List
                                        </h5>
                                    </div>
                                    <div class="prod-search-body">
                                        <form action="{{route('admin.product.list')}}" id="search-form" method="post">
                                            @csrf
                                            <select class="form-control" id="category_ids" name="category_id">
                                                <option value="">Choose Category</option>
                                                <?php foreach ($category_data as $key => $category) { ?>
                                                    <option value="<?php echo $key; ?>" <?php if($request->category_id == $key){?> selected <?php } ?>><?php echo $category; ?></option>
                                                <?php } ?>
                                            </select>
                                            <input class="form-control" id="search-field" name="search" value="{{$search}}" placeholder="Search By ID / FNID / Product Title / SKU"/>
                                            <button class="btn btn-primary" type="submit" ><i class="fa fa-search"></i></button>
                                        </form>                     
                                    </div>
                                </div>
                                <div class="table-responsive" style="font-size: 13px;">
                                    <table id="zero_config" class="table table-striped table-bordered">
                                        <thead>
                                            <tr>
                                                <th style="width: 3%"><b>No.</b></th>
                                                <th style="width: 8%"><b>Image</b></th>
                                                <th style="width: 25%"><b>Title</b></th>
                                                <th style="width: 8%"><b>{!! CustomPaginator::sort('id', 'ID/SKU', ['direction' => true]) !!}</b></th>
                                                <th style="width: 38%"><b>Category</b></th>
                                                <th style="width: 9%"><b>Price</b></th>
                                                <th style="width: 9%"><b>{!! CustomPaginator::sort('is_block', 'Status', ['direction' => true]) !!}</b></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i = ($result->currentPage() - 1) * $result->perPage() + 1; ?>
                                            @if($result->count() == 0)
                                                <tr>
                                                    <td colspan="10">No records found!</td>
                                                </tr>
                                            @endif
                                            @foreach($result as $key => $products)
                                                <tr>
                                                    <td>{{ $i + $key }}</td>
                                                    <td>
                                                        @php 
                                                            $imagename = App\Http\Helper1::get_image($products->id);
                                                        @endphp

                                                        @if(isset($imagename) && $imagename->name != null )
                                                            <img src="https://giftbasketsbrazil.rightflorist.org/uploaded/product/{{$imagename->name}}" style="width:90px; height: auto;"  >
                                                            {{-- <br><br>Mobile Image:    
                                                            <img src="https://giftbasketsbrazil.rightflorist.org/uploaded/product/thumb/{{$imagename->thumb}}" style="width:90px; height: auto;"  > --}}
                                                        @else
                                                            <img src="https://giftbasketsbrazil.rightflorist.org/uploaded/no_image.jpg" style="width:90px; height: auto;"  >
                                                        @endif
                                                        <span style="color:#485256; font-size:9px; font-weight: 600">{{$products->old_id}}</span>
                                                    </td>
                                                    <td>
                                                        {{$products->product_name}}
                                                        <hr>
                                                        <b>Delay Days : </b>{{ $products->delivery_delay_days }} days
                                                        <br>
                                                            <b>Delivery Type : </b>
                                                            @if($products->delivery_type == 'C')
                                                                Courier
                                                            @else
                                                                Hand Delivery
                                                            @endif
                                                        <br>
                                                            <b>Product Type : </b> {{ $products->specification }} ( {{ ucwords($products->segregation) }} )

                                                            @php 
                                                                //echo $products->vendor_name;
                                                                $vendorDtl = App\Http\Helper1::get_vendorDtl($products->vendor_name);
                                                                //dd($vendorDtl);
                                                            @endphp
                                                            @if(!empty($products->vendor_name))
                                                            @if($vendorDtl->vendor_name != 'Normal')
                                                            <br>
                                                                <b>Vendor Type : </b> {{ $vendorDtl->vendor_name }}
                                                            @endif   
                                                            @endif  

                                                    </td>
                                                    <td>
                                                        {{$products->id}} / <span style="color:#2962ff; font-weight: 600"> {{$products->fnid}}</span>
                                                        @if(!empty($products->sku))
                                                            <span class="badge bg-secondary">{{$products->sku}}</span>
                                                        @endif
                                                        <?php
                                                            $reviewDtl = App\Http\Helper1::get_reviewDtlsbyProduct($products->id);
                                                        
                                                            if(count($reviewDtl) > 0){
                                                                $ratingSum = $avgRating = 0;
                                                                foreach($reviewDtl as $review){
                                                                    $ratingSum = $ratingSum + $review->rating;
                                                                }
                                                                $avgRating = round($ratingSum/count($reviewDtl), 1);
                                                                ?>
                                                                <hr>
                                                                {{$avgRating}} <i class="fas fa-star"></i> <br> {{count($reviewDtl)}} Reviews
                                                        <?php
                                                            }
                                                        ?>
                                                    </td>
                                                    <td>
                                                        @php
                                                            $getCategories = App\Http\Helper1::product_relatated_category_list($products->id);
                                                        @endphp
                                                        <div>
                                                            <p class="categories-texts">
                                                            @foreach($getCategories as $cat)
                                                                {!! $cat . ' | ' !!}
                                                            @endforeach
                                                            </p>
                                                            <div class="more">More</div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        @if($products->has_attribute == "Y")
                                                            @if(count($products->product_attribute) > 0)
                                                                @foreach($products->product_attribute as $attribute)
                                                                    {{-- {{$attribute->title}} --}}
                                                                    <b>&#8377; {{$attribute->price}}</b> 

                                                                    @if($attribute->actual_price > 0)
                                                                        <span style="text-decoration:line-through;"> {{$attribute->actual_price}}</span>
                                                                    @endif  

                                                                    <br> 
                                                                @endforeach
                                                            @endif

                                                        @else
                                                            <b>&#8377; {{$products->price}}</b>
                                                            @if($products->actual_price > 0)
                                                                <span style="text-decoration:line-through;"> {{$products->actual_price}}</span>
                                                            @endif

                                                        @endif
                                                        
                                                    </td>
                                                    <td>
                                                        <span class="created-dt">{{date('jS M y', strtotime($products->created_at))}}</span>
                                                        <br>
                                                        <a href="{{url('admin/product/status/')}}/{{ encrypt($products->id) }}">
                                                            <i class="fas fa-info-circle" style="font-size:18px"></i>
                                                        </a>
                                                        &nbsp;
                                                        <a href="{{url('admin/product/product-edit/')}}/{{ encrypt($products->id)}}">
                                                            <i class="fas fa-edit" style="font-size:18px"></i>
                                                        </a>
                                                        <hr style="margin: 0.3em;">
                                                        @php
                                                            $getProductStatus = App\Http\Helper1::get_productStatus($products->id);
                                                        @endphp
                                                        {!! $getProductStatus !!}
                                                        
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div style="font-size: 15px; text-align: left; display: inline;">
                                    Showing {{ $result->firstItem() }} to {{ $result->lastItem() }} of {{ $result->total() }} entries
                                </div>
                                <div class="text-center-pagination pagination" style="float:right;">
                                    {!! $result->withQueryString()->links('pagination::bootstrap-4') !!}
                                </div>
                                {{--<div><b>Last FNID {{ $lastInsertData->fnid }}</b></div>--}}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif    
        
    </main><!-- End #main -->

    <style type="text/css">
        .product-search{display: flex;justify-content: space-between; align-items: center; margin-bottom: 20px;}
        .prod-search-title{width: 30%;}
        .prod-search-body{width: 80%;}
        .prod-search-body form{display: flex;justify-content: end;gap: 3px;}
        .prod-search-body form select, .prod-search-body form input{width: 32%;}
        .fawsm{color: #3e5569;}
        .created-dt{font-size: 12px; font-weight: 700; color: #838383;}
        .switch{margin-top: 7px}
        .status-stat{display: inline;}
        .categories-texts{margin-bottom:0 !important}
        .more{padding:5px;text-align: right;color: blue;font-size: 12px;text-transform: lowercase;cursor: pointer}
        .show{height:auto !important;overflow:auto!important;}
        .lessheight{height:120px;overflow:hidden}
    </style>
            
    
    <script>
        /****************************************
         *       Basic Table                   *
         ****************************************/
        // $('#zero_config').DataTable({
        //     "order": [[7, "desc"]] 
        // });
        $(document).ready(function(){
            $(function() {
                $('form').each(function() {
                    $(this).find('input').keypress(function(e) {
                        // Enter pressed?
                        if(e.which == 10 || e.which == 13) {
                            this.form.submit();
                        }
                    });

                    $(this).find('input[type=submit]').hide();
                });
            });




            let currentPage = 1;
            let totalPages = 1;

            $('#start-export').on('click', function () {
                $('#export-status').text('Exporting... Please wait...');

                // Start with page 1 to get totalPages
                $.get('{{ url("/admin/product/export-chunk") }}', { page: 1 }, function (data) {
                    if (data.success) {
                        totalPages = data.total_pages;
                        currentPage = 2; // already did page 1
                        processNextChunk();
                    } else {
                        $('#export-status').text('Failed to start export.');
                    }
                });
            });

            function processNextChunk() {
                if (currentPage > totalPages) {
                    $('#export-status').text('Merging files and preparing download...');
                    window.location.href = '{{ url("/admin/product/download-final-excel") }}';
                    return;
                }

                $.get('{{ url("/admin/product/export-chunk") }}', { page: currentPage }, function (data) {
                    if (data.success) {
                        $('#export-status').text(`Processed page ${currentPage} of ${totalPages}`);
                        currentPage++;
                        processNextChunk();
                    } else {
                        $('#export-status').text(`Error on page ${currentPage}`);
                    }
                });
            }
        });

        
        // $(document).ready(function(){
        //     $(".more").click(function(){
        //       $('.parent-text').toggleClass('show')
        //     });
        // });
        $(document).ready(function(){
            $('.categories-texts').each(function() {
                if ($(this).height() > 120) {
                    $(this).siblings().show()
                    $(this).addClass("lessheight")
                }
                else {
                    $(this).siblings().hide()
                }
            })
            $(".more").click(function(e){
                $(e.target).siblings().toggleClass("lessheight")
                $(this).text(function(i, text){
                    return text === "Less" ? "More" : "Less";
                })
            });
        });
        
    </script> 


<script>

</script>


@endsection
