@extends('layouts.admin.app')

@section('content')

    <main id="main" class="main">



        <div class="container">

            <div class="info-box card" style="padding: 10px 12px;">
                <h5>Filters 
                    @if($request->agents != null || $request->date_type != null || $request->fromDate != null || $request->toDate != null || $request->delstatus != null)
                        <a href="{{ route('admin.order.assign-order-list') }}" style="font-size: 16px; padding-left: 10px;" ><span class="badge bg-danger"><i class="bi bi-node-minus"></i> Clear Filter</span></a>
                    @endif
                </h5>
                <form action="{{ route('admin.order.assign-order-list') }}" method="get" onsubmit="return validateForm();">
                    <div class="row">
                        <div class="col-2">
                            <label>Agents</label>
                            <select name="agents" id="agents" class="form-control">
                                <option value="" selected>Select Agent</option>
                                @foreach($agents as $agent)
                                    <option value="{{ $agent->id }}" @if($request->agents == $agent->id) selected @endif>{{ ucwords($agent->name) }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-2">
                            <label>Date Type</label>
                            <select name="date_type" id="date_type" class="form-control">
                                <option value="" selected>Select Date Type</option>
                                <option value="d_date" @if($request->date_type == 'd_date') selected @endif>Delivery Date</option>
                                <option value="a_date" @if($request->date_type == 'a_date') selected @endif>Assign Date</option>
                            </select>
                        </div>
                        <div class="col-2">
                            <label>Date From</label>
                            <input type="date" name="fromDate" id="FromDate" class="form-control" value="{{ $request->fromDate }}" />
                        </div>
                        <div class="col-2">
                            <label>Date To</label>
                            <input type="date" name="toDate" id="toDate" class="form-control" value="{{ $request->toDate }}" />
                        </div>
                        <div class="col-2">
                            <label>Delivery Status</label>
                            <select name="delstatus" id="delstatus" class="form-control">
                                <option value="" selected>SELECT STATUS</option>
                                <option value="P" @if($request->delstatus =='P') selected @endif>PENDING</option>
                                <option value="PC" @if($request->delstatus =='PC') selected @endif>ACCEPTED</option>
                                <option value="S" @if($request->delstatus =='S') selected @endif>SHIPPED</option>
                                <option value="D" @if($request->delstatus =='D') selected @endif>DELIVERED</option>
                                <option value="H" @if($request->delstatus =='H') selected @endif>HOLD</option>
                                <option value="CL" @if($request->delstatus =='CL') selected @endif>CANCELED</option>
                            </select>
                        </div>
                        <div class="col-2" style="padding-top:20px">
                            <button class="btn btn-primary filtersearch" type="submit">Search</button>
                            
                        </div>
                    </div>
                </form>
            </div>

            <div class="row">
                <div class="col-8">
                    <h5 class="card-title">Assign Order List</h5>

                </div>
                <div class="col-4 ms-auto text-end" style="display:flex; align-items: center;">
                    <form method="GET" action="{{ route('admin.order.assign-order-list') }}" style="width:100%" >
                        <div class="input-group">
                          <input type="text" name="search" id="search-field" class="form-control" placeholder="Search by Order ID" autocomplete="off" required>
                          <button type="submit" class="input-group-text"><i class="bx bx-search-alt"></i></button>
                        </div>
                    </form>
                </div>
            </div>

            @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                @if(Session::has('alert-' . $msg))
                    <div class="alert alert-{{ $msg }} alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-1"></i>
                        {{ Session::get('alert-' . $msg) }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
            @endforeach

            @if($request->search != null)
                <p style="font-size: 13px;">
                    Searched for: "{{ $request->search }}" <a href="{{ route('admin.order.assign-order-list') }}" style="font-size: 13px; padding-left: 10px;" class="badge border-danger border-1 text-danger">Clear Search</a>
                </p>
            @endif


            @if(count($result) > 0)

                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th scope="col" style="width:5%">#</th>
                            <th scope="col" style="width:14%">Assign Order Id</th>
                            <th scope="col" style="width:15%">{!! CustomPaginator::sort('agent_id', 'Agent Name') !!}</th>
                            <th scope="col" style="width:22%">Products</th>
                            <th scope="col" style="width:11%">{!! CustomPaginator::sort('delivery_date', 'Delivery Date') !!}</th>
                            <th scope="col" style="width:12%">{!! CustomPaginator::sort('status', 'Delivery Status') !!}</th>
                            <th scope="col" style="width:14%">{!! CustomPaginator::sort('created_at', 'Agent Placed Date') !!}</th>
                            <th scope="col" style="width:4%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php $i = ($result->currentPage() - 1) * $result->perPage() + 1; @endphp
                        @foreach($result as $key => $order)
                        
                        <tr>
                            <td scope="row">{{ $i + $key }}</td>
                            <td>
                                {{ $order->agent_order_id }}<br>
                                @php
                                    $orderDtl = App\Http\Helper1::getorderDtl($order->OID); 
                                @endphp
                                <span class="badge rounded-pill bg-light text-primary">{{ $orderDtl->unique_order_id }}</span>
                            </td>
                            <td>
                                @php
                                    $agentDtl = App\Http\Helper1::getAgentDtl($order->agent_id); 
                                @endphp
                                {{ ucwords($agentDtl->name) }}
                            </td>
                            <td>
                                @php
                                    $agentProductDtl = App\Http\Helper1::getAgentPlaceProductDtl($order->id); 
                                @endphp
                                @foreach($agentProductDtl as $product)
                                    {{ucwords($product->item)}}<span style="color:grey">({{$product->qty}})</span> 
                                    @if(!$loop->last), @endif
                                @endforeach
                            </td>
                            <td>{{ date("d/m/Y" , strtotime($order->delivery_date)) }}</td>
                            <td>
                                <h5>
                                    @if($order->status == 'P')
                                        <span class="badge bg-danger">Pending</span>
                                    @elseif($order->status == 'PC')
                                        <span class="badge bg-info">Accepted</span>
                                    @elseif($order->status == 'H')
                                        <span class="badge bg-warning">Hold</span>
                                    @elseif($order->status == 'CL')
                                        <span class="badge bg-dark">Cancel</span>
                                    @elseif($order->status == 'D')
                                        <span class="badge bg-success">Delivered</span>
                                    @elseif($order->status == 'S')
                                        <span class="badge bg-primary">Shipped</span>
                                    @endif
                                </h5>
                            </td>
                            <td>{{ date("d/m/Y H:m" , strtotime($order->created_at)) }}</td>
                            <td>
                                <div class="row">
                                    <div class="col">
                                        <a href="{{url('/admin/order/assign-order-view')}}/{{encrypt($order->agent_order_id)}}/{{encrypt($order->agent_id)}}"><i class="ri-file-edit-fill adminedit"></i></a>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>

                <div>
                    <table  class="table">
                        @if ($result->hasPages())
                        <tr>
                            <td style="width:auto; text-align:center; border:none;" >
                                <nav role="navigation" aria-label="Pagination Navigation" class="flex justify-between">
                                <span>
                                    @if ($result->onFirstPage())
                                        <span></span>
                                    @else
                                        <a href="{{ $result->previousPageUrl() }}" class="btn btn-secondary btn-sm" rel="prev"><i class="bx bxs-chevron-left"></i></a>
                                    @endif
                                </span>
                                    @foreach(range(1, $result->lastPage()) as $i)
                                        @if($i >= $result->currentPage() - 2 && $i <= $result->currentPage() + 2)
                                            @if ($i == $result->currentPage())
                                            <a href="" class="btn btn-secondary btn-sm" style="background: white;color: black;">{{ $i }}</a>
                                            @else
                                            <a href="{{ $result->url($i) }}" class="btn btn-secondary btn-sm">{{ $i }}</a>
                                            @endif
                                        @endif
                                    @endforeach
                                <span>
                                    @if ($result->hasMorePages())
                                         <a href="{{ $result->nextPageUrl() }}" rel="next" class="btn btn-secondary btn-sm" ><i class="bx bxs-chevron-right"></i></a>
                                    @else
                                        <span></span>
                                    @endif
                                    </span>
                                </nav>
                            </td>
                        </tr>
                        @endif   
                    </table>
                </div>

            @else
                <div class="card" style="padding: 10px 12px;">No Data Found...</div>
            @endif

            
            {{-- <a class="btn btn-danger" href="{{url('/admin/order/assign-order-list')}}">Back</a> --}}
        </div>
    </main>

<script>

function validateForm() {
    var agents = $('#agents').val();
    var dateType = $('#date_type').val();
    var fromDate = $('#FromDate').val();
    var toDate = $('#toDate').val();
    var delstatus = $('#delstatus').val();

    if (agents === "" && dateType === "" && fromDate === "" && toDate === "" && delstatus === "") {
        return false;
    }

    // Rule 1: If date_type is selected, both fromDate and toDate are required
    if (dateType !== "") {
        if (fromDate === "") {
            //alert("Please select From Date.");
            $('#FromDate').focus();
            return false;
        }

        if (toDate === "") {
            //alert("Please select To Date.");
            $('#toDate').focus();
            return false;
        }
    }

    // Rule 2: If one date is filled, the other must be filled too
    if (fromDate !== "" && toDate === "") {
        //alert("Please select To Date.");
        $('#toDate').focus();
        return false;
    }

    if (toDate !== "" && fromDate === "") {
        //alert("Please select From Date.");
        $('#FromDate').focus();
        return false;
    }

    return true; // All validation passed
}
    
</script>

@endsection