@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Edit Agent</h4>
                    <div class="ml-auto text-right">
                        <a href="{{url('/admin/agent/all-agents')}}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
		    <div class="row">
		        <div class="col-12">
		            <div class="card">
		                <form action="{{url('/admin/agent/edit')}}/{{encrypt($agentDetails->id)}}" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">
		                    @csrf
		                    <div class="card-body">
		                        <h4 class="card-title">Modify Agent</h4>
		                        
		                        <input type="hidden" name="agent_id" value="<?php echo $agentDetails->id; ?>">

                                <div class="form-group m-t-20">
                                    <label>Agent Name</label>
                                    <input type="text" class="form-control" id="name" name="name" value="{{$agentDetails->name}}" placeholder="Enter Agent Name" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Agent Email</label>
                                    <input type="email" class="form-control" id="email" name="email" value="{{$agentDetails->email}}" placeholder="Enter Agent Email" required>
                                    @error('email')
                                      <div class="alert alert-danger" role="alert">
                                        {{ $message }}
                                      </div>
                                    @enderror
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Password</label>
                                    <input type="password" class="form-control" id="password" name="password" placeholder="Enter Password" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Confirm Password</label>
                                    <input type="password" class="form-control" id="cpassword" name="cpassword" placeholder="Confirm your password!" required>
                                    @error('cpassword')
                                        <div class="alert alert-danger" role="alert">
                                          {{ $message }}
                                        </div>
                                    @enderror
                                </div>
		                    </div>
		                    <div class="border-top">
		                        <div class="card-body">
		                            <input class="btn btn-primary" type="submit" value="UPDATE">
		                        </div>
		                    </div>
		                </form>
		            </div>
		        </div>
		    </div>
		</div>
</main> 

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
  

<script type="text/javascript">

</script>     

@endsection