@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>

<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
    @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA')
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Addon Group</h4>
                    <div class="ml-auto text-right">
                        <a href="{{ route('admin.addon.addon_group') }}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <!-- ============================================================== -->
            <!-- Start Page Content -->
            <!-- ============================================================== -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                            @if(Session::has('alert-' . $msg))
                                <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
                            @endif
                        @endforeach
                        <form action="{{route('admin.addon.addon_group_edit', [base64_encode($dataDetails->id)])}}" method="POST" class="form-horizontal" id="formadd"  >
                            @csrf
                            <div class="card-body">
                                <h4 class="card-title">Addon Group Edit</h4>
                                
                                <input type="hidden" name="formid" value="<?php echo $dataDetails->id; ?>">

                                <div class="form-group m-t-20">
                                    <label>Title</label>
                                    <input type="text" class="form-control" id="title" name="title" placeholder="Enter Title" value="{{$dataDetails->title}}" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Slug</label>
                                    <input type="text" class="form-control" id="slug" name="slug" placeholder="Enter Slug" value="{{$dataDetails->slug}}" readonly>
                                </div>
                                {{--<div class="form-group m-t-20">
                                    <label>Type</label>
                                    <input type="text" class="form-control" id="type" name="type" placeholder="Enter Type" value="{{$dataDetails->type}}" required>
                                </div>--}}
                                <div class="form-group m-t-20">
                                    <label>Type<span>*</span></label>
                                    <select id="type" name="type" class="form-control" aria-required="true" required>
                                        <option value="">-Select Addon Type-</option>
                                        <option value="Extra" {{ $dataDetails->type == "Extra" ? 'selected' : '' }}>Extra</option>
                                        <option value="Addon" {{ $dataDetails->type == "Addon" ? 'selected' : '' }}>Addon</option>
                                    </select>
                                </div>
                            </div>
                            <div class="border-top">
                                <div class="card-body">
                                    <input class="btn btn-primary" type="submit" value="UPDATE">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
</main>    
<script type="text/javascript">

    $.validator.setDefaults({
            submitHandler: function(form) {
                form.submit();
            }
    });
    $(function() {
        // validate the comment form when it is submitted
        $("#formadd").validate({
            ignore: [],
            errorPlacement: function(label, element) {
                label.addClass('mt-2 text-danger');
                label.insertAfter(element);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass('has-danger')
                $(element).addClass('form-control-danger')
            }
          });
    });

    $('#title').on('blur', function(){
        var title = $.trim($(this).val());
        if(title != ''){
            //if($.trim($('#slug').val()) == ''){
                $('#slug').val(title.replace(/ /g,"-").toLowerCase());
                $('#slug-error').hide();
            //}
        }
    });

</script>  

@endsection