<?php $__env->startSection('content'); ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Edit Agent</h4>
                    <div class="ml-auto text-right">
                        <a href="<?php echo e(url('/admin/agent/all-agents')); ?>" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
		    <div class="row">
		        <div class="col-12">
		            <div class="card">
		                <form action="<?php echo e(url('/admin/agent/edit')); ?>/<?php echo e(encrypt($agentDetails->id)); ?>" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">
		                    <?php echo csrf_field(); ?>
                            <div class="card-body">
                            <h4 class="card-title">Update Agent</h4>

                            <div class="form-group m-t-20">
                                <label>Agent Name</label>
                                <input type="text" class="form-control" name="name" placeholder="Enter Agent Name" value="<?php echo e($agentDetails->name); ?>" required>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Agent Email</label>
                                <input type="email" class="form-control" name="email" placeholder="Enter Agent Email" value="<?php echo e($agentDetails->email); ?>" required>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Contact Person</label>
                                <input type="text" class="form-control" name="contact_person" placeholder="Enter Contact Person" value="<?php echo e($agentDetails->contact_person); ?>">
                            </div>

                            <div class="form-group m-t-20">
                                <label>Alternate Email(s)</label>
                                <div id="altEmailWrapper">
                                    <?php if(!empty($agentDetails->alternate_email)): ?>
                                        <?php $__currentLoopData = json_decode($agentDetails->alternate_email); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alternateEmail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="input-group mb-2">
                                                <input type="email" class="form-control" name="alt_email[]" placeholder="Enter Alternate Email" value="<?php echo e($alternateEmail); ?>">
                                                <button type="button" class="btn btn-success addEmail">+</button>
                                                <button type="button" class="btn btn-danger removeField">-</button>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Phone No</label>
                                <input type="text" class="form-control" name="phone_no" placeholder="Enter Phone No" value="<?php echo e($agentDetails->phone_no); ?>" required>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Alternate Phone No(s)</label>
                                <div id="altPhoneWrapper">
                                    <?php if(!empty($agentDetails->alternate_phone_no)): ?>
                                        <?php $__currentLoopData = json_decode($agentDetails->alternate_phone_no); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alternate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="input-group mb-2">
                                                <input type="text" class="form-control" name="alt_phone[]" value="<?php echo e($alternate); ?>" placeholder="Enter Alternate Phone No">
                                                <button type="button" class="btn btn-success addPhone">+</button>
                                                <button type="button" class="btn btn-danger removeField">-</button>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Address</label>
                                <textarea class="form-control" name="address" placeholder="Enter Address" value="<?php echo e($agentDetails->address); ?>" required><?php echo e($agentDetails->address); ?></textarea>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Agent Type</label>
                                <select name="agent_type" class="form-control" required>
                                    <option value="">Select Agent Type</option>
                                    <option value="H/Hand-delivery" <?php echo e($agentDetails->agent_spec == "Hand-delivery" ? 'selected' : ''); ?>>Hand Delivery</option>
                                    <option value="C/Courier" <?php echo e($agentDetails->agent_spec == "Courier" ? 'selected' : ''); ?>>Courier</option>
                                    <option value="C/Third-party-vendor" <?php echo e($agentDetails->agent_spec == "Third-party-vendor" ? 'selected' : ''); ?>>Third Party Vendor</option>
                                </select>
                            </div>
                        </div>
		                    <div class="border-top">
		                        <div class="card-body">
		                            <input class="btn btn-primary" type="submit" value="UPDATE">
		                        </div>
		                    </div>
		                </form>
		            </div>
		        </div>
		    </div>
		</div>
</main> 

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
  

<script type="text/javascript">
$(document).ready(function(){
    // Add Alternate Email
    $(document).on('click', '.addEmail', function(){
        $('#altEmailWrapper').append(`
            <div class="input-group mb-2">
                <input type="email" class="form-control" name="alt_email[]" placeholder="Enter Alternate Email">
                <button type="button" class="btn btn-danger removeField">-</button>
            </div>
        `);
    });

    // Add Alternate Phone
    $(document).on('click', '.addPhone', function(){
        $('#altPhoneWrapper').append(`
            <div class="input-group mb-2">
                <input type="text" class="form-control" name="alt_phone[]" placeholder="Enter Alternate Phone No">
                <button type="button" class="btn btn-danger removeField">-</button>
            </div>
        `);
    });

    // Remove Field
    $(document).on('click', '.removeField', function(){
        $(this).closest('.input-group').remove();
    });

    // Password Match Validation
    $('#formadd').on('submit', function(){
        let pass = $('#password').val();
        let cpass = $('#cpassword').val();
        if(pass !== cpass){
            alert('Password and Confirm Password must match!');
            return false;
        }
    });
});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/agent/agent_edit.blade.php ENDPATH**/ ?>