<?php $__env->startSection('content'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<main id="main" class="main">
   <div class="page-breadcrumb">
      <div class="row">
         <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
            <h4 class="page-title">Agents List</h4>
            <div class="ml-auto text-right">
               <a href="<?php echo e(route('admin.agent.add')); ?>" class="btn btn-success">Add Agent</a>
            </div>
         </div>
      </div>
   </div>
   <div class="container-fluid">
      <div class="row">
         <div class="col-12">
            <div class="card">
               <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php if(Session::has('alert-' . $msg)): ?>
                  <div class="alert alert-<?php echo e($msg); ?> alert-dismissible fade show" role="alert">
                     <?php echo e(Session::get('alert-' . $msg)); ?>

                     <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                  </div>
                  <?php endif; ?>
               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
               <div class="card-body">
                  <h5 class="card-title">List of Agents</h5>
                  <?php if(count($agents) > 0): ?>
                  <div class="table-responsive">
                     <table id="zero_config" class="table table-striped table-bordered">
                        <thead>
                           <tr>
                              <th scope="col">Sl No.</th>
                              <th scope="col">Name</th>
                              <th scope="col">Email</th>
                              <th scope="col">Created At</th>
                              
                              <th scope="col" colspan="2" style="text-align:center;">Action</th>
                           </tr>
                        </thead>
                        <tbody>
                           <?php $i=1; ?>
                           <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           <tr>
                              <td><?php echo e($i+$key); ?></td>
                              <td><?php echo e(ucwords($agent->name)); ?></td>
                              <td><?php echo e($agent->email); ?></td>
                              <td><?php echo e($agent->created_at); ?></td>
                              
                              <td><a href="<?php echo e(url('/admin/agent/edit')); ?>/<?php echo e(encrypt($agent->id)); ?>"><i class="fas fa-edit"></i></a>
                              <td><a href="<?php echo e(url('/admin/agent/profile')); ?>/<?php echo e(encrypt($agent->id)); ?>"><i class="fas fa-eye"></i></a>
                              </td>
                           </tr>
                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                     </table>
                  </div>
                  <?php else: ?>
                     <div class="card">No Data Found...</div>
                  <?php endif; ?>
               </div>
            </div>
         </div>
      </div>
   </div>
</main>
<!-- End #main -->
<script>

   document.addEventListener("DOMContentLoaded", function () {
       const table = document.querySelector("#zero_config");
       const dataTable = new simpleDatatables.DataTable(table, {
           sortable: true,
           fixedHeight: true,
           columns: [
               { select: 0, sort: "asc" } // Sort by the 6th column (index 5) descending
           ]
       });
   });
   
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/agent/all_agents_list.blade.php ENDPATH**/ ?>