@extends('layouts.admin.app')

@section('content')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <main id="main" class="main">

        @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA')

	        <div class="page-breadcrumb">

                <div class="row">

                    <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">

                        <h4 class="page-title">User Management</h4>

                        <div class="ml-auto text-right">

                            {{--<a href="{{route('admin.cms.add')}}" class="btn btn-success">ADD CMS</a>--}}

                        </div>

                    </div>

                </div>

            </div>

            <div class="container-fluid">

                <div class="row">

                    <div class="col-12">

                        <div class="card">

                            <div class="card-body">

                                @foreach (['danger', 'warning', 'success', 'info'] as $msg)

                                    @if(Session::has('alert-' . $msg))

                                        <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>

                                    @endif

                                @endforeach

                                <h5 class="card-title">User Management</h5>

                                @if(count($result) > 0)

                                <div class="table-responsive">

                                    <table id="zero_config" class="table table-striped table-bordered">

                                        <thead>

                                            <tr>

                                                <th style="width: 5%"><b>No.</b></th>

                                                <th style="width: 20%"><b>Name</b></th>

                                                <th style="width: 15%"><b>Email</b></th>
                                                <th style="width: 5%"><b>Site Name</b></th>
                                                <th style="width: 6%"><b>Mobile No</b></th>

                                                <th style="width: 15%"><b>Created Date</b></th>

                                                {{--<th style="width: 9%">Action</th>--}}

                                            </tr>

                                        </thead>

                                        <tbody>

                                            @php $i=1; @endphp

                                            @foreach($result as $key => $data)

                                            <tr>

                                                <td>{{ $i + $key }}</td>

                                                <td>{{$data->name}}</td>

                                                <td>{{$data->email}}</td>
                                                <td>{{strtoupper($data->sitename)}}</td>
                                                <td>{{$data->mobile}}</td>

                                                <td>{{date('d-m-Y', strtotime($data->created_at))}}</td>

                                                {{--<td>

                                                    <label class="switch">

                                                        <input type="checkbox" class="blockstatus" name="stat" id="stat" data-id="{{ base64_encode($data->id) }}" @if($data->is_block == 'N') checked @endif>

                                                        <span class="slider roundsemi"></span>

                                                    </label>

                                                    <label id="status-info-{{ $data->id }}" class="status-stat"></label>

                                                </td>

                                                <td>

                                                    <a href="">

                                                        <i class="fas fa-edit"></i>

                                                    </a>

                                                </td>--}}

                                            </tr>

                                            @endforeach

                                        </tfoot>

                                    </table>

                                </div>

                                @else

                                    <div class="card">No Data Found...</div>

                                @endif

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        @endif    

    </main><!-- End #main -->

    <script>

        /****************************************

         *       Basic Table                   *

         ****************************************/

        // $('#zero_config').DataTable({

        //     "order": [[5, "desc"]] 

        // });

        document.addEventListener("DOMContentLoaded", function () {
            const table = document.querySelector("#zero_config");
            const dataTable = new simpleDatatables.DataTable(table, {
                sortable: true,
                fixedHeight: true,
                columns: [
                    { select: 0, sort: "asc" } // Sort by the 6th column (index 5) descending
                ]
            });
        });


        // $(function(){
        //     setTimeout(function(){ $('.alert').hide(); }, 3000);
        //     var status, id;
        //     $('#zero_config').on('change', '.blockstatus', function() {
        //     //$('.blockstatus').change(function(){
        //         if(this.checked){
        //             status = 'Y';
        //         }else{
        //             status = 'N'
        //         }
        //         id = $(this).attr('data-id');
        //         var ajaxurl = ""; 
        //         $.ajax({
        //             type : 'POST',
        //             url : ajaxurl,
        //             data : { 'id' : id, 'status' : status },
        //             headers: {
        //                     'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        //             },
        //             success : function(response){
        //                 response = JSON.parse(response);
        //                 if(response.status == 1){
        //                     $('#status-info-'+response.id).html(response.event).fadeIn(100).delay(1000).fadeOut();
        //                     location.reload(true);
        //                 }
        //             },
        //             error : function(){
        //                 $('.selected_records_data').html('<span class="error-msg text-danger">There was an unexpected error!! Please try again later.</span>');
        //             }
        //         });
        //     });
        // })


    </script>

@endsection

