@extends('layouts.admin.app')

@section('content')


<main id="main" class="main">

    {{-- <div class="pagetitle row">
        <div class="col-10">
            <h1>Orders</h1>
            <nav>
                <ol class="breadcrumb">
                  <li class="breadcrumb-item"><a href="{{ url('/admin/home') }}">Home</a></li>
                  <li class="breadcrumb-item active">Orders</li>
                </ol>
            </nav>
        </div>
    </div> --}}

    <div class="page-breadcrumb">
        <div class="row">
            <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                
                    <h4 class="page-title">
                        Orders
                    </h4>
                    <div class="ml-auto text-right">
                        <!-- badge bg-light text-dark  -->
                        @if(!empty($request->orderstatus))
                            <a href="{{ url('admin/order') }}" class="btn btn-outline-secondary btn-sm">ALL</a>
                        @endif
                        @if($request->orderstatus != 'P')
                            <a href="{{ url('admin/order?orderstatus=P') }}" class="btn btn-outline-danger btn-sm">PENDING</a>
                        @endif
                        @if($request->orderstatus != 'PC')
                            <a href="{{ url('admin/order?orderstatus=PC') }}" class="btn btn-outline-info btn-sm">PROCESSED</a>
                        @endif
                        @if($request->orderstatus != 'S')
                            <a href="{{ url('admin/order?orderstatus=S') }}" class="btn btn-outline-primary btn-sm">SHIPPED</a>
                        @endif
                        @if($request->orderstatus != 'D')    
                            <a href="{{ url('admin/order?orderstatus=D') }}" class="btn btn-outline-success btn-sm">DELIVERED</a>
                        @endif
                        @if($request->orderstatus != 'H')
                            <a href="{{ url('admin/order?orderstatus=H') }}" class="btn btn-outline-warning btn-sm">HOLD</a>
                        @endif
                        @if($request->orderstatus != 'CL')
                            <a href="{{ url('admin/order?orderstatus=CL') }}" class="btn btn-outline-dark btn-sm">CANCEL</a>
                        @endif
                    </div>
                
            </div>
        </div>
    </div>

    <section class="section">
        <div class="row">
            <div class="col-lg-12">
            
                <div class="card">
                    <div class="card-body">

                        <div class="row">
                            <div class="col-8">
                                <h5 class="card-title">
                                    
                                    @switch($request->orderstatus)
                                        @case('P')
                                            Pending Order List
                                            @break

                                        @case('PC')
                                            Processed Order List
                                            @break

                                        @case('H')
                                            Hold Order List
                                            @break

                                        @case('CL')
                                            Cancel Order List
                                            @break

                                        @case('D')
                                            Delivered Order List
                                            @break

                                        @case('S')
                                            Shipped Order List
                                            @break

                                        @default
                                            Order List
                                    @endswitch
                                </h5>

                            </div>
                            <div class="col-4 ms-auto text-end" style="display:flex; align-items: center;">
                                <form method="GET" action="{{ route('admin.order.list') }}" style="width:100%" >
                                    <div class="input-group">
                                      <input type="text" name="search" id="search-field" class="form-control" placeholder="Search" autocomplete="off" required>
                                      <button type="submit" class="input-group-text"><i class="bx bx-search-alt"></i></button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                            @if(Session::has('alert-' . $msg))
                                <div class="alert alert-{{ $msg }} alert-dismissible fade show" role="alert">
                                    <i class="bi bi-check-circle me-1"></i>
                                    {{ Session::get('alert-' . $msg) }}
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @endif
                        @endforeach

                        @if($request->search != null)
                            <p style="font-size: 13px;">
                                Searched for: "{{ $request->search }}" <a href="{{ route('admin.order.list') }}" style="font-size: 13px; padding-left: 10px;" class="badge border-danger border-1 text-danger">Clear Search</a>
                            </p>
                        @endif

                        @if(count($result) > 0)

                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th scope="col" style="width:6%">#</th>
                                    <th scope="col" style="width:13%">Order ID</th>
                                    <th scope="col" style="width:12%">{!! CustomPaginator::sort('created_at', 'Order Date') !!}</th>
                                    <th scope="col" style="width:12%">Delivery Date</th>
                                    <th scope="col" style="width:12%">Customer Name</th>
                                    <th scope="col" style="width:24%">Agent Placed Order Status</th>
                                    <th scope="col" style="width:6%">Pay Mode</th>
                                    <th scope="col" style="width:11%">{!! CustomPaginator::sort('order_delivery_status', 'Order Status') !!}</th>
                                    <th scope="col" style="width:3%">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $i = ($result->currentPage() - 1) * $result->perPage() + 1; @endphp
                                @foreach($result as $key => $order)
                                <?php 
                                    $orDtl = App\Http\Helper1::reportOrderDtl($order->id); 
                                    $agentAssingedDetails = $agent_assinged->where('OID',$order->id);
                                ?>
                                <tr>
                                    <td scope="row">{{ $i + $key }}</td>
                                    <td>{{ $order->unique_order_id }}</td>
                                    <td>
                                        @if( $order->purchase_date != NULL)
                                            {{ date("d/m/Y H:i" , strtotime($order->purchase_date)) }}
                                        @else
                                            {!! 'NA' !!}
                                        @endif
                                    </td>
                                    <td>{!! $orDtl['deliveryDate'] !!}</td>
                                    <td>{!! $order->billing_user_name !!}</td>
                                    <td>
                                        <?php //dd($agentAssingedDetails); ?>
                                        @foreach($agentAssingedDetails as $agents)
                                            @php
                                                $agentDtl = App\Http\Helper1::getAgentDtl($agents->agent_id); 
                                            @endphp

                                            <b>{{ ucwords($agentDtl->name) }}</b>
                                            @if($agents->status == 'P')
                                                <span class="badge bg-danger">PENDING</span>
                                            @elseif($agents->status == 'PC')
                                                <span class="badge bg-info">ACCEPTED</span>
                                            @elseif($agents->status == 'CL')
                                                <span class="badge bg-dark">CANCELED</span>
                                            @elseif($agents->status == 'H')
                                                <span class="badge bg-warning">HOLD</span>
                                            @elseif($agents->status == 'D')
                                                <span class="badge bg-success">DELIVERED</span>
                                            @elseif($agents->status == 'S')
                                                <span class="badge bg-primary">SHIPPED</span>
                                            @endif
                                            @if(!$loop->last) <hr style="margin: 0.5rem 0; opacity: 0.15;"> @endif    
                                        @endforeach
                                    </td>
                                    <td>
                                        {{-- <h6>
                                            @if($order->payment_method == 1)
                                                <span class="badge bg-secondary">COD</span>
                                            @elseif($order->payment_method == 2)
                                                <span class="badge bg-secondary">Paypal</span>
                                            @elseif($order->payment_method == 3)
                                                <span class="badge bg-secondary">PayU</span>
                                            @elseif($order->payment_method == 4)
                                                <span class="badge bg-secondary">Bank Transfer</span>
                                            @elseif($order->payment_method == 5)
                                                <span class="badge bg-secondary">Razorpay</span>
                                            @endif
                                        </h6> --}}

                                        {{-- @if($order->type == 'cart')
                                            In Cart
                                        @elseif($order->type == 'order')
                                            Ordered
                                        @endif --}}
                                        
                                        @if( $order->payment_status == 'C')
                                            <span class="badge bg-success">
                                                {{-- <i class="bi bi-check-circle me-1"></i>  --}}
                                                <span class="badge bg-white text-success">
                                                    @if($order->payment_method == 1)
                                                        <i class="bi bi-check-circle me-1" title="COD"></i>
                                                    @elseif($order->payment_method == 2)
                                                        <i class="ri-paypal-fill" title="Paypal"></i>
                                                    @elseif($order->payment_method == 3)
                                                        <i class="bi bi-check-circle me-1" title="PayU"></i>
                                                    @elseif($order->payment_method == 4)
                                                        <i class="bi bi-check-circle me-1" title="Bank Transfer"></i>
                                                    @elseif($order->payment_method == 5)
                                                        <i class="bi bi-check-circle me-1" title="Razorpay"></i>
                                                    @endif
                                                </span>
                                                Success
                                            </span>
                                            
                                            {{-- <span class="badge rounded-pill bg-success">SUCCESS</span> --}}
                                        @elseif($order->payment_status == 'P')
                                            <span class="badge rounded-pill bg-secondary">PENDING</span>
                                        @endif
                                    </td>
                                    <td>
                                        <h5>
                                            @if($order->order_delivery_status == 'P')
                                                <span class="badge bg-danger">Pending</span>
                                            @elseif($order->order_delivery_status == 'PC')
                                                <span class="badge bg-info">Processed</span>
                                            @elseif($order->order_delivery_status == 'H')
                                                <span class="badge bg-warning">Hold</span>
                                            @elseif($order->order_delivery_status == 'CL')
                                                <span class="badge bg-dark">Cancel</span>
                                            @elseif($order->order_delivery_status == 'D')
                                                <span class="badge bg-success">Delivered</span>
                                            @elseif($order->order_delivery_status == 'S')
                                                <span class="badge bg-primary">Shipped</span>
                                            @endif
                                        </h5>
                                    </td>
                                    
                                    <td>
                                        <div class="row">
                                            <div class="col">
                                                <a href="{{ route('admin.order.view', base64_encode($order->id)) }}">
                                                    <i class="bx bx-edit adminedit"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                        <div>
                            <table  class="table">
                                @if ($result->hasPages())
                                <tr>
                                    <td style="width:auto; text-align:center; border:none;" >
                                        <nav role="navigation" aria-label="Pagination Navigation" class="flex justify-between">
                                        <span>
                                            @if ($result->onFirstPage())
                                                <span></span>
                                            @else
                                                <a href="{{ $result->previousPageUrl() }}" class="btn btn-secondary btn-sm" rel="prev"><i class="bx bxs-chevron-left"></i></a>
                                            @endif
                                        </span>
                                            @foreach(range(1, $result->lastPage()) as $i)
                                                @if($i >= $result->currentPage() - 2 && $i <= $result->currentPage() + 2)
                                                    @if ($i == $result->currentPage())
                                                    <a href="" class="btn btn-secondary btn-sm" style="background: white;color: black;">{{ $i }}</a>
                                                    @else
                                                    <a href="{{ $result->url($i) }}" class="btn btn-secondary btn-sm">{{ $i }}</a>
                                                    @endif
                                                @endif
                                            @endforeach
                                        <span>
                                            @if ($result->hasMorePages())
                                                 <a href="{{ $result->nextPageUrl() }}" rel="next" class="btn btn-secondary btn-sm" ><i class="bx bxs-chevron-right"></i></a>
                                            @else
                                                <span></span>
                                            @endif
                                            </span>
                                        </nav>
                                    </td>
                                </tr>
                                @endif   
                            </table>
                        </div>

                        @else
                            <div class="card">No Data Found...</div>
                        @endif
                    </div>
                </div>

            </div>
        </div>
    </section>

</main>

@endsection

@section('script')

<script>


    
</script>

@endsection