<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
    <title>{{ config('global.website_title') }}</title>
    <style>
        *
        {
            padding: 0;
            margin: 0;
        }

        @font-face {
            font-family: 'noto_sans_devanagari';
            src: url("{{ storage_path('fonts/NotoSansDevanagari-Regular.ttf') }}") format('truetype');
        }
        body {
            font-family: 'noto_sans_devanagari', sans-serif;
            /*font-size: 15px*/
        }

        .container690 {
            width: 100%;
            margin: 0 auto;
        }

        .imgsec {
            padding: 36px 20px;
        }

        @media only screen and (max-width: 1023px) {
            .container690 {
                width: 90%;
                margin: 0 auto;
            }

            .imgsec img {
                width: 98%;
                margin: 0 5px 0 0;
                float: left;
                display: inline-block;
            }

            p {
                font-size: 14px !important;
            }

            .footcont p {
                font-size: 10px !important;
                text-align: center;
            }
        }
    </style>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-LN+7fdVzj6u52u30Kp6M/trliBMCMKTyK833zpbD+pXdCLuTusPj697FH4R/5mcr" crossorigin="anonymous">
</head>

<body>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="container690"
       style="background-color: white; font-size:13px; font-family:sans-serif; width: 100%; color: #404040">

    <tr><td style="font-size:13px; line-height:21px;">Dear Sir/Madam,</td></tr>
    <tr><td style="font-size:13px; line-height:25px; padding: 15px 0">Please find our order details given below.</td></tr>

    <tr><td style="line-height:20px;"><strong>Order ID:</strong>  <b>{{ $data['agent_assinged']->agent_order_id }}</b></td></tr>

    <tr><td style="line-height:20px;">
        <strong>Delivery Address:</strong><br>
        {!! $data['order_dtl']->delivery_user_name !!}<br>
        {!! $data['order_dtl']->delivery_address !!},<br>
        {!! $data['order_dtl']->delivery_country !!},<br>
        {!! $data['order_dtl']->delivery_city !!},<br>
        {!! $data['order_dtl']->delivery_state !!} - {!! $data['order_dtl']->delivery_pincode !!}
    </td></tr>

    <tr><td style="line-height:20px;"><strong>Phone Number:</strong> {!! $data['order_dtl']->delivery_mobile !!}</td></tr>

    <tr><td style="padding: 5px 0"></td></tr>

    @if(!empty($data['cart_array']))
        @foreach($data['cart_array'] as $item)
            <tr><td>
                <table width="90%" cellspacing="0" cellpadding="0" align="left"
                       style="font-size:13px; font-family:sans-serif; text-align: center; border: 1px solid #CBCBCB; padding: 5px">
                    <tr style="border-bottom: 1px dotted #414141">

                        <td width="20%" style="text-align: left">
                            @php
                                $getImageLink = App\Http\Helper1::get_imagelink($item->product_id);
                            @endphp
                            <img src="{{ $getImageLink}}" style="width:100px; height:100px; float:left;">
                        </td>

                        <td width="40%" style="text-align: left; padding-left: 10px">
                            @php
                                $itemDetail = App\Http\Helper1::get_item_detail($item->product_id);
                            @endphp
                            {{ $itemDetail->item ?? 'Item detail not found' }}<br>

                            <strong>Qty :</strong> {{ $item->qty }}<br>

                            {{--<strong>Delivery Date :</strong>
                            {{ \Carbon\Carbon::parse($item['delivery_date'])->format('D, M d, Y') }}--}}
                        </td>


                        <td width="20%" style="text-align: left; padding-left: 10px">
                            @if(!empty($item->imagePath))

                                @php
                                    $imagePaths = json_decode($item->imagePath);
                                    //print_r($imagePaths);
                                @endphp
                                <b>Personalized Image</b><br>
                                @foreach($imagePaths as $index => $pimagePath)
                                    @php 
                                    $base64pathImage = App\Http\Helper1::base64ImageTag($pimagePath, 'Personalized Image', 'width:50px; height:auto;') 
                                    @endphp
                                    
                                    {{-- @php
                                        $imgDetail = App\Http\Helper1::get_base64ImageTag($pimagePath, 'Personalied Image');
                                    @endphp
                                    {!! $imgDetail !!} --}}
                                    {!! $base64pathImage !!}<br>
                                    {{--<a href="{{ $base64pathImage }}" download="image.png" class="btn btn-primary" target="_blank">Image Link</a><br>--}}
                                    {{--<img src="{{ $pimagePath }}" style="width:50px; height:auto;">--}}
                                @endforeach
                            @endif
                        </td>

                        <td width="20%" style="text-align: left; padding-left: 10px">
                            {{-- {{$item->imageText ? $item->imageText : ''}} --}}
                            @if(!empty($item->imageText))
                            <b>Personalized Text</b><br>
                            {{ $item->imageText }}
                            @endif

                        </td>

                    </tr>
                </table>
            </td></tr>
        @endforeach
    @endif

    @php
        $getOrderMsg = App\Http\Helper1::get_order_messages($data['order']->id, $data['site_data']->site_sort_name);
    @endphp

    <tr><td style="padding: 5px 0"></td></tr>

    <tr><td style="line-height:20px;"><strong>Delivery Date:</strong> {{ date('jS M, Y' , strtotime($data['agent_assinged']->delivery_date)) }}</td></tr>
    <tr><td style="line-height:20px;"><strong>Delivery Time:</strong> {{ $data['agent_assinged']->delivery_time }}</td></tr>

    <tr><td style="line-height:20px;"><strong>Sender Name:</strong> {{ $getOrderMsg->sender_name }}</td></tr>
    <tr><td style="line-height:20px;"><strong>Occasion:</strong> Rakhi</td></tr>
    <tr><td style="line-height:20px;"><strong>Sender Message:</strong> {{ $getOrderMsg->sender_message }}</td></tr>
    <tr><td style="line-height:20px;"><strong>Special Instruction:</strong> {{ $getOrderMsg->sender_special_instruction }}</td></tr>

    @if(!empty($getOrderMsg->sender_demand))
        <tr><td style="line-height:20px;"><strong>**Note:</strong> {{ $getOrderMsg->sender_demand }}</td></tr>
    @endif

    @if(!empty($data['agent_assinged']->comments))
        <tr><td style="line-height:20px; color: red;"><strong>**Note:</strong> {{ $data['agent_assinged']->comments }}</td></tr>
    @endif

    <tr><td style="font-size:13px; line-height:25px; padding: 15px 0">Please Acknowledge the Mail.</td></tr>

    <tr><td style="font-size:13px; line-height:20px; padding: 5px 0; font-weight: 600">
        Best Regards,<br>
        Order Department<br>
        RSPL
    </td></tr>

</table>

</body>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.bundle.min.js" integrity="sha384-ndDqU0Gzau9qJ1lfW4pNLlhNTkCfHzAVBReH9diLvGRem5+R9g2FzA8ZGN954O5Q" crossorigin="anonymous"></script>
</html>
