@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
    @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA')
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">City</h4>
                    <div class="ml-auto text-right">
                        <a href="{{url('admin/city/list/')}}/{{base64_encode($site_id)}}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                            @if(Session::has('alert-' . $msg))
                                <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
                            @endif
                        @endforeach
                        <form action="{{url('admin/city/add/')}}/{{base64_encode($site_id)}}" method="POST" class="form-horizontal" id="formadd">
                            @csrf
                            <div class="card-body">
                                <h4 class="card-title">City Add</h4>
                                
                                <div class="form-group m-t-20">
                                    <label>Name</label>
                                    <input type="text" class="form-control" id="name" name="name" placeholder="Enter Name" required>
                                </div>

                                <div class="form-group m-t-20">
                                    <label>Slug</label>
                                    <input type="text" class="form-control" id="slug" name="slug" placeholder="Enter slug" required>
                                </div>

                                <div class="form-group m-t-20">
                                    <label>Banner Heading</label>
                                    <input type="text" class="form-control" id="ban_head" name="ban_head" placeholder="Enter banner heading" required>
                                </div>

                                <div class="form-group m-t-20">
                                    <label>Content Top</label>
                                    <textarea class="form-control" rows="5" id="contenttop" name="contenttop" placeholder="Enter Content Top" ></textarea>
                                </div>

                                <div class="form-group m-t-20">
                                    <label>Content Bottom</label>
                                    <textarea class="form-control" rows="5" id="contentbottom" name="contentbottom" placeholder="Enter Content Bottom" ></textarea>
                                </div>
                                
                                <div class="form-group m-t-20">
                                    <label>Meta Title</label>
                                    <input type="text" class="form-control" id="meta_title" name="meta_title" placeholder="Enter Meta Title" required>
                                </div>

                                <div class="form-group m-t-20">
                                    <label>Meta Description</label>
                                    <textarea class="form-control" rows="5" id="meta_description" name="meta_description" placeholder="Enter Meta Description" required></textarea>
                                </div>

                                <div class="form-group m-t-20">
                                    <label>Meta Keyword</label>
                                    <textarea class="form-control" rows="5" id="meta_keyword" name="meta_keyword" placeholder="Enter Meta Keyword"></textarea>
                                </div>
                                
                                <div class="form-group m-t-20">
                                    <label>Tagline</label>
                                    <input type="text" class="form-control" id="tagline" name="tagline" placeholder="Enter tagline">
                                </div>

                                <div class="form-group m-t-20">
                                    <label>Tophead</label>
                                    <input type="text" class="form-control" id="tophead" name="tophead" placeholder="Enter tophead">
                                </div>

                                {{--<div class="form-group m-t-20">
                                    <label>Sort Order</label>
                                    <input type="text" class="form-control" id="sort_order" name="sort_order" placeholder="Enter sort order">
                                </div>--}}
                                <div class="form-group m-t-20">
                                    <label>Delay Days</label>
                                    <input type="text" class="form-control" id="delay_day" name="delay_day" placeholder="Enter delay day" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Metro City Name</label>
                                    <input type="text" class="form-control" id="metro_city" name="metro_city" placeholder="Enter metro city name" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>State Name</label>
                                    <input type="text" class="form-control" id="state" name="state" placeholder="Enter state" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Area Type<span>*</span></label>
                                    <select id="area_type" name="area_type" type="text" class="form-control"
                                        aria-required="true" aria-invalid="false" required>
                                        <option value="">Select Area Type</option>
                                            <option value="A">A</option>
                                            <option value="B">B</option>
                                            <option value="C">C</option>
                                            <option value="D">D</option>
                                            <option value="E">E</option>
                                            <option value="F">F</option>
                                    </select>
                                </div>
                            </div>
                            <div class="border-top">
                                <div class="card-body">
                                    <input class="btn btn-primary" type="submit" value="Create">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif 

</main>   

<script type="text/javascript">
    $.validator.setDefaults({
            submitHandler: function(form) {
                form.submit();
            }
    });

    $(document).ready(function () {
        setTimeout(function () {
            $('.cke_notifications_area').attr("style", "display: none !important");
        }, 1000); // 60000ms = 1 minute
    });

    $(function() {
        // validate the comment form when it is submitted
        $("#formadd").validate({
            ignore: [],
            errorPlacement: function(label, element) {
                label.addClass('mt-2 text-danger');
                label.insertAfter(element);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass('has-danger')
                $(element).addClass('form-control-danger')
            }

          });
    });

    CKEDITOR.replace("contenttop");
    CKEDITOR.replace("contentbottom");

    $('#title').on('blur', function(){
        var title = $.trim($(this).val());
        if(title != ''){
            //if($.trim($('#slug').val()) == ''){
                $('#slug').val(title.replace(/ /g,"-").toLowerCase());
                $('#slug-error').hide();
            //}
        }

    });

</script>    

@endsection

