@extends('layouts.admin.app')

@section('content')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>
<main id="main" class="main">
    @if($agent)
    {{-- <div style="text-align: center; margin-top: -13px;">
            <h2>Agent {{$agent->name}}</h2>
        </div>   --}}  
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row mb-3">
                              <label class="col-sm-2 col-form-label"><b>Upload Excel</b></label>
                              <div class="col-sm-10">
                                <input type="file" name="excel" id='excel' class="form-control" required/>
                                <div style="margin-top:2%;">
                                    <a id="downloadexcelformat" href="{{url('/product_list.xlsx')}}" class="btn btn-success" download  type="button" style="float: inline-end;margin-left: 1%;">Download Excel Format</a>
                                    <button id="import" class="btn btn-primary" type="button" style="float: inline-end;">Import</button>
                                </div>
                               
                              </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Agent :: {{ucwords($agent->name)}}</h4>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="col-12 d-flex no-block align-items-center justify-content-between mb-2">
                                <h5 class="page-title">
                                    Agent Excel Product List
                                </h5>
                                <div class="ml-auto text-right">
                                    <!-- <button id="btn_exportExcel" class="btn btn-primary">Import in Excel</button>
                                    <a href="" class="btn btn-success">Add Product</a> -->
                                </div>
                            </div>
                            <form action="{{ url('/admin/agent/agent-product-list/import-excel') }}/{{ encrypt($agent->id) }}" method="post" enctype="multipart/form-data" id="excelForm">
                                @csrf
                                <div class="table-responsive">
                                    <table id="zero_config" class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>No.</th>
                                                <th>Title</th>
                                                <th>Price</th>
                                                <th>Gst</th>
                                                <th>Without Gst</th>
                                                <th>Personalized</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                        </tbody>
                                    </table>
                                    <div style="text-align:left;">
                                        <button type="submit" class="btn btn-primary" id="upload" style="display: none;float: inline-end;">Upload</button>
                                    </div>
                                </div>
                            </form>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @else
        No Data Found...
    @endif    
            
</main><!-- End #main -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

<script>
    $('#import').click(function () {
        var fileInput = document.getElementById('excel');
        var file = fileInput.files[0];

        if (!file) {
            alert("Please select an Excel file first.");
            return;
        }

        var reader = new FileReader();

        reader.onload = function (e) {
            var data = e.target.result;

            var workbook = XLSX.read(data, {
                type: 'binary'
            });

            var sheetName = workbook.SheetNames[0];
            var sheet = workbook.Sheets[sheetName];

            var rows = XLSX.utils.sheet_to_json(sheet, { defval: "" });

            $('#zero_config tbody').empty(); // Clear existing rows

            rows.forEach(function (row, index) {
                var html = `
                    <tr>
                        <td>${index + 1}</td>
                        <td><input class="form-control" name="title[]" value="${row['title'] ?? ''}" /></td>
                        <td><input class="form-control" name="price[]" value="${row['price'] ?? ''}" /></td>
                        <td><input class="form-control" name="gst[]" value="${row['gst'] ?? ''}" /></td>
                        <td><input class="form-control" name="without_gst[]" value="${row['without gst'] ?? ''}" /></td>
                        <td><input class="form-control" name="personalized[]" value="${row['personalized (Y/N)'] ?? ''}" /></td>
                    </tr>
                    `;
                $('#zero_config tbody').append(html);
            });
        };
        $('#upload').css('display','block');
        reader.readAsBinaryString(file);
    });
</script>

@endsection