@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>

<main id="main" class="main">
    <div class="page-breadcrumb">
        <div class="row">
            <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                <h4 class="page-title">Agent Registration</h4>
                <div class="ml-auto text-right">
                    <a href="{{route('admin.agent.allAgents')}}" class="btn btn-outline-info">Back</a>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                        @if(Session::has('alert-' . $msg))
                            <div class="alert alert-{{ $msg }} alert-dismissible fade show" role="alert">
                                {{ Session::get('alert-' . $msg) }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        @endif
                    @endforeach
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            {{ implode(' | ', $errors->all()) }}
                        </div>
                    @endif


                    <form action="{{url('/admin/agent/add')}}" method="POST" id="formadd" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">
                            <h4 class="card-title">Add Agent</h4>

                            <div class="form-group m-t-20">
                                <label>Agent Name</label>
                                <input type="text" class="form-control" name="name" placeholder="Enter Agent Name" required>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Agent Email</label>
                                <input type="email" class="form-control" name="email" placeholder="Enter Agent Email" required>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Contact Person</label>
                                <input type="text" class="form-control" name="contact_person" placeholder="Enter Contact Person" required>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Alternate Email(s)</label>
                                <div id="altEmailWrapper">
                                    <div class="input-group mb-2">
                                        <input type="email" class="form-control" name="alt_email[]" placeholder="Enter Alternate Email">
                                        <button type="button" class="btn btn-success addEmail">+</button>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Phone No</label>
                                <input type="text" class="form-control" name="phone_no" placeholder="Enter Phone No" required>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Alternate Phone No(s)</label>
                                <div id="altPhoneWrapper">
                                    <div class="input-group mb-2">
                                        <input type="text" class="form-control" name="alt_phone[]" placeholder="Enter Alternate Phone No">
                                        <button type="button" class="btn btn-success addPhone">+</button>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Address</label>
                                <textarea class="form-control" name="address" placeholder="Enter Address" required></textarea>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Agent Type</label>
                                <select name="agent_type" class="form-control" required>
                                    <option value="" selected>Select Agent Type</option>
                                    <option value="H/Hand-delivery">Hand Delivery</option>
                                    <option value="C/Courier">Courier</option>
                                    <option value="C/Third-party-vendor">Third Party Vendor</option>
                                </select>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Password</label>
                                <input type="password" class="form-control" id="password" name="password" placeholder="Enter Password" required>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Confirm Password</label>
                                <input type="password" class="form-control" id="cpassword" name="cpassword" placeholder="Confirm Password" required>
                            </div>
                        </div>

                        <div class="border-top">
                            <div class="card-body">
                                <input class="btn btn-primary" type="submit" value="ADD">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
$(document).ready(function(){
    // Add Alternate Email
    $(document).on('click', '.addEmail', function(){
        $('#altEmailWrapper').append(`
            <div class="input-group mb-2">
                <input type="email" class="form-control" name="alt_email[]" placeholder="Enter Alternate Email">
                <button type="button" class="btn btn-danger removeField">-</button>
            </div>
        `);
    });

    // Add Alternate Phone
    $(document).on('click', '.addPhone', function(){
        $('#altPhoneWrapper').append(`
            <div class="input-group mb-2">
                <input type="text" class="form-control" name="alt_phone[]" placeholder="Enter Alternate Phone No">
                <button type="button" class="btn btn-danger removeField">-</button>
            </div>
        `);
    });

    // Remove Field
    $(document).on('click', '.removeField', function(){
        $(this).closest('.input-group').remove();
    });

    // Password Match Validation
    $('#formadd').on('submit', function(){
        let pass = $('#password').val();
        let cpass = $('#cpassword').val();
        if(pass !== cpass){
            alert('Password and Confirm Password must match!');
            return false;
        }
    });
});
</script>
@endsection
