<?php
function sendZeptoMail($email, $subject, $htmlbody, $siteDetails, $attachments = [], $alter_native_email = [])
{
    $url = 'https://api.zeptomail.in/v1.1/email';
    $token = $siteDetails->zepto_token;

    // Build BCC array
    $bccList = [];

    // Add alternate emails from JSON
    if (!empty($alter_native_email)) {
        foreach (json_decode($alter_native_email, true) as $alternate_email) {
            $bccList[] = [
                "email_address" => [
                    "address" => $alternate_email,
                ]
            ];
        }
    }

    // Add static BCC emails
    // $bccList[] = [
    //     "email_address" => [
    //         "address" => 'raj.rtech1@gmail.com',
    //     ]
    // ];
    // $bccList[] = [
    //     "email_address" => [
    //         "address" => 'subhajit.floranet19@gmail.com',
    //     ]
    // ];

    $emailData = [
        "from" => [
            "address" => $siteDetails->site_noreply_email,
            "name" => "Do Not Reply"
        ],
        "to" => [
            [
                "email_address" => [
                    "address" => $email
                ]
            ]
        ],
        "bcc" => $bccList,
        "subject" => $subject,
        "htmlbody" => $htmlbody
    ];

    // Add attachments if present
    if (!empty($attachments)) {
        $emailData['attachments'] = [];

        foreach ($attachments as $attachment) {
            $emailData['attachments'][] = [
                "content" => base64_encode($attachment['content']),
                "name" => $attachment['name'],
                "mime_type" => $attachment['type']
            ];
        }
    }

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: $token",
        "Content-Type: application/json"
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($emailData));

    $cacertPath = public_path('cacert.pem');
    curl_setopt($ch, CURLOPT_CAINFO, $cacertPath);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($error) {
        \Log::error('ZeptoMail cURL Error: ' . $error);
        throw new \Exception('ZeptoMail cURL Error: ' . $error);
    }

    $jsonResponse = json_decode($response, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        \Log::error('Invalid JSON response from ZeptoMail API: ' . $response);
        throw new \Exception('Invalid JSON response from ZeptoMail: ' . $response);
    }

    if ($httpCode !== 200) {
        \Log::error('ZeptoMail API Error: ', $jsonResponse);
        throw new \Exception('ZeptoMail API Error: ' . json_encode($jsonResponse));
    }

    return $jsonResponse;
}
