

<?php $__env->startSection('content'); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo e(asset('admin/assets/extra-libs/multicheck/datatable-checkbox-init.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/extra-libs/multicheck/jquery.multicheck.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/extra-libs/DataTables/datatables.min.js')); ?>"></script>

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('admin/assets/extra-libs/multicheck/multicheck.css')); ?>">
    <link href="<?php echo e(asset('admin/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css')); ?>" rel="stylesheet">

    <main id="main" class="main">
        <?php if( Session::get('permissions.user_type') == 'A' ): ?>
	        <div class="page-breadcrumb">
                <div class="row">
                    <div class="col-12 d-flex no-block align-items-center">
                        <h4 class="page-title">Cms Page List</h4>
                        <div class="ml-auto text-right">
                            <a href="<?php echo e(route('admin.cms.add')); ?>" class="btn btn-success">ADD CMS</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(Session::has('alert-' . $msg)): ?>
                                        <h4 class="font-weight-light alert alert-<?php echo e($msg); ?>"><?php echo e(Session::get('alert-' . $msg)); ?></h4>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <h5 class="card-title">Category</h5>
                                <?php if(count($result) > 0): ?>
                                <div class="table-responsive">
                                    <table id="zero_config" class="table table-striped table-bordered">
                                        <thead>
                                            <tr>
                                                <th style="width: 5%"><b>No.</b></th>
                                                <th style="width: 20%"><b>Title</b></th>
                                                <th style="width: 20%"><b>Content</b></th>
                                                <th style="width: 15%"><b>Created Date</b></th>
                                                <th style="width: 6%"><b>Status</b></th>
                                                <th style="width: 9%">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i=1; ?>
                                            <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($i + $key); ?></td>
                                                <td><?php echo e($data->title); ?></td>
                                                <td><?php echo substr(strip_tags($data->content), 0, 100); ?>...</td>
                                                <td><?php echo e(date('d-m-Y', strtotime($data->created_at))); ?></td>
                                                <td>
                                                    <label class="switch">
                                                        <input type="checkbox" class="blockstatus" name="stat" id="stat" data-id="<?php echo e(base64_encode($data->id)); ?>" <?php if($data->is_block == 'N'): ?> checked <?php endif; ?>>
                                                        <span class="slider roundsemi"></span>
                                                    </label>
                                                    <label id="status-info-<?php echo e($data->id); ?>" class="status-stat"></label>
                                                </td>
                                                <td>
                                                    <a href="<?php echo e(route('admin.cms.edit', base64_encode($data->id).'?redirect='.urlencode($request->fullUrl()))); ?>">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a onclick="return confirm('Are you sure you want to delete the Category?')" href="">
                                                        <i class="fas fa-trash-alt"></i>
                                                    </a>
                                                    <a href="<?php echo e(route('admin.cms.list_cms', base64_encode($data->id).'?redirect='.urlencode($request->fullUrl()))); ?>" target="_blank">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tfoot>
                                    </table>
                                </div>
                                <?php else: ?>
                                    <div class="card">No Data Found...</div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>    
    </main><!-- End #main -->
    <script>
        /****************************************
         *       Basic Table                   *
         ****************************************/
        $('#zero_config').DataTable({
            "order": [[5, "desc"]] 
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adminrighflorist/public_html/resources/views/admin/cms/list.blade.php ENDPATH**/ ?>