<?php $__env->startSection('content'); ?>

    <main id="main" class="main">
        <?php if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA'): ?>
            <div class="pagetitle">
              <h1>Order Details</h1>
              <!-- <nav>
                <ol class="breadcrumb">
                  <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                  <li class="breadcrumb-item">Tables</li>
                  <li class="breadcrumb-item active">General</li>
                </ol>
              </nav> -->
            </div><!-- End Page Title -->

            <section class="section">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                              <h5 class="card-title">Assign Orders</h5>

                                <!-- Default Table -->
                                <div class="table-responsive">
                                    <table id="zero_config" class="table table-striped table-bordered">
                                        <thead>
                                            <tr>
                                                <th scope="col">Sr No</th>
                                                <th scope="col">Order Id</th>
                                                <th scope="col">Purchased Date</th>
                                                <th scope="col">Delivery Date</th>
                                                <th scope="col">Customer Name</th>
                                                <th scope="col">Order Status</th>
                                                <th scope="col">Products</th>
                                                <th scope="col">Agent Name</th>
                                                <th scope="col">Agent Status</th>
                                                <th scope="col">View</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i = 0; ?>
                                            <?php $__currentLoopData = $order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orders): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $orderDetails = $order_details->where('order_id', $orders->id);

                                                    $productsForOrder = $products->whereIn('id', $orderDetails->pluck('product_id'));

                                                    $userDetails = $user->where('id', $orders->user_id)->first();

                                                    $agentAssingedDetails = $agent_assinged->where('OID',$orders->id);

                                                ?>

                                                <?php if($orderDetails->isNotEmpty()): ?>
                                                    <?php $i++; ?>
                                                    <tr>
                                                        <th scope="row"><?php echo e($i); ?></th>
                                                        <td><b><?php echo e($orders->unique_order_id); ?></b></td>
                                                        <td><?php echo e(\Carbon\Carbon::parse($orders->purchase_date)->format('d F Y')); ?></td>
                                                        <td>
                                                            <?php $__currentLoopData = $orderDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deliveryDates): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php echo e(\Carbon\Carbon::parse($deliveryDates->delivery_date)->format('d F Y')); ?><br>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </td>
                                                        <td>
                                                            <?php if($userDetails): ?>
                                                                <?php echo e($userDetails->name); ?>

                                                            <?php endif; ?>    
                                                        </td>  
                                                        <td>
                                                            <?php if($orders->order_delivery_status == 'P'): ?>
                                                                <div style="background-color: #ffeb3b; padding: 5px 10px; border-radius: 5px; text-align: center;">
                                                                    PENDING
                                                                </div>
                                                            <?php elseif($orders->order_delivery_status == 'PC'): ?>
                                                                <div style="background-color: #03a9f4; padding: 5px 10px; border-radius: 5px; text-align: center;">
                                                                    PROCESS
                                                                </div>
                                                            <?php elseif($orders->order_delivery_status == 'CL'): ?>
                                                                <div style="background-color: #f44336; color: white; padding: 5px 10px; border-radius: 5px; text-align: center;">
                                                                    CANCELED
                                                                </div>
                                                            <?php elseif($orders->order_delivery_status == 'H'): ?>
                                                                <div style="background-color: #9e9e9e; color: white; padding: 5px 10px; border-radius: 5px; text-align: center;">
                                                                    HOLD
                                                                </div>
                                                            <?php elseif($orders->order_delivery_status == 'D'): ?>
                                                                <div style="background-color: #4caf50; color: white; padding: 5px 10px; border-radius: 5px; text-align: center;">
                                                                    Delivered
                                                                </div>
                                                            <?php elseif($orders->order_delivery_status == 'S'): ?>
                                                                <div style="background-color: #8bc34a; color: white; padding: 5px 10px; border-radius: 5px; text-align: center;">
                                                                    Shipped
                                                                </div>
                                                            <?php endif; ?>
                                                        </td>

                                                        <td>
                                                            <!-- Display all associated products for this order -->
                                                            <?php echo $productsForOrder->pluck('product_name')->implode('<br>'); ?>

                                                        </td>
                                                        <td>
                                                            <?php $__currentLoopData = $agentAssingedDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agents): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php $__currentLoopData = $agent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agentDetails): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php if($agents->agent_id == $agentDetails->id): ?>
                                                                        <span style="font-weight: 600; font-family: Arial, sans-serif;"><?php echo e($agentDetails->name); ?></span>
                                                                    <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>        
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </td>
                                                        <td>
                                                            <?php $__currentLoopData = $agentAssingedDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agents): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($agents->status == 'P'): ?>
                                                                    <div style="color: orange; font-weight: bold;">PENDING</div>
                                                                <?php elseif($agents->status == 'PC'): ?>
                                                                    <div style="color: blue; font-weight: bold;">PROCESS</div>
                                                                <?php elseif($agents->status == 'CL'): ?>
                                                                    <div style="color: red; font-weight: bold;">CANCELED</div>
                                                                <?php elseif($agents->status == 'H'): ?>
                                                                    <div style="color: gray; font-weight: bold;">HOLD</div>
                                                                <?php elseif($agents->status == 'D'): ?>
                                                                    <div style="color: green; font-weight: bold;">DELIVERED</div>
                                                                <?php elseif($agents->status == 'S'): ?>
                                                                    <div style="color: teal; font-weight: bold;">SHIPPED</div>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </td>
                                                        <!-- <td>
                                                            <?php if($orders->order_delivery_status == 'PC' || $orders->order_delivery_status == 'CL' || $orders->order_delivery_status == 'S' || $orders->order_delivery_status == 'D' || $orders->order_delivery_status == 'H'): ?>
                                                                <div>
                                                                    Agent Assigned
                                                                </div>
                                                            <?php else: ?>
                                                                <div>
                                                                    Agent Not Assigned Yet
                                                                </div>
                                                            <?php endif; ?>
                                                        </td> -->
                                                        <td><a href="<?php echo e(url('/admin/orders/view')); ?>/<?php echo e($orders->id); ?>" class="btn btn-primary">VIEW</a></td>
                                                    </tr>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                                <!-- End Default Table Example -->
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php endif; ?>    
        
    </main><!-- End #main -->

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const table = document.querySelector("#zero_config");
            const dataTable = new simpleDatatables.DataTable(table, {
                sortable: true,
                fixedHeight: true,
                columns: [
                    { select: 5, sort: "desc" } // Sort by the 6th column (index 5) descending
                ]
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/order.blade.php ENDPATH**/ ?>