<?php $__env->startSection('content'); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo e(asset('admin/assets/extra-libs/multicheck/datatable-checkbox-init.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/extra-libs/multicheck/jquery.multicheck.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/extra-libs/DataTables/datatables.min.js')); ?>"></script>

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('admin/assets/extra-libs/multicheck/multicheck.css')); ?>">
    <link href="<?php echo e(asset('admin/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css')); ?>" rel="stylesheet">

    <main id="main" class="main">
        <?php if( Session::get('permissions.user_type') == 'A' ): ?>
	        <div class="page-breadcrumb">
			    <div class="row">
			        <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
			        	<h4 class="page-title">
			                <a href="<?php echo e(route('admin.bulkproductedit')); ?>"><i class="fas fa-shekel-sign fawsm"></i></a>
			                Product
			            </h4>
			            <div class="ml-auto text-right">
			            	<a href="<?php echo e(route('admin.productexceldownload')); ?>" class="btn btn-warning" title="Download Excel"><i class="fas fa-file-excel"></i></a>
                            <a href="<?php echo e(route('admin.product_categorywise_sortorder')); ?>" class="btn btn-info">Product Sort</a>
			                <a href="<?php echo e(route('admin.product-add')); ?>" class="btn btn-success">ADD Product</a>
			            </div>
			        </div>
			    </div>
			</div>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(Session::has('alert-' . $msg)): ?>
                                        <h4 class="font-weight-light alert alert-<?php echo e($msg); ?>"><?php echo e(Session::get('alert-' . $msg)); ?></h4>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="product-search">
                                    <div class="prod-search-title">
                                        <h5 class="card-title">
                                            Product List
                                        </h5>
                                    </div>
                                    <div class="prod-search-body">
                                        <form action="<?php echo e(route('admin.product')); ?>" id="search-form" method="post">
                                            <?php echo csrf_field(); ?>
                                            <select class="form-control" id="category_ids" name="category_id">
                                                <option value="">Choose Category</option>
                                                <?php foreach ($category_data as $key => $category) { ?>
                                                    <option value="<?php echo $key; ?>" <?php if($request->category_id == $key){?> selected <?php } ?>><?php echo $category; ?></option>
                                                <?php } ?>
                                            </select>
                                            <input class="form-control" id="search-field" name="search" placeholder="Search By FNID / Product Title"/>
                                            <button class="btn btn-primary" type="submit" ><i class="fa fa-search"></i></button>
                                        </form>                     
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table id="zero_config" class="table table-striped table-bordered">
                                        <thead>
                                            <tr>
                                                <th style="width: 5%"><b>No.</b></th>
                                                <th style="width: 10%"><b>Image</b></th>
                                                <th style="width: 25%"><b>Title</b></th>
                                                <th style="width: 5%"><b><?php echo CustomPaginator::sort('fnid', 'SKU', ['direction' => true]); ?></b></th>
                                                <th style="width: 42%"><b>Category</b></th>
                                                <th style="width: 4%"><b>Price</b></th>
                                                <th style="width: 9%"><b><?php echo CustomPaginator::sort('is_block', 'Status', ['direction' => true]); ?></b></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i = ($result->currentPage() - 1) * $result->perPage() + 1; ?>
                                            <?php if($result->count() == 0): ?>
                                                <tr>
                                                    <td colspan="10">No records found!</td>
                                                </tr>
                                            <?php endif; ?>
                                            <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $products): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($i + $key); ?></td>
                                                    <td>
                                                        <?php 
                                                            $imagename = App\Http\Helper1::get_image($products->id);
                                                        ?>

                                                        <?php if(isset($imagename) && $imagename->name != null ): ?>
                                                            <img src="https://giftbasketsbrazil.rightflorist.org/uploaded/product/<?php echo e($imagename->name); ?>" style="width:90px; height: auto;"  >
                                                        <?php else: ?>
                                                            <img src="https://giftbasketsbrazil.rightflorist.org/uploaded/no_image.jpg" style="width:90px; height: auto;"  >
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo e($products->product_name); ?>

                                                        <hr>
                                                        <b>Delay Days : </b><?php echo e($products->delivery_delay_days); ?> days
                                                    </td>
                                                    <td>
                                                        <?php echo e($products->id); ?> / <span style="color:#2962ff; font-weight: 600"> <?php echo e($products->fnid); ?></span>
                                                        <?php
                                                            $reviewDtl = App\Http\Helper1::get_reviewDtlsbyProduct($products->id);
                                                        
                                                            if(count($reviewDtl) > 0){
                                                                $ratingSum = $avgRating = 0;
                                                                foreach($reviewDtl as $review){
                                                                    $ratingSum = $ratingSum + $review->rating;
                                                                }
                                                                $avgRating = round($ratingSum/count($reviewDtl), 1);
                                                                ?>
                                                                <hr>
                                                                <?php echo e($avgRating); ?> <i class="fas fa-star"></i> <br> <?php echo e(count($reviewDtl)); ?> Reviews
                                                        <?php
                                                            }
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php
                                                            $getCategories = App\Http\Helper1::product_relatated_category_list($products->id);
                                                        ?>
                                                        <?php $__currentLoopData = $getCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php echo $cat . ' | '; ?>

                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </td>
                                                    <td>
                                                        <?php if($products->has_attribute == "Y"): ?>
                                                            <?php if(count($products->product_attribute) > 0): ?>
                                                                <?php $__currentLoopData = $products->product_attribute; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php echo e($attribute->title); ?> <b>USD <?php echo e($attribute->price); ?></b> <br>    
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endif; ?>

                                                        <?php else: ?>
                                                            <b><?php echo e($products->price); ?></b>
                                                        <?php endif; ?>
                                                        <?php if($products->actual_price > 0): ?>
                                                            <br><span style="text-decoration:line-through;"> <?php echo e($products->actual_price); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <span class="created-dt"><?php echo e(date('jS M y', strtotime($products->created_at))); ?></span>
                                                        <br>
                                                        <a href="<?php echo e(url('admin/status/')); ?>/<?php echo e(encrypt($products->id)); ?>"><button
                                                        type="button" class="btn btn-success">Status</button></a>
                                                        <br>
                                                        <a href="<?php echo e(url('admin/product-edit/')); ?>/<?php echo e(encrypt($products->id)); ?>">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div style="font-size: 15px; text-align: left; display: inline;">
                                    Showing <?php echo e($result->firstItem()); ?> to <?php echo e($result->lastItem()); ?> of <?php echo e($result->total()); ?> entries
                                </div>
                                <div class="text-center-pagination pagination" style="float:right;">
                                    <?php echo $result->withQueryString()->links('pagination::bootstrap-4'); ?>

                                </div>
                                <div><b>Last FNID <?php echo e($lastInsertData->fnid); ?></b></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>    
        
    </main><!-- End #main -->

    <style type="text/css">
        .product-search{display: flex;justify-content: space-between; align-items: center; margin-bottom: 20px;}
        .prod-search-title{width: 30%;}
        .prod-search-body{width: 80%;}
        .prod-search-body form{display: flex;justify-content: end;gap: 3px;}
        .prod-search-body form select, .prod-search-body form input{width: 32%;}
        .fawsm{color: #3e5569;}
        .created-dt{font-size: 12px; font-weight: 700; color: #838383;}
        .switch{margin-top: 7px}
        .status-stat{display: inline;}
    </style>
            
    
    <script>
        /****************************************
         *       Basic Table                   *
         ****************************************/
        // $('#zero_config').DataTable({
        //     "order": [[7, "desc"]] 
        // });
        $(document).ready(function(){
            $(function() {
                $('form').each(function() {
                    $(this).find('input').keypress(function(e) {
                        // Enter pressed?
                        if(e.which == 10 || e.which == 13) {
                            this.form.submit();
                        }
                    });

                    $(this).find('input[type=submit]').hide();
                });
            });
        });

        

        
    </script> 

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/product/product.blade.php ENDPATH**/ ?>