<style>
    @charset "UTF-8";
    html * {
    box-sizing: border-box;
    }

    p {
    margin: 0;
    }

    .upload__box {
    padding: 40px;
    }
    .upload__inputfile {
    width: 0.1px;
    height: 0.1px;
    opacity: 0;
    overflow: hidden;
    position: absolute;
    z-index: -1;
    }
    .upload__btn {
    display: inline-block;
    font-weight: 600;
    color: #fff;
    text-align: center;
    min-width: 116px;
    padding: 5px;
    transition: all 0.3s ease;
    cursor: pointer;
    border: 2px solid;
    background-color: #4045ba;
    border-color: #4045ba;
    border-radius: 10px;
    line-height: 26px;
    font-size: 14px;
    }
    .upload__btn:hover {
    background-color: unset;
    color: #4045ba;
    transition: all 0.3s ease;
    }
    .upload__btn-box {
    margin-bottom: 10px;
    }
    .upload__img-wrap {
    display: flex;
    flex-wrap: wrap;
    margin: 0 -10px;
    }
    .upload__img-box {
    width: 200px;
    padding: 0 10px;
    margin-bottom: 12px;
    }
    .upload__img-close {
    width: 24px;
    height: 24px;
    border-radius: 50%;
    background-color: rgba(0, 0, 0, 0.5);
    position: absolute;
    top: 10px;
    right: 10px;
    text-align: center;
    line-height: 24px;
    z-index: 1;
    cursor: pointer;
    }
    .upload__img-close:after {
    content: "✖";
    font-size: 14px;
    color: white;
    }

    .img-bg {
    background-repeat: no-repeat;
    background-position: center;
    background-size: cover;
    position: relative;
    padding-bottom: 100%;
    }
</style>
<?php $__env->startSection('content'); ?>

<main id="main" class="main">
    <div class="pagetitle">
        <h1>Order</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/order')); ?>">Home</a></li>
                <li class="breadcrumb-item active">Order</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <section class="section contact">
        <div class="row gy-4">
            <div class="col-xl-6">

                <div class="col-lg-12">
                    <div class="info-box card" style="padding: 10px 12px;">
                        <div class="row">

                            <div class="col-9">
                                <h4><b><?php echo e(ucwords($agents->name)); ?></b></h4>
                                <h5><b><?php echo e($agent_assinged->agent_order_id); ?></b></h5>
                                
                            </div>

                            <div class="col-3 ms-auto text-end" style="display:flex; gap: 4px">
                                <div>
                                    <a href="<?php echo e(url('/admin/order/assign-order-view/invoice/' . encrypt($agent_assinged->agent_order_id) . '/' . encrypt($agents->id))); ?>" target="_blank"><i class="bx bxs-printer" style="font-size: 25px; line-height: 1.2; color: #8d8d8d;"></i></a>
                                </div>
                                <div>
                                    <h5>
                                        <?php if($agent_assinged->status == 'P'): ?>
                                            <span class="badge bg-danger">PENDING</span>
                                        <?php elseif($agent_assinged->status == 'PC'): ?>
                                            <span class="badge bg-info">ACCEPTED</span>
                                        <?php elseif($agent_assinged->status == 'H'): ?>
                                            <span class="badge bg-warning">HOLD</span>
                                        <?php elseif($agent_assinged->status == 'CL'): ?>
                                            <span class="badge bg-dark">CANCEL</span>
                                        <?php elseif($agent_assinged->status == 'D'): ?>
                                            <span class="badge bg-success">DELIVERED</span>
                                        <?php elseif($agent_assinged->status == 'S'): ?>
                                            <span class="badge bg-primary">SHIPPED</span>
                                        <?php endif; ?>
                                    </h5>
                                </div>
                                


                                
                            </div>

                        </div>
                    </div>
                </div>

                <div class="col-lg-12">
                    <div class="info-box card" style="padding: 10px 12px;">
                        <div class="row">
                            <h4>Delivery Address</h4>
                            
                            <p style="padding-left: 3%;">
                                <?php
                                    if( $orders->delivery_user_name != NULL ) {
                                ?>
                                    <strong>
                                    <?php echo $orders->delivery_user_name; ?>

                                    </strong><br>
                                    <?php echo $orders->delivery_address; ?>,<br>
                                    <?php echo $orders->delivery_city; ?>, <?php echo $orders->delivery_country; ?>,<br>
                                    <?php echo $orders->delivery_state; ?> - <?php echo $orders->delivery_pincode; ?><br>
                                    <?php echo $orders->delivery_mobile; ?>

                                <?php
                                    }else{
                                        echo 'NA';
                                    }
                                ?>
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12">
                    <div class="info-box card" style="padding: 10px 12px;">
                        <div class="row">
                            <h4>Message Section</h4>
                            
                            <p style="padding-left: 3%;">
                                <strong>Sender Name:</strong> <?php echo e($orders_Msg->sender_name); ?>

                                <br>
                                <strong>Sender Message: </strong><?php echo e($orders_Msg->sender_message); ?>

                                <br>
                                <strong>Special Instruction: </strong><?php echo e($orders_Msg->sender_special_instruction); ?>

                                <br>
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12">
                    <div class="info-box card" style="padding: 10px 12px;">
                        <div class="row">

                            <div class="col-12">
                                <p>
                                    <strong>Delivery Date:</strong>
                                    <?php echo e(date('jS M, Y' , strtotime($agent_assinged->delivery_date))); ?>    
                                </p>
                                <p>
                                    <strong>Delivery Time:</strong>
                                    <?php echo e($agent_assinged->delivery_time); ?>    
                                </p>
                                <?php if(!empty($agent_assinged->comments)): ?>
                                    <div class="alert alert-primary alert-dismissible fade show" role="alert" style="margin-top: 10px;">
                                        <strong>Note :</strong> <?php echo e($agent_assinged->comments); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-xl-6">

                <div class="col-lg-12">
                    <div class="info-box card" style="padding: 10px 12px;">
                        <div class="row">
                            <h4>Delivery Items</h4>
                            <ol style="padding-left: 6%;">
                                <?php //dd($agent_product_list) ?>
                                <?php $__currentLoopData = $agent_product_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($product->agent_id == $agentId): ?>
                                        <li style="font-size:17px"><?php echo e(ucwords($product->item)); ?> 
                                            <span style="color:blue">X</span> <?php echo e($product->qty); ?>

                                        </li>
                                        <?php if(!empty($product->imagePath)): ?>
                                            <div class="row">
                                                <b>Personalize Image :</b>
                                                <?php
                                                    //dd($product->imagePath);
                                                    $imagesPath = json_decode($product->imagePath);
                                                    //dd($imagesPath);
                                                ?>
                                                <?php $__currentLoopData = $imagesPath; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-2">
                                                    
                                                        <img src="<?php echo e($img); ?>" style="width: 50px; height: 50px; /*margin: 5px;*/" />
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php endif; ?>

                                        <?php if(!empty($product->imageText)): ?>
                                            <div class="row">
                                                <b>Personalize Text :</b>
                                                <div class="col-12">
                                                    <?php echo $product->imageText; ?>

                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ol>
                            <hr>
                            <h5 style="padding-left:3%">
                                <b>Total : Rs. <?php echo e($agent_assinged->totalPrice); ?></b>
                                <small>(Total price included with delivery charge)</small>
                            </h5>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12">
                    <div class="info-box card" style="padding: 10px 12px;">
                        <div class="row">

                            <?php $price=0; ?>
                            <form action="<?php echo e(url('/admin/order/assign-order-view')); ?>/<?php echo e(encrypt($agent_assinged->agent_order_id)); ?>/<?php echo e(encrypt($agentId)); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <table class="table">
                                    <thead>
                                        
                                    </thead>
                                    <tbody>
                                        
                                        <tr>
                                            <td>
                                                <b>Extra Charge</b>&nbsp;<small style="font-size: 12px;">(Please metion reason)</small>
                                                <div class="input-group mb-3">
                                                  <span class="input-group-text" id="basic-addon1">Rs.</span>
                                                  <input class="form-control" name="extra" id="extra" placeholder="Ask For Extra Charge" value="<?php echo e($agent_assinged->extra); ?>"/>
                                                </div>
                                            </td>
                                            <td>
                                                <b>Delivery Charge</b>&nbsp;<small style="font-size: 12px;">(If needed)</small> 
                                                <div class="input-group mb-3">
                                                  <span class="input-group-text" id="basic-addon1">Rs.</span>
                                                  <input class="form-control" id="deliveryCharge" name="deliveryCharge" value="<?php echo e($agent_assinged->Deliver_charge); ?>"/>
                                                </div>
                                                
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2">
                                            <b>Enter The Reason</b>
                                                

                                                <div class="form-floating mb-3">
                                                  <textarea class="form-control" placeholder="Reason" name="reason" id="reason" style="height: 100px;"><?php echo e($agent_assinged->reason); ?></textarea>
                                                  <label for="reason">Reasons</label>
                                                </div>

                                                <?php $__errorArgs = ['reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <label class="alert alert-danger" role="alert"><?php echo e($message); ?></label>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <?php if($agent_assinged->status == 'PC' || $agent_assinged->track_no != ""): ?>
                                                <td colspan="">
                                                    <input class="form-control" name="track_no" value="<?php echo e($agent_assinged->track_no); ?>" style="width:100%;" placeholder="Enter Tracking Number" >
                                                    <?php $__errorArgs = ['track_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <label class="alert alert-danger" role="alert"><?php echo e($message); ?></label>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </td>
                                                <td colspan="">
                                                    <input class="form-control" name="tracking_link" value="<?php echo e($agent_assinged->tracking_link); ?>" style="width:100%;" placeholder="Enter Tracking Link" >
                                                    
                                                </td>
                                                
                                            <?php endif; ?>
                                        </tr>
                                        
                                        <tr>
                                            <td style="width: 60%;/*text-align: center!important;display:flex;margin-left: 81%;*/">
                                                <?php if($agent_assinged->status == "P"): ?>
                                                    <div class="actionDiv">
                                                        <div class="actionRadioDiv">
                                                            <input class="form-check-input" type="radio" id="accept" name="status" value="PC">
                                                            <label for="accept">Accept</label>
                                                        </div>
                                                        <div class="actionRadioDiv">
                                                            <input class="form-check-input" type="radio" id="hold" name="status" value="H">
                                                            <label for="hold">Hold</label>
                                                        </div>
                                                        <div class="actionRadioDiv">
                                                            <input class="form-check-input" type="radio" id="reject" name="status" value="CL">
                                                            <label for="reject">Reject</label>
                                                        </div>
                                                    </div>
                                                <?php elseif($agent_assinged->status == "PC"): ?>
                                                    <div class="actionDiv">
                                                        <div class="actionRadioDiv">
                                                            <input class="form-check-input" type="radio" id="accept" name="status" value="S">
                                                            <label for="accept">Shipped</label>
                                                        </div>
                                                        <div class="actionRadioDiv">
                                                            <input class="form-check-input" type="radio" id="hold" name="status" value="H">
                                                            <label for="hold">Hold</label>
                                                        </div>
                                                        <div class="actionRadioDiv">
                                                            <input class="form-check-input" type="radio" id="reject" name="status" value="CL">
                                                            <label for="reject">Reject</label>
                                                        </div>
                                                    </div>
                                                <?php elseif($agent_assinged->status == "S"): ?>
                                                    <div class="actionDiv">
                                                        <div class="actionRadioDiv">
                                                            <input class="form-check-input" type="radio" id="accept" name="status" value="D">
                                                            <label for="accept">Delivered</label>
                                                        </div>
                                                        <div class="actionRadioDiv">
                                                            <input class="form-check-input" type="radio" id="hold" name="status" value="H">
                                                            <label for="hold">Hold</label>
                                                        </div>
                                                    </div>
                                                <?php elseif($agent_assinged->status == "CL"): ?>

                                                <?php elseif($agent_assinged->status == "H"): ?>
                                                    <div class="actionDiv">
                                                        <div class="actionRadioDiv">
                                                            <input class="form-check-input" type="radio" id="accept" name="status" value="PC">
                                                            <label for="accept">Accept</label>
                                                        </div>
                                                        <div class="actionRadioDiv">
                                                            <input class="form-check-input" type="radio" id="reject" name="status" value="CL">
                                                            <label for="reject">Reject</label>
                                                        </div>
                                                    </div>

                                                    <?php elseif($agent_assinged->status == "H"): ?>

                                                <?php endif; ?>
                                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <label  class="alert alert-danger" role="alert"><?php echo e($message); ?></label>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </td>
                                            <td style="text-align:right">
                                                <?php if($agent_assinged->status == 'CL' || $agent_assinged->status == 'D'): ?>
                                                <?php else: ?>
                                                    <button type="submit" class="btn btn-success">Submit</button>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        
                                        
                                        <tr>
                                            <?php if($agent_assinged->status == "S"): ?>
                                                <td colspan="2" style="text-align:center;">
                                                    <div class="upload__box">
                                                        <div class="upload__btn-box">
                                                            <label class="upload__btn">
                                                            <p> (+) Upload images</p>
                                                            <input type="file" multiple="" name="images" data-max_length="20" class="upload__inputfile" required>
                                                            </label>
                                                        </div>
                                                    <div class="upload__img-wrap"></div>
                                                    </div>
                                                </td>
                                            <?php endif; ?>
                                        </tr>
                                    </tbody>
                                </table>
                            </form>

                        </div>
                    </div>
                </div>

            </div>
        </div>

    </section>
</main>




<style>
    .actionDiv{display: flex; justify-content: start; align-items: center; gap: 25px; font-size: 20px;}
    .actionRadioDiv{ display: flex; align-items: center; gap: 8px; }
    .card{margin-bottom: 15px!important;}
</style>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

<script>
    $(document).ready(function(){
       $('.btn_submit').click(function(){
            var orderId = <?php echo json_encode($agent_assinged->agent_order_id, 15, 512) ?>;
            var extra = $('#extra').val();
            var deliVery = $('#deliveryCharge').val();
            var reason = $('#reason').val();
            var status = $(this).attr('ds-value');
            console.log(status);
            $.ajax({
                url:"<?php echo e(url('/agent/updateStatus')); ?>",
                type:'GET',
                data:{
                    orderId:orderId,
                    extra:extra,
                    deliVery:deliVery,
                    reason:reason,
                    status:status,
                },
                success:function(response){
                    console.log(response);
                },
                error:function(error){
                    console.log(error);
                },
            });
       });

       jQuery(document).ready(function () {
            ImgUpload();
        });

        function ImgUpload() {
        var imgWrap = "";
        var imgArray = [];

        $('.upload__inputfile').each(function () {
            $(this).on('change', function (e) {
            imgWrap = $(this).closest('.upload__box').find('.upload__img-wrap');
            var maxLength = $(this).attr('data-max_length');

            var files = e.target.files;
            var filesArr = Array.prototype.slice.call(files);
            var iterator = 0;
            filesArr.forEach(function (f, index) {

                if (!f.type.match('image.*')) {
                return;
                }

                if (imgArray.length > maxLength) {
                return false
                } else {
                var len = 0;
                for (var i = 0; i < imgArray.length; i++) {
                    if (imgArray[i] !== undefined) {
                    len++;
                    }
                }
                if (len > maxLength) {
                    return false;
                } else {
                    imgArray.push(f);

                    var reader = new FileReader();
                    reader.onload = function (e) {
                    var html = "<div class='upload__img-box'><div style='background-image: url(" + e.target.result + ")' data-number='" + $(".upload__img-close").length + "' data-file='" + f.name + "' class='img-bg'><div class='upload__img-close'></div></div></div>";
                    imgWrap.append(html);
                    iterator++;
                    }
                    reader.readAsDataURL(f);
                }
                }
            });
            });
        });

        $('body').on('click', ".upload__img-close", function (e) {
            var file = $(this).parent().data("file");
            for (var i = 0; i < imgArray.length; i++) {
            if (imgArray[i].name === file) {
                imgArray.splice(i, 1);
                break;
            }
            }
            $(this).parent().parent().remove();
        });
        }
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/order/assign_order_view.blade.php ENDPATH**/ ?>