@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
    @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA')
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Edit Testimonial</h4>
                    <div class="ml-auto text-right">
                        <a href="{{url('admin/testimonial/list/')}}/{{$siteId}}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
		    <div class="row">
		        <div class="col-12">
		            <div class="card">
		                @foreach (['danger', 'warning', 'success', 'info'] as $msg)
		                    @if(Session::has('alert-' . $msg))
		                        <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
		                    @endif
		                @endforeach
		                <form action="{{route('admin.testimonial.edit', base64_encode($dataDetails->id))}}" method="POST" class="form-horizontal" id="formadd">
		                    @csrf
		                    <input type="hidden" name="formid" value="<?php echo $dataDetails->id; ?>">
		                    <input type="hidden" name="site_id" value="<?php echo $dataDetails->site_id; ?>">
		                    <div class="card-body">
		                        <h4 class="card-title">Testimonial Edit</h4>

		                        <div class="form-group m-t-20">
		                            <label>Name<span style="color:red;">*</span></label>
		                            <input type="text" class="form-control" id="name" name="name" placeholder="Enter Name" value="{{$dataDetails->name}}" required>
		                        </div>
		                        
		                        <div class="form-group m-t-20">
		                            <label>Send Place<span style="color:red;">*</span></label>
		                            <input type="text" class="form-control" id="send_place" name="send_place" placeholder="Enter Send Place" value="{{$dataDetails->send_place}}" required>
		                        </div>

		                        <div class="form-group m-t-20">
		                            <label>From Place<span style="color:red;">*</span></label>
		                            <input type="text" class="form-control" id="from_place" name="from_place" placeholder="Enter From Place" value="{{$dataDetails->place}}" required>
		                        </div>

		                        <div class="form-group m-t-20">
		                            <label>Content<span style="color:red;">*</span></label>
		                            <textarea class="form-control" rows="5" id="content" name="content" placeholder="Enter Content" required>{{$dataDetails->content}}</textarea>
		                        </div>

		                        <div class="form-group m-t-20">
		                            <label>Rating<span style="color:red;">*</span></label>
		                            <input type="number" class="form-control" id="rating" name="rating" min=0 max=5  placeholder="Enter rating" value="{{$dataDetails->rating}}" required>
		                        </div>
		                        
		                    </div>
		                    <div class="border-top">
		                        <div class="card-body">
		                            <input class="btn btn-primary" type="submit" value="UPDATE">
		                        </div>
		                    </div>
		                </form>
		            </div>
		        </div>
		    </div>
		</div>
    @endif
</main>    

<script type="text/javascript">
    $.validator.setDefaults({
	    submitHandler: function(form) {
	        form.submit();
	    }
    });

    $(function() {
        // validate the comment form when it is submitted
        $("#formadd").validate({
            ignore: [],
            errorPlacement: function(label, element) {
                label.addClass('mt-2 text-danger');
                label.insertAfter(element);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass('has-danger')
                $(element).addClass('form-control-danger')
            }
          });
    });

</script>     

@endsection