@extends('layouts.admin.app')
@section('content')

<main id="main" class="main">
    
        <div class="card">
            <div class="card-body">

                <h5 class="card-title">Product Search</h5>
                <div class="row mb-3">
                    <form action="{{url('/admin/product/product-search/')}}" method="post">
                    @csrf
                        <div class="col-12">
                            <div class="row">
                                <div class="col-2">
                                    <label for="inputText" class="col-form-label" style="font-size:17px"><b>PRODUCT FNID : </b></label>
                                </div>
                                <div class="col-5">
                                    <div class="col-12">
                                        <input class="form-control" id="search-field" name="search" value="{{$search}}" placeholder="Search By FNID" />
                                    </div>
                                </div>
                                <div class="col-5">
                                    <button class="btn btn-primary" type="submit">Search</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>  
                  
                
            </div>
        </div>
    
    @if($productdetails)
        <div class="card">
            <div class="card-body">
                <div class="col-12 d-flex no-block align-items-center justify-content-between mb-2">
                    <h5 class="card-title">{{$productdetails->fnid}} - Product Information {!! $productdetails->product_type == 'A' ? '<span class="badge rounded-pill bg-warning text-dark">Addon</span>' : ''!!}</h5>

                    <div class="ml-auto text-right">
                        {!! $productdetails->is_block == 'Y' ? '<span class="badge bg-danger">BLOCK</span>' : ''!!}
                    </div>
                </div>


                <table style="width:100%">
                    <tr>
                        {{-- <td><strong>ID : </strong>{{$productdetails->id}}</td> --}}

                        <td colspan="2">
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-4"><strong>FNID : </strong>{{$productdetails->fnid}} ({{$productdetails->id}})</div>
                                    <div class="col-4"><strong>SKU : </strong>{{$productdetails->sku}}</div>
                                    <div class="col-4"><strong>OLD ID : </strong>{{$productdetails->old_id}}</div>
                                </div>
                            </div>
                        </td>
                        
                        {{-- <td><strong>FNID : </strong>{{$productdetails->fnid}} ({{$productdetails->id}})</td>
                        <td><strong>OLD ID : </strong>{{$productdetails->sku}}</td> --}}
                        <td rowspan="6">
                            <div class="image-box">
                                <img src="https://giftbasketsbrazil.rightflorist.org/uploaded/product/{{$productdetails->fnid}}.webp" style="width:200px; height: auto;">
                            </div>
                        </td>
                    </tr>
                    <tr>
                        @if($productdetails->has_attribute == 'N')
                            <td><strong>Price : </strong>Rs. {{$productdetails->price}}</td>
                            <td><strong>MRP : </strong>Rs. {{$productdetails->actual_price}}</td>
                        @endif    
                    </tr>
                    <tr>
                        <td><strong>Delivery Type : </strong>
                            {{$productdetails->delivery_type == 'H' ? 'Hand Delivery' : 'Courier'}}
                        </td>
                        <td><strong>Delay Days : </strong>{{$productdetails->delivery_delay_days}}</td>
                    </tr>
                    <tr>
                        <td><strong>Specification : </strong>{{ucwords($productdetails->specification)}}</td>
                        <td><strong>Segregation : </strong>{{ucwords($productdetails->segregation)}}</td>
                    </tr>
                    <tr>
                        <td><strong>Vendor Name : </strong>
                            {{$productdetails->vendor_name == 'NORMAL' ? '' : $productdetails->vendor_name}}
                        </td>
                        <td><strong>Product Attribute : </strong>{{$productdetails->has_attribute}}</td>
                    </tr>
                    
                    <tr>
                        @if($productPersonalize)
                        <td><strong>Personalize No of Images : </strong>{{$productPersonalize->no_of_image}}</td>
                        <td><strong>Personalize Text :</strong> </strong>{{$productPersonalize->text_msg}}</td>
                        @endif
                    </tr>

                    <tr>
                        <td colspan="3" style="padding: 0; border: 0px;">
                            <table style="width:100%">
                                <tr>
                                    <td style="width: 14%;"><strong>Slug : </strong></td>
                                    <td>{{$productdetails->slug}}</td>
                                </tr>
                                <tr>
                                    <td><strong>Title : </strong></td>
                                    <td>{{$productdetails->product_name}}</td>
                                </tr>

                                <tr>
                                    <td><strong>Description : </strong></td>
                                    <td>{!! $productdetails->description !!}</td>
                                </tr>
                                @if($productdetails->has_attribute == 'Y')
                                    <tr>
                                        <td colspan="2">
                                            <p><strong>Variation:</strong></p>
                                            @if(!empty($productAttribute))
                                            <table class="table table-bordered">
                                                <thead>
                                                  <tr>
                                                    <th scope="col">Id</th>
                                                    <th scope="col">Old ID</th>
                                                    <th scope="col">Content</th>
                                                    <th scope="col">Price</th>
                                                    <th scope="col">MRP</th>
                                                  </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($productAttribute as $data)
                                                      <tr>
                                                        <th scope="row">{{$data->id}}</th>
                                                        <td>{{$data->sku_old}}</td>
                                                        <td>{{$data->content}}</td>
                                                        <td>{{$data->price}}</td>
                                                        <td>{{$data->actual_price}}</td>
                                                      </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                            @endif
                                        </td>
                                    </tr>
                                @else
                                    <tr>
                                        <td><strong>Content : </strong></td>
                                        <td>{!! $productdetails->content !!}</td>
                                    </tr>
                                @endif    
                                <tr>
                                    <td><strong>Alt Key : </strong></td>
                                    <td>{!! $productdetails->alt_key !!}</td>
                                </tr>
                                <tr>
                                    <td><strong>Meta Title : </strong></td>
                                    <td>{!! $productdetails->meta_title !!}</td>
                                </tr>
                                <tr>
                                    <td><strong>Meta Description : </strong></td>
                                    <td>{!! $productdetails->meta_description !!}</td>
                                </tr>
                            </table>


                        </td>
                    </tr>
                    
                </table>
                
            </div>
        </div>
    @else
        
    @endif    
   
</main>

<style>
    
    table {
        border-collapse: collapse;
        width: 1000px;
    }
    td {
        border: 1px solid #eaebec;
        padding: 2px 5px;
        text-align: left;
        vertical-align: middle;
    }
    .image-box {
        border: 2px solid red;
        height: 200px;
        width: 90px;
        margin: 0 auto;
        display: flex;
        align-items: center;
        justify-content: center;
        color: red;
    }
    
</style>

@endsection