@extends('layouts.admin.app')
@section('content')
<div class="container">
    <form action="{{url('/admin/product/product_export')}}" method="post">
        @csrf
        <div class="table-responsive">
            <table class="table table-bordered" style="margin-top: 6%;">
                <thead class="thead-dark">
                    <tr>
                        <th scope="col" colspan="5" class="text-center">PRODUCT EXCEL REPORT</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>
                            <select name="delivery_type" id="delivery_type" class="form-control">
                                <option value="" selected>Select Delivery Type</option>
                                @foreach($delivery_type as $key => $delivery_types)
                                <option value="{{$delivery_types}}">{{$delivery_types}}</option>
                                @endforeach
                            </select>
                        </td>
                        <td>
                            <select name="specification" id="specification" class="form-control">
                                <option value="" selected>Select Specification</option>
                                @foreach($specification as $key => $specifications)
                                <option value="{{$specifications}}">{{$specifications}}</option>
                                @endforeach
                            </select>
                        </td>
                        <td>
                            <select name="segregation" id="segregation" class="form-control">
                                <option value="" selected>Select Segregation</option>
                                @foreach($segregation as $key => $segregations)
                                <option value="{{$segregations}}">{{$segregations}}</option>
                                @endforeach
                            </select>
                        </td>
                        <td>
                            <select name="vendor_name" id="vendor_name" class="form-control">
                                <option value="" selected>Select Vendor Name</option>
                                @foreach($vendor_name as $key => $vendor_names)
                                <option value="{{$vendor_names}}">{{$vendor_names}}</option>
                                @endforeach
                            </select>
                        </td>
                        <td>
                            <button type="button" id="btn_export" class="btn btn-primary">Export</button>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </form>

    <!-- Scrollable Table -->
    <div class="table-responsive" style="margin-top: 20px;">
    <div style="max-height: 400px; overflow-y: auto;">
        <table class="table table-striped table-bordered" id="firstMethod" style="display:none;">
            <thead class="thead-dark">
                <tr>
                    <th>PRODUCT ID</th>
                    <th>SKU</th>
                    <th>FNID</th>
                    <th>PRODUCT NAME</th>
                    <th>DESCRIPTION</th>
                    <th>CONTENT</th>
                    <th>PRICE</th>
                    <th>DELIVERY TYPE</th>
                    <th>SPECIFICATION</th>
                    <th>SEGREGATION</th>
                    <th>VENDOR NAME</th>
                </tr>
            </thead>
            <tbody id="table_to_export_firstMethod"></tbody>
        </table>
    </div>
    <div style="max-height: 400px; overflow-y: auto;">
        <table class="table table-striped table-bordered" id="myTable">
            <thead class="thead-dark">
                <tr>
                    <th>PRODUCT ID</th>
                    <th>SKU</th>
                    <th>FNID</th>
                    <th>PRODUCT NAME</th>
                    <th>DESCRIPTION</th>
                    <th>CONTENT</th>
                    <th>PRICE</th>
                    <th>DELIVERY TYPE</th>
                    <th>SPECIFICATION</th>
                    <th>SEGREGATION</th>
                    <th>VENDOR NAME</th>
                </tr>
            </thead>
            <tbody id="table_to_export"></tbody>
        </table>
    </div>

    <div style="max-height: 400px; overflow-y: auto; margin-top: 20px;">
        <table class="table table-striped table-bordered" id="productAttr">
            <thead class="thead-dark">
                <tr>
                    <th>ID</th>
                    <th>PRODUCT ID</th>
                    <th>SKU OLD</th>
                    <th>FNID</th>
                    <th>DESCRIPTION</th>
                    <th>PRICE</th>
                </tr>
            </thead>
            <tbody id="table_to_export_attr"></tbody>
        </table>
    </div>
</div>

    <div style="text-align:center;display:flex;flex-direction: row;align-content: space-around;justify-content: center;align-items: baseline;" id="appendbutton">
        </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

<script>
$(document).ready(function(){
    // $('#btn_export').click(function(){
    //     $('#table_to_export').empty(); // Clear previous data
    //     $('#export').remove();

    //     var delivery_type = $('#delivery_type').val();
    //     var specification = $('#specification').val();
    //     var segregation = $('#segregation').val();
    //     var vendor_name = $('#vendor_name').val();

    //     $.ajax({
    //         url: "{{url('/admin/product/get_data')}}",
    //         type: "get",
    //         data: {
    //             delivery_type: delivery_type,
    //             specification: specification,
    //             segregation: segregation,
    //             vendor_name: vendor_name,
    //         },
    //         success: function(response){
    //             if(response.length > 0){
    //                 $.each(response, function(index, value){
    //                     var productRow = `
    //                     <tr>
    //                         <td>${value.id}</td>
    //                         <td>${value.sku}</td>
    //                         <td>${value.fnid}</td>
    //                         <td>${value.product_name}</td>
    //                         <td>${value.desc}</td>
    //                         <td>${value.content}</td>
    //                         <td>${value.price}</td>
    //                         <td>${value.delivery_type}</td>
    //                         <td>${value.specification}</td>
    //                         <td>${value.segregation}</td>
    //                         <td>${value.vendor_name}</td>
    //                     </tr>`;

    //                     $('#table_to_export').append(productRow);

    //                     if (value.product_attr && value.product_attr.length > 0) {
    //                         $.each(value.product_attr, function(key, product_attr){
    //                             var attrRow = `
    //                             <tr>
    //                                 <td></td>
    //                                 <td>${product_attr.skuold}</td>
    //                                 <td>${product_attr.product_fnid}</td>
    //                                 <td></td>
    //                                 <td>${product_attr.desc}</td>
    //                                 <td></td>
    //                                 <td>${product_attr.price}</td>
    //                                 <td></td>
    //                                 <td></td>
    //                                 <td></td>
    //                                 <td></td>
    //                             </tr>`;
    //                             $('#table_to_export').append(attrRow);
    //                         });
    //                     }
    //                 });

    //                 $('#appendbutton').append(`
    //                     <button id="export" type="button" class="btn btn-success">Download in Excel</button>
    //                 `);
    //             } else {
    //                 $('#table_to_export').html(`
    //                 <tr>
    //                     <td colspan="12" class="text-center text-danger">No Orders Found</td>
    //                 </tr>`);
    //             }
    //         },
    //         error: function(error){
    //             console.log(error);
    //         }
    //     });
    // });
    $('#btn_export').click(function(){
        $('#table_to_export_firstMethod').empty();
        $('#table_to_export').empty(); // Clear previous data
        $('#table_to_export_attr').empty(); // Clear previous data
        $('#export').remove();
        $('#export2').remove();

        var delivery_type = $('#delivery_type').val();
        var specification = $('#specification').val();
        var segregation = $('#segregation').val();
        var vendor_name = $('#vendor_name').val();

        $.ajax({
            url: "{{url('/admin/product/get_data')}}",
            type: "get",
            data: {
                delivery_type: delivery_type,
                specification: specification,
                segregation: segregation,
                vendor_name: vendor_name,
            },
            success: function(response){

                
                if(response.length > 0){
                    $.each(response, function(index, value){
                        var productRow = `
                        <tr>
                            <td>${value.id}</td>
                            <td>${value.sku}</td>
                            <td>${value.fnid}</td>
                            <td>${value.product_name}</td>
                            <td>${value.desc}</td>
                            <td>${value.content}</td>
                            <td>${value.price}</td>
                            <td>${value.delivery_type}</td>
                            <td>${value.specification}</td>
                            <td>${value.segregation}</td>
                            <td>${value.vendor_name}</td>
                        </tr>`;

                        $('#table_to_export_firstMethod').append(productRow);

                        if (value.product_attr && value.product_attr.length > 0) {
                            $.each(value.product_attr, function(key, product_attr){
                                var attrRow = `
                                <tr>
                                    <td></td>
                                    <td>${product_attr.skuold}</td>
                                    <td>${product_attr.product_fnid}</td>
                                    <td></td>
                                    <td>${product_attr.desc}</td>
                                    <td></td>
                                    <td>${product_attr.price}</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>`;
                                $('#table_to_export_firstMethod').append(attrRow);
                            });
                        }
                    });
                    $.each(response, function(index, value){
                        var productRow = `
                        <tr>
                            <td>${value.id}</td>
                            <td>${value.sku}</td>
                            <td>${value.fnid}</td>
                            <td>${value.product_name}</td>
                            <td>${value.desc}</td>
                            <td>${value.content}</td>
                            <td>${value.price}</td>
                            <td>${value.delivery_type}</td>
                            <td>${value.specification}</td>
                            <td>${value.segregation}</td>
                            <td>${value.vendor_name}</td>
                        </tr>`;

                        $('#table_to_export').append(productRow);

                        if (value.product_attr && value.product_attr.length > 0) {
                            $.each(value.product_attr, function(key, product_attr){
                                var attrRow = `
                                <tr>
                                    <td>${product_attr.id}</td>
                                    <td>${value.id}</td>
                                    <td>${product_attr.skuold}</td>
                                    <td>${product_attr.product_fnid}</td>
                                    <td>${product_attr.desc}</td>
                                    <td>${product_attr.price}</td>
                                </tr>`;
                                $('#table_to_export_attr').append(attrRow);
                            });
                        }
                    });

                    $('#appendbutton').append(`
                        <button id="export" type="button" class="btn btn-success">First Method</button>
                        <button id="export2" type="button" class="btn btn-primary">Second Method</button>

                    `);
                } else {
                    $('#table_to_export').html(`
                    <tr>
                        <td colspan="12" class="text-center text-danger">No Orders Found</td>
                    </tr>`);
                }
            },
            error: function(error){
                console.log(error);
            }
        });
    });
    $(document).on('click', '#export', function() {
        let table1 = document.getElementById("myTable");
        let table2 = document.getElementById("productAttr");

        let wb = XLSX.utils.book_new();
        
        let ws1 = XLSX.utils.table_to_sheet(table1.cloneNode(true));
        let ws2 = XLSX.utils.table_to_sheet(table2.cloneNode(true));

        XLSX.utils.book_append_sheet(wb, ws1, "Product Data");
        XLSX.utils.book_append_sheet(wb, ws2, "Product Attributes");

        XLSX.writeFile(wb, "order.xlsx");
    });

    $(document).on('click', '#export2', function() {
        let table = document.getElementById("firstMethod");
        let wb = XLSX.utils.book_new();
        let ws = XLSX.utils.table_to_sheet(table.cloneNode(true));
        XLSX.utils.book_append_sheet(wb, ws, "Product Data");
        XLSX.writeFile(wb, "order.xlsx");
    });

});


</script>

@endsection
