@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<!-- <script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script> -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
    @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA')
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">HomeFeatureManagement</h4>
                    <div class="ml-auto text-right">
                        <a href="{{url('admin/homefeaturemanagement/list/')}}/{{$site_id}}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                            @if(Session::has('alert-' . $msg))
                                <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
                            @endif
                        @endforeach
                        <form action="{{url('admin/homefeaturemanagement/add/')}}/{{$site_id}}" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <h4 class="card-title">HomeFeatureManagement Add</h4>
                                <input type="hidden" id="site_id" name="site_id" value="<?php echo $site_id; ?>">
                                <div class="form-group m-t-20">
                                    <label>Title<span style="color:red;">*</span></label>
                                    <input type="text" class="form-control" id="title" name="title" placeholder="Enter Title" required>
                                </div>
                                
                                <div class="form-group m-t-20">
                                    <label>Description</label>
                                    <input type="text" class="form-control" id="description" name="description" placeholder="Enter Description">
                                </div>

                                <div class="form-group m-t-20">
                                    <label>Slug</label>
                                    <input type="text" class="form-control" id="slug" name="slug" placeholder="Enter slug">
                                </div>

                                <div class="form-group m-t-20">
                                    <label>Catagory<span style="color:red;">*</span></label>

                                    <select id="category-products" name="category" class="form-control selectpicker2" data-live-search="true" data-live-search-placeholder="Search" data-actions-box="true" required>
                                        <option value="">-Select-</option>
                                        @foreach($category as $category)
                                            <option value="{{$category->id}}" data-catid="{{$category->id}}">{{$category->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                               
                                <div class="form-group m-t-20">
                                    <label>Products<span style="color:red;">*</span></label>
                                    
                                    <select class="form-control selectpicker2" name="product_id[]" multiple="multiple" data-live-search="true" data-live-search-placeholder="Search" data-actions-box="true"  id="product_id" required></select>

                                </div>

                                <div class="form-group m-t-20">
                                    <label>Data Limit<span style="color:red;">*</span></label>
                                    <input type="text" class="form-control" id="data_limit" name="data_limit" placeholder="Enter Limit value" required>

                                </div>

                                <div class="form-group m-t-20">
                                    <label>Sort</label>
                                    <input type="number" class="form-control" id="sort" name="sort" placeholder="Enter Sort value">
                                </div>
                            </div>
                            <div class="border-top">
                                <div class="card-body">
                                    <input class="btn btn-primary" type="submit" value="CREATE">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif 

</main>   

<script type="text/javascript">

    $.validator.setDefaults({
        submitHandler: function(form) {
            form.submit();
        }
    });

    $(function() {
        $('.selectpicker2').selectpicker();
        // validate the comment form when it is submitted
        $("#formadd").validate({
            ignore: [],
            errorPlacement: function(label, element) {
                label.addClass('mt-2 text-danger');
                label.insertAfter(element);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass('has-danger')
                $(element).addClass('form-control-danger')
            }
          });
    });


    $(document).on('change', '#category-products', function(event){

        setTimeout(function () {
            $('#category-products-error').attr("style", "display: none !important");
        },100); // 60000ms = 1 minute

        var cgnobj = this;
        var catid = $(this).val();
        var site_id = $('#site_id').val();

        $.ajax({
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            async: true,
            type : "POST",
            url : "{{ route('admin.homefeaturemanagement.categoryproduct') }}",
            data:  { 
                catid : catid,
                site_id : site_id 
            },
            success : function(response){
                response = JSON.parse(response);
                console.log(response);
                $('#product_id').html(response.data);
                  
                $('.selectpicker2').selectpicker('refresh');

            },
            error : function(){
            }
            
        });  
    })

</script>    

@endsection

