@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Agent Delivey Charges</h4>
                    <div class="ml-auto text-right">
                        <a href="{{route('admin.agent.agentProductList', ['id' => encrypt($dataDetails->agent_id)])}}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                            @if(Session::has('alert-' . $msg))
                                <div class="alert alert-{{ $msg }} alert-dismissible fade show" role="alert">
                                    {{ Session::get('alert-' . $msg) }}
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @endif
                        @endforeach
                        <form action="{{url('admin/agent/delivery-charge-edit')}}/{{encrypt($dataDetails->id)}}" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <h4 class="card-title">Delivey Charges</h4>

                                <input type="hidden" name="formid" value="<?php echo $dataDetails->id; ?>">

                                <div class="form-group m-t-20">
                                    <label>Standard Delivery Charge</label>
                                    <input type="number" class="form-control" id="s_delivery" name="s_delivery" value="{{$dataDetails->s_delivery}}" placeholder="Standard Delivery Charge" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Midnight Delivery Charge</label>
                                    <input type="number" class="form-control" id="m_delivery" name="m_delivery" value="{{$dataDetails->m_delivery}}" placeholder="Midnight Delivery Charge" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Express Delivery Charge</label>
                                    <input type="number" class="form-control" id="e_delivery" name="e_delivery" value="{{$dataDetails->e_delivery}}" placeholder="Express Delivery Charge" required>
                                </div>
                            </div>
                            <div class="border-top">
                                <div class="card-body">
                                    <input class="btn btn-primary" type="submit" value="UPDATE">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
</main>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script> 

<script type="text/javascript">
    

</script>    

@endsection

