@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Create Agent Product</h4>
                    <div class="ml-auto text-right">
                        <a href="{{route('admin.agent.agentProductList', ['id' => encrypt($agent_id)])}}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                            @if(Session::has('alert-' . $msg))
                                <div class="alert alert-{{ $msg }} alert-dismissible fade show" role="alert">
                                    {{ Session::get('alert-' . $msg) }}
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @endif
                        @endforeach
                        <form action="{{url('/admin/agent/agent-product-add')}}/{{encrypt($agent_id)}}" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <h4 class="card-title">Create Agent Product</h4>
                                
                                <div class="form-group m-t-20">
                                    <label>Product Item</label>
                                    <input type="text" class="form-control" id="item" name="item" placeholder="Enter Product Item" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Product Slug</label>
                                    <input type="text" class="form-control" id="slug" name="slug" placeholder="Enter Product Slug">
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Product Price</label>
                                    <input type="number" class="form-control" id="price" name="price" min="0" step="0.01"placeholder="Enter Product Price" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Gst</label>
                                    <input type="number" class="form-control" id="gst" name="gst" min="0" step="0.01" placeholder="Enter Gst" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Price Without Gst</label>
                                    <input type="number" class="form-control" id="price_without_gst" min="0" step="0.01" name="price_without_gst" placeholder="Enter Price Without Gst" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Is Personalized</label>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="is_personalized" id="is_personalized" value="Y" required>
                                        <label class="form-check-label" for="">Yes</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="is_personalized" id="is_personalized" value="N">
                                        <label class="form-check-label" for="">No</label>
                                    </div>
                                </div>
                            </div>
                            <div class="border-top">
                                <div class="card-body">
                                    <input class="btn btn-primary" type="submit" value="CREATE">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
</main>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script> 

<script type="text/javascript">
    

</script>    

@endsection

