<?php



namespace App\Http\Controllers\Agent;
use App\Http\Controllers\Controller;

use App\Models\contact1;

use App\Models\contact2;

use App\Models\contact3;

use App\Models\chat;

use App\Models\User;

use App\Models\Agent;

use App\Models\AdminLogin;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Hash;

use Illuminate\Support\Facades\Validator;

use Illuminate\Support\Collection;



class AgentController extends Controller

{

    public function AgentLogin(){

        return view('agent.login');

    }



    public function AgentLogedIn(Request $request){

        // dd("hello");

        $credentials = $request->only(['email', 'password']);

        // dd($credentials);



        if (Auth::guard('AgentLogin')->attempt($credentials, $request->filled('remember'))) {

            // return $user = Auth::guard('AdminLogin')->user();

            // dd("success");

            return redirect()->route('agent.assignorder.dashboard')->with('success', 'Welcome to Admin Dashboard');        

        }else{

            // dd("failed");

            // return back()->withErrors(['email' => 'Invalid credentials'])->withInput($request->only('email'));

            return redirect()->back()->with('error', 'Please enter valid login details');        

        }

    }



    public function logout()

    {

        Auth::guard('AgentLogin')->logout();

        return redirect()->route('agent.login');

    }

    public function dashboard(){
        if(Auth::check()){
            $id = Auth::id();

            $startOfToday = date('Y-m-d 00:00:00');
            $endOfToday = date('Y-m-d 23:59:59');

            $startOfMonth = date('Y-m-01 00:00:00');
            $endOfMonth = date('Y-m-t 23:59:59'); 

            $todayOrders = DB::connection('mysql')->table('agent_assinged')->where('agent_id', $id)->whereBetween('created_at', [$startOfToday, $endOfToday])->count();
            $todayPendingOrders = DB::connection('mysql')->table('agent_assinged')->where('agent_id', $id)->where('status','P')->whereBetween('created_at', [$startOfToday, $endOfToday])->count();
            $monthOrders = DB::connection('mysql')->table('agent_assinged')->where('agent_id', $id)->whereBetween('created_at', [$startOfMonth, $endOfMonth])->count();
            $TotalPendingOrders = DB::connection('mysql')->table('agent_assinged')->where('agent_id', $id)->where('status','P')->count();

            return view('agent.dashboard',compact('todayOrders','todayPendingOrders','monthOrders','TotalPendingOrders'));
        }else{
           return redirect()->route('agent.login')->with('error', 'Please enter valid login details'); 
        }
    }

    //Backup
    // public function list(){

    //     // dd("hello");

    //     // $check = Auth::check();

    //     // dd($check);

    //     if(Auth::check()){

    //         $user = Auth::guard('AgentLogin')->user();

    //         $filered_product = [];

    //         $products = [];

    //         $agent_product_list=[];

    //         $orders1 = [];

    //         $product_maped = [];

    //         // $agentassign = [];



    //         $agent_assigned = DB::connection('mysql')

    //             ->table('agent_assinged')

    //             ->where('agent_id', $user->id)

    //             ->get();

    //         // dd($agent_assigned); 



    //         $agentassign = DB::connection('mysql')

    //             ->table('agent_assinged')

    //             ->where('agent_id', $user->id)

    //             ->get();

    //         // dd($agentassign);



    //         $assined = DB::connection('mysql')

    //             ->table('agent_assinged')

    //             ->get();



    //         foreach($agentassign as $agentassigns){    

    //             if($agentassigns!=''){

    //                 $product_maped[] = DB::connection('mysql')->table('assigned_agent_product_map')->where('agent_assinged_id',$agentassigns->id)->get();

    //             }else{

    //                 $product_maped = [];

    //             }

    //         }



    //         // dd($product_maped);



    //         // echo "<pre>";

    //         // print_r($product_maped);

    //         // die();           



    //         // $orders = DB::connection('mysql')->table('orders')->where('id',$agentassign->OID)->get();

    //         // foreach($agent_assigned as $agent_assigneds){

    //         //     $orders[] = DB::connection('mysql')->table('orders')->where('id',$agent_assigneds->OID)->first();

                

    //         // }

    //         foreach($agent_assigned as $agent_assigneds){

	//             $orders1[] = DB::connection('mysql')->table('orders')

	//             			->leftJoin('agent_assinged', 'agent_assinged.OID', '=', 'orders.id')

	//                         ->where('orders.id',$agent_assigneds->OID)

	//                         ->where('agent_assinged.agent_id',$user->id)

	//                         ->select('orders.id','agent_assinged.agent_id','orders.unique_order_id')

	//                         ->first();

	//         }

    //         // dd($orders);



    //         // return $orders;

    //         // foreach($product_maped as $product_mapeds){

    //         //     $products[] = DB::connection('mysql')->table('products')->where('id',$product_mapeds->product_id)->first();

    //         //     $agent_product_list[] = DB::connection('mysql')->table('agent_product_list')->where('id',$product_mapeds->product_id)->first();



    //         // }



    //         foreach($product_maped as $key){

    //             foreach($key as $product_mapeds){

    //                 $agent_product_list[] = DB::connection('mysql')->table('agent_product_list')

    //                                     ->where('id', $product_mapeds->product_id)

    //                                     ->first();

    //             }

                

    //             // dd($productId)

    //             // $agent_product_list[] = DB::connection('mysql')->table('agent_product_list')

    //             //                         ->where('id', $product_maped->$key->$product_mapeds->product_id)

    //             //                         ->first();

    //         }

    //         // dd($agent_product_list);



    //         // $agents = DB::connection('mysql')->table('agents')->get();

    //         $order_details = DB::connection('mysql')->table('order_details')->get();

    //         $orders = DB::connection('mysql')->table('orders')->get();

    //         $assigned_agent_product_map =  DB::connection('mysql')->table('assigned_agent_product_map')->get();



    //         return view('agent.list', compact('user','agent_assigned','assigned_agent_product_map','products','order_details','orders','product_maped','agent_product_list','assined','orders1'));

    //     }else{

    //         return redirect()->route('agent.login');

    //     }

    // }

    public function list(Request $request){

        if(Auth::check()){
            $user = Auth::guard('AgentLogin')->user();
            $where = $orWhere = [];

            //search conditions
            if($request->search != null){
                // if (str_contains($request->search, '@')) { 
                //     $userDtl = Admin::where(['email'=> $request->search])->first();
                //     if($userDtl){
                //         $orWhere[] = ['placed_userid', '=', $userDtl->id];
                //     }
                // }

                $orWhere[] = ['agent_order_id', 'LIKE', '%'.$request->search.'%'];
                //$orWhere[] = ['delivery_user_name', 'LIKE', '%'.$request->search.'%'];
                //$orWhere[] = ['billing_user_name', 'LIKE', '%'.$request->search.'%'];
                $search=$request->search;
            }else{
                $search='';
            }

            $result = DB::connection('mysql')->table('agent_assinged')->where('agent_id', $user->id)
                        ->where(function($query) use ($orWhere, $request){
                            // creating "OR" queries for search
                            foreach($orWhere as $key => $where){
                                if($key == 0){
                                    $query->where([$where]);
                                }else{
                                    $query->orWhere([$where]);
                                }
                            }
                        })
                        ->when($request->sort && $request->direction, function($query) use ($request){
                            $query->orderBy($request->sort, $request->direction);
                        }, function($query){
                            $query->orderBy('created_at', 'desc');
                        })
                        ->paginate(30);


            return view('agent.list', compact('result', 'user', 'search', 'request'));

        }else{

            return redirect()->route('agent.login');

        }

    }


    //Backup
    // public function listSearch(Request $request,$agentid){

    //     // dd("hello");

    //     // $check = Auth::check();

    //     // dd($check);

    //     if(Auth::check()){

    //         $agentid=decrypt($agentid);
    //         $user = Auth::guard('AgentLogin')->user();

    //         $filered_product = [];

    //         $products = [];

    //         $agent_product_list=[];

    //         $orders1 = [];

    //         $product_maped = [];

    //         // $agentassign = [];

    //         // $aa=$request['fromDate'];

    //         // dd($aa);



    //         $agent_assigned = DB::connection('mysql')

    //         ->table('agent_assinged')

    //         ->where('agent_id', $user->id)

    //         ->whereBetween('created_at', [$request['fromDate'], $request['toDate']])

    //         ->where('status', $request['status'])

    //         ->get();

            

    //         // dd($agent_assigned);

    //         $agentassign = DB::connection('mysql')

    //             ->table('agent_assinged')

    //             ->where('agent_id', $user->id)

    //             ->get();

    //         // dd($agentassign);



    //         $assined = DB::connection('mysql')

    //             ->table('agent_assinged')

    //             ->get();



    //         foreach($agent_assigned as $agent_assigneds){    

    //             if($agent_assigneds!=''){

    //                 $product_maped[] = DB::connection('mysql')->table('assigned_agent_product_map')->where('agent_assinged_id',$agent_assigneds->id)->get();

    //             }else{

    //                 $product_maped = [];

    //             }

    //         }



    //         // dd($product_maped);



    //         // echo "<pre>";

    //         // print_r($product_maped);

    //         // die();           



    //         // $orders = DB::connection('mysql')->table('orders')->where('id',$agentassign->OID)->get();

    //         // foreach($agent_assigned as $agent_assigneds){

    //         //     $orders[] = DB::connection('mysql')->table('orders')->where('id',$agent_assigneds->OID)->first();

                

    //         // }

    //         foreach($agent_assigned as $agent_assigneds){

    //             $orders1[] = DB::connection('mysql')->table('orders')

    //                         ->leftJoin('agent_assinged', 'agent_assinged.OID', '=', 'orders.id')

    //                         ->where('orders.id',$agent_assigneds->OID)

    //                         ->where('agent_assinged.agent_id',$user->id)

    //                         ->select('orders.id','agent_assinged.agent_id','orders.unique_order_id')

    //                         ->first();

    //         }

    //         // dd($orders);



    //         // return $orders;

    //         // foreach($product_maped as $product_mapeds){

    //         //     $products[] = DB::connection('mysql')->table('products')->where('id',$product_mapeds->product_id)->first();

    //         //     $agent_product_list[] = DB::connection('mysql')->table('agent_product_list')->where('id',$product_mapeds->product_id)->first();



    //         // }



    //         foreach($product_maped as $key){

    //             foreach($key as $product_mapeds){

    //                 $agent_product_list[] = DB::connection('mysql')->table('agent_product_list')

    //                                     ->where('id', $product_mapeds->product_id)

    //                                     ->first();

    //             }

                

    //             // dd($productId)

    //             // $agent_product_list[] = DB::connection('mysql')->table('agent_product_list')

    //             //                         ->where('id', $product_maped->$key->$product_mapeds->product_id)

    //             //                         ->first();

    //         }

    //         // dd($agent_product_list);



    //         // $agents = DB::connection('mysql')->table('agents')->get();

    //         $order_details = DB::connection('mysql')->table('order_details')->get();

    //         $orders = DB::connection('mysql')->table('orders')->get();

    //         $assigned_agent_product_map =  DB::connection('mysql')->table('assigned_agent_product_map')->get();



    //         return view('agent.list', compact('user','agent_assigned','assigned_agent_product_map','products','order_details','orders','product_maped','agent_product_list','assined','orders1'));

    //     }else{

    //         return redirect()->route('agent.login');

    //     }

    // }

    public function listSearch(Request $request,$agentid){

        if(Auth::check()){

            $user = Auth::guard('AgentLogin')->user();
            $where = $orWhere = [];

            if($request->status != null){
                $where[] = ['status', '=', $request->status];
            }

            //search conditions
            if($request->search != null){
                // if (str_contains($request->search, '@')) { 
                //     $userDtl = Admin::where(['email'=> $request->search])->first();
                //     if($userDtl){
                //         $orWhere[] = ['placed_userid', '=', $userDtl->id];
                //     }
                // }

                $orWhere[] = ['agent_order_id', 'LIKE', '%'.$request->search.'%'];
                //$orWhere[] = ['delivery_user_name', 'LIKE', '%'.$request->search.'%'];
                //$orWhere[] = ['billing_user_name', 'LIKE', '%'.$request->search.'%'];
                $search=$request->search;
            }else{
                $search='';
            }

            $result = DB::connection('mysql')->table('agent_assinged')->where('agent_id', $user->id)->where($where)
                        ->where(function($query) use ($orWhere, $request){
                            // creating "OR" queries for search
                            foreach($orWhere as $key => $where){
                                if($key == 0){
                                    $query->where([$where]);
                                }else{
                                    $query->orWhere([$where]);
                                }
                            }

                            if ($request->fromDate && $request->toDate) {
                                $query->orWhereBetween('delivery_date', [$request->fromDate, $request->toDate]);
                            }
                            
                        })
                        ->when($request->sort && $request->direction, function($query) use ($request){
                            $query->orderBy($request->sort, $request->direction);
                        }, function($query){
                            $query->orderBy('created_at', 'desc');
                        })
                        ->paginate(30);


            return view('agent.list', compact('result', 'user', 'search', 'request'));

        }else{

            return redirect()->route('agent.login');

        }

    }



    public function generateReport(){

        if(Auth::check()){

            $user = Auth::guard('AgentLogin')->user();

            return view('agent.generateReport',compact('user'));

        }else{

            return redirect()->route('agent.login');

        }   

    }

    public function AgentMonthPayment(Request $request){
        if(Auth::check()){

            $user = Auth::guard('AgentLogin')->user();

            if($request->isMethod('POST')){
                // return $request->all();
                $agentid=$user->id;
                $result = 1;
                $filered_product = [];
                $products = [];
                $agent_product_list=[];
                $orders1 = [];
                $product_maped = [];
                $startDate = $request['fromDate'];
                $EndDate = $request['toDate'];

                $agent_assigned = DB::connection('mysql')->table('agent_assinged')->where('agent_id', $user->id)->whereBetween('created_at', [$request['fromDate'], $request['toDate']])->where('status', 'D')->get();

                $agentassign = DB::connection('mysql')
                    ->table('agent_assinged')
                    ->where('agent_id', $user->id)
                    ->get();

                $assined = DB::connection('mysql')
                    ->table('agent_assinged')
                    ->get();



                foreach($agent_assigned as $agent_assigneds){    
                    if($agent_assigneds!=''){
                        $product_maped[] = DB::connection('mysql')->table('assigned_agent_product_map')->where('agent_assinged_id',$agent_assigneds->id)->get();
                    }else{
                        $product_maped = [];
                    }

                }

                foreach($agent_assigned as $agent_assigneds){
                    $orders1[] = DB::connection('mysql')->table('orders')
                                ->leftJoin('agent_assinged', 'agent_assinged.OID', '=', 'orders.id')
                                ->where('orders.id',$agent_assigneds->OID)
                                ->where('agent_assinged.agent_id',$user->id)
                                ->select('orders.id','agent_assinged.agent_id','orders.unique_order_id')
                                ->first();

                }

                foreach($product_maped as $key){
                    foreach($key as $product_mapeds){
                        $agent_product_list[] = DB::connection('mysql')->table('agent_product_list')->where('id', $product_mapeds->product_id)->first();

                    }
                }
                $order_details = DB::connection('mysql')->table('order_details')->get();
                $orders = DB::connection('mysql')->table('orders')->get();
                $assigned_agent_product_map =  DB::connection('mysql')->table('assigned_agent_product_map')->get();



                return view('agent.AgentMonthPayment', compact('result','user','agent_assigned','assigned_agent_product_map','products','order_details','orders','product_maped','agent_product_list','assined','orders1','startDate','EndDate'));
                // return view('agent.AgentMonthPayment',compact('result'));
            }else{

                $result = 0;
                return view('agent.AgentMonthPayment',compact('result','user'));
            }

        }else{
            return redirect()->route('agent.login')->with('error', 'Please enter valid login details'); 
        }
    }



    // public function GetReport(Request $request){

    //     if(Auth::check()){

        

    //         $orderDetails = [];

    //         $order = [];

    //         $orderTotalPrice = [];

    //         $agentTotalPrice = [];

    //         $profit = [];

    //         $unique_order_id = [];

    //         $delivery_dates = [];

    //         $delivery_cities = [];



    //         $user = Auth::guard('AgentLogin')->user();

    //         $start_date = $request['start-date'];

    //         $end_date = $request['end-date'];

    //         $agent = DB::connection('mysql')->table('agents')->where('id',$user->id)->first();



    //         $agent_assinged = DB::connection('mysql')

    //         ->table('agent_assinged')

    //         ->where('status','D')

    //         ->where('agent_id',$user->id)

    //         ->whereBetween('created_at', [$start_date, $end_date])

    //         ->get();

    //         // dd($agent_assinged); 



    //         foreach($agent_assinged as $agent_assingeds){

    //             if($agent_assingeds!=''){

    //                 $orderDetails[] = DB::connection('mysql')->table('order_details')->where('order_id',$agent_assingeds->OID)->get();

    //                 $order[] = DB::connection('mysql')->table('orders')->where('id',$agent_assingeds->OID)->first();

    //             }else{

    //                 $orderDetails = [];

    //                 $order = [];

    //             }            

    // 	    }

    //         // dd($order);



    //         //totalPrices order_details table

    //         if($orderDetails!=''){

    //             $totalPrices = [];



    //             foreach ($orderDetails as $collection) {

    //                 foreach ($collection as $item) {

    //                     $orderId = $item->order_id;



    //                     // Initialize if not set

    //                     if (!isset($totalPrices[$orderId])) {

    //                         $totalPrices[$orderId] = 0;

    //                     }



    //                     // Add the total price of the current item

    //                     $totalPrices[$orderId] += $item->total_price;

    //                 }

    //             }



    //             // Convert the associative array to a simple array if needed

    //             $result = [];

    //             foreach ($totalPrices as $orderId => $totalPrice) {

    //                 $result[] = [

    //                     // 'order_id' => $orderId,

    //                     // 'total_price' => $totalPrice

    //                     $totalPrice

    //                 ];

    //             }

    //             // dd($result);



    //             foreach($result as $key=>$value){

    //                 $orderTotalPrice[]=$value;

    //             }

    //         }else{

    //             $orderTotalPrice = [];

    //         }



    //         //totalPrices agent_assinged table

    //             $agent_assinged1[] = DB::connection('mysql')

    //             ->table('agent_assinged')

    //             ->where('status','D')

    //             ->where('agent_id',$user->id)

    //             ->whereBetween('created_at', [$start_date, $end_date])

    //             ->get();



    //             if($agent_assinged1!=''){

    //                 foreach ($agent_assinged1 as $key) {

    //                     foreach ($key as $value) {

    //                         $agentTotalPrice[]=[

    //                             // $value->OID,

    //                             $value->totalPrice,

    //                         ];

    //                     }

                        

    //                 }

    //             }else{

    //                 $agentTotalPrice = [];

    //             }



    //         //Profit Calculation 

    //         if($orderTotalPrice!='' &&  $agentTotalPrice!=''){   

    //             $profit = [];

    //             for ($i = 0; $i < count($orderTotalPrice); $i++) {

    //                 $profit[$i][0] =  $agentTotalPrice[$i][0] / $orderTotalPrice[$i][0] *100;

    //             }

    //         }else{

    //             $profit = [];

    //         }



    //         //Unique Order Id

    //         if($order!=''){   

    //             foreach ($order as $key=>$value) {

    //                 // foreach ($key as $value) {

    //                     $unique_order_id[]=[

    //                         // $value->OID,

    //                         $value->unique_order_id,

    //                     ];

    //                 // }

                    

    //             }

    //         }else{

    //             $unique_order_id = [];

    //         }



    //         //Delivery Dates

    //         if($orderDetails!=''){    

    //             $outputDate = [];



    //             foreach ($orderDetails as $collection) {

    //                 foreach ($collection as $item) {

    //                     $orderId = $item->order_id;



    //                     // Initialize if not set

    //                     if (!isset($outputDate[$orderId])) {

    //                         $outputDate[$orderId] = null;

    //                     }



    //                     $outputDate[$orderId] = $item->delivery_date;

    //                 }

    //             }



    //             $dates = [];

    //             foreach ($outputDate as $orderId => $outputDates) {

    //                 $dates[] = [

    //                     $outputDates

    //                 ];

    //             }

    //             // dd($dates);



    //             foreach($dates as $key=>$value){

    //                 $delivery_dates[]=$value;

    //             }

    //         }else{

    //             $delivery_dates = [];

    //         }



    //         //Delivery Cities

    //         if($orderDetails!=''){    

    //             $outputCity = [];



    //             foreach ($orderDetails as $collection) {

    //                 foreach ($collection as $item) {

    //                     $orderId = $item->order_id;



    //                     // Initialize if not set

    //                     if (!isset($outputCity[$orderId])) {

    //                         $outputCity[$orderId] = null;

    //                     }



    //                     $outputCity[$orderId] = $item->delivery_city_name;

    //                 }

    //             }



    //             $cities = [];

    //             foreach ($outputCity as $orderId => $outputCities) {

    //                 $cities[] = [

    //                     $outputCities

    //                 ];

    //             }

    //             // dd($cities);



    //             foreach($cities as $key=>$value){

    //                 $delivery_cities[]=$value;

    //             }

    //         }else{

    //             $delivery_cities = [];

    //         }



    //         $profitReportData[] = [

    //                 'unique_order_id' => $unique_order_id,

    //                 'delivery_date' => $delivery_dates ?? null,

    //                 'delivery_city_name' => $delivery_cities ?? null,

    //                 'totalOrderPrice' => $orderTotalPrice,

    //                 'placementTotal' => $agentTotalPrice,

    //                 'profit' => $profit,

    //                 'agent_name' => $agent->name,

    //                 'status' => 'DELIVERED',

    //         ];



    //         // dd($profitReportData);

    //         // print_r($result);

    //         // return $profitReportData;

    //         // echo "<pre>";

    //         // print_r($profitReportData);

    //         // die;

                

                

    //         return view('agent.GetReport',compact('profitReportData','start_date','end_date','agent'));



    //     }else{

    //         return redirect()->route('agent.login');

    //     }    



    // }



    public function GetReport(Request $request){

        if(Auth::check()){



            $order = [];

            $orderDetails = [];

            $AgentAssign = [];

            $Agent = [];

            $tableItem = [];

            $agent_name = [];

            $totalPrice = 0;

            $placementPrice = 0;



            $profitType = $request['profitType'];

            $start_date = $request['start-date'];

            $end_date = $request['end-date'];

            $user = Auth::guard('AgentLogin')->user();



            $agentAssigned = DB::connection('mysql')->table('agent_assinged')

                            ->where('status','D')

                            ->where('agent_id',$user->id)

                            ->whereBetween('created_at', [$start_date, $end_date])

                            ->get();

            // echo "<pre>";

            // print_r($agentAssigned);

            // die;                



            $uniques = array();

                foreach ($agentAssigned as $agentAssigneds) {

                    $uniques[$agentAssigneds->OID] = $agentAssigneds->OID; 

                }



            // echo "<pre>";

            // print_r($uniques);

            // die;     

                // dd($uniques);

            foreach($uniques as $unique){

                $order[] = DB::connection('mysql')->table('orders')->where('id',$unique)->first();

                $AgentAssign[] = DB::connection('mysql')

                                ->table('agent_assinged')

                                ->where('OID',$unique)

                                ->where('status', 'D')

                                ->get();



            }

            foreach($order as $order_details){

                $orderDetails[] = DB::connection('mysql')->table('order_details')->where('order_id',$order_details->id)->get();

            }

            foreach($AgentAssign as $AgentAssigns){

                foreach($AgentAssigns as $details){

                    $Agent[] = DB::connection('mysql')->table('agents')->where('id',$details->agent_id)->get();

                }

            }  

            $tableItem = [];



            foreach ($order as $orders) {

                $delivery_date = null;

                $delivery_city_name = null;

                $totalPrice = 0;

                $placementPrice = 0;

                $agent_name = [];

            

                foreach ($orderDetails as $orderDetail) {

                    foreach ($orderDetail as $orderDet) {

                        if ($orders->id == $orderDet->order_id) {

                            $delivery_date = $orderDet->delivery_date;

                            $delivery_city_name = $orderDet->delivery_city_name;

                            $totalPrice += $orderDet->total_price;

                        }

                    }

                }

            

                foreach ($AgentAssign as $AgentAssigns) {

                    foreach ($AgentAssigns as $key => $details) {

                        if ($details->OID == $orders->id) {

                            $placementPrice += $details->totalPrice;

                

                            foreach ($Agent as $Agents) {

                                foreach ($Agents as $agented) {

                                    if ($details->agent_id == $agented->id) {

                                        $agent_name[] = $agented->name;

                                    }

                                }

                            }

                        }

                    }

                    

                }

                // foreach ($agent_name as $agent_names) {

                //     $agent_name[$agent_names->name] = $agent_names->name; 

                // }

                $agent_name=array_unique($agent_name);

            

                $profit = ($totalPrice > 0) ? ($placementPrice / $totalPrice) * 100 : 0;

                

                    $tableItem[] = [

                        'uniqueId' => $orders->unique_order_id,

                        'delivery_date' => $delivery_date,

                        'delivery_city_name' => $delivery_city_name,

                        'totalOrderPrice' => $totalPrice,

                        'placementTotal' => $placementPrice,

                        'profit' => $profit,

                        'agent_name' => $agent_name,

                        'status' => "DELIVERED",

                    ];

               

            }

            

            // return $tableItem;

            // echo "<pre>";

            // print_r($tableItem);

            // die;



            return view('agent.GetReport',compact('tableItem','start_date','end_date'));

            

        }else{

            return redirect()->route('agent.login');

        } 

    }





    public function assignOrderView($id,$agentId){

        if(Auth::check()){
            $id=decrypt($id);
            $agentId=decrypt($agentId);
            // $user = Auth::guard('AgentLogin')->user();

            // $agent_assinged = DB::connection('mysql')->table('agent_assinged')->where('agent_order_id',$id)->where('agent_id',$agentId)->first();

            // $agents = DB::connection('mysql')->table('agents')->where('id',$agentId)->first();

            // $product = [];

            // $agent_product_list=[];

            // $product_maped = DB::connection('mysql')->table('assigned_agent_product_map')->where('agent_assinged_id',$agent_assinged->id)->get();

            // $orders = DB::connection('mysql')->table('orders')->where('id',$agent_assinged->OID)->first();

            // $order_details = DB::connection('mysql')->table('order_details')->where('order_id',$orders->id)->get();

            //     foreach($product_maped as $product_mapeds){

            //         if($agent_assinged->id == $product_mapeds->agent_assinged_id){

            //             // $products[] = DB::connection('mysql')->table('products')->where('id',$product_mapeds->product_id)->first();

            //              $agent_product_list[] =  DB::connection('mysql')->table('agent_product_list')->where('id',$product_mapeds->product_id)->first();



            //         }

            //     }

            // // return $agent_product_list;

            // return view('agent.OrderDetails',compact('agent_assinged','product_maped','orders','order_details','user','agent_product_list','agents','agentId'));

            //Updated code

            $user = Auth::guard('AgentLogin')->user();

            $agent_assinged = DB::connection('mysql')->table('agent_assinged')->where('agent_order_id',$id)->where('agent_id',$agentId)->first();

            $agents = DB::connection('mysql')->table('agents')->where('id',$agentId)->first();

            $product = [];

            //$agent_product_list=[];

            $product_maped = DB::connection('mysql')->table('assigned_agent_product_map')->where('agent_assinged_id',$agent_assinged->id)->get();

            $orders = DB::connection('mysql')->table('orders')->where('id',$agent_assinged->OID)->first();

            $order_details = DB::connection('mysql')->table('order_details')->where('order_id',$orders->id)->get();

            $orders_Msg = DB::connection('mysql')->table('order_messages')->where('order_id',$agent_assinged->OID)->first();

            $agent_product_list = DB::connection('mysql')->table('assigned_agent_product_map')
                    ->join('agent_product_list', 'assigned_agent_product_map.product_id', '=', 'agent_product_list.id')
                    ->where('agent_assinged_id',$agent_assinged->id)->get();

            //dd($agent_product_list);


                // foreach($product_maped as $product_mapeds){

                //     if($agent_assinged->id == $product_mapeds->agent_assinged_id){

                //         // $products[] = DB::connection('mysql')->table('products')->where('id',$product_mapeds->product_id)->first();

                //          $agent_product_list[] =  DB::connection('mysql')->table('agent_product_list')->where('id',$product_mapeds->product_id)->first();



                //     }

                // }

                $data=compact('agent_assinged','product_maped','orders','order_details','orders_Msg','user','agent_product_list','agents','agentId');



                $agent_assinged=$data['agent_assinged'];

                $product_maped=$data['product_maped'];

                $orders=$data['orders'];

                $order_details=$data['order_details'];

                $orders_Msg=$data['orders_Msg'];

                $user=$data['user'];

                $agent_product_list=$data['agent_product_list'];

                $agents=$data['agents'];

                $agentId=$data['agentId'];

                // return $data['agent_assinged'];

            // return $agent_product_list;

            // return view('OrderDetails',compact('agent_assinged','product_maped','orders','order_details','user','agent_product_list','agents','agentId'));

                return view('agent.assign_order_view',compact('agent_assinged','product_maped','orders','order_details','orders_Msg','user','agent_product_list','agents','agentId','id'));


            // require_once app_path('Http/Helper.php');

            // $userResponse = OrderDetails1($id,$agentId);

            // return $userResponse;

        }else{

            return redirect()->route('agent.login');

        }   

    }



    public function updateAssignOrderStatus($orderId,$agentID,Request $request){

        if(Auth::check()){
            
            $orderId=decrypt($orderId);
            $agentID=decrypt($agentID);

            $extra = $request['extra'];

            $deliVery = $request['deliveryCharge'];

            $reason = $request['reason'];

            $status = $request['status'];

            $track_no = $request['track_no'];

            

            $rules = ['status' => 'required'];



            if ($status == 'S') {

                $rules['track_no'] = 'required';

            } elseif (in_array($status, ['H', 'CL'])) {

                $rules['reason'] = 'required';

            }



            $messages = [

                'status.required' => 'Please enter the required field for status.',

                'track_no.required' => 'Please provide the tracking number.',

                'reason.required' => 'Please provide a reason.',

            ];



            $validator = Validator::make($request->all(), $rules, $messages);



            if ($validator->fails()) {

                return redirect()->back()->withErrors($validator)->withInput();

            }



            DB::connection('mysql')->table('agent_assinged')->where('agent_order_id',$orderId)->where('agent_id',$agentID)->update([    

                    'extra'=> $extra,

                    'Deliver_charge' => $deliVery,

                    'reason' => $reason,

                    'track_no'=>$track_no,

                    'status' => $status,

                ]);



          

            return back();



            // require_once app_path('Http/Helper.php');

            // $userResponse = UpdateProductStatus1($orderId,$agentID,$request);

            // return $userResponse;

        }else{

            return redirect()->route('agent.login');

        }   

    }



    public function updateStatus(Request $request){

        if(Auth::check()){

            $order_id = $request['order_id'];

            $update_status =$request['update_status'];

            DB::connection('mysql')->table('orderproduct')->where('id',$order_id)->update ([

                "status"=> $request['update_status'],

            ]);

            DB::connection('mysql')->table('assinged')->where('order_id',$order_id)->update ([

                "remark"=>$request['Remark_add'],

            ]);

            DB::connection('mysql')->table('delivery_action')->where('order_id',$order_id)->update ([

                "status"=> $request['update_status'],

            ]);

        

            return 'done';

        }else{

            return redirect()->route('agent.login');

        }   

    }



}

