<?php



namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;

use App\Models\contact1;

use App\Models\contact2;

use App\Models\contact3;

use App\Models\chat;

use App\Models\User;

use App\Models\Agent;

use App\Models\AdminLogin;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Hash;

use Illuminate\Support\Facades\Validator;

use Illuminate\Support\Facades\Session;
use App\Models\Order;
use App\Http\Helper;
use Illuminate\Support\Facades\Http;



class AdminController extends Controller

{

    public function AdminLogin(){

        return view('admin.login');

    }

public function AdminLogedIn(Request $request){

        // dd("hello");

        $credentials = $request->only(['email', 'password']);

        // dd($credentials);



        if (Auth::guard('AdminLogin')->attempt($credentials, $request->filled('remember'))) {

            // return $user = Auth::guard('AdminLogin')->user();

            // dd("success");
        	$request->session()->regenerate();
            $user =  Auth::guard('AdminLogin')->user();

            if($user['access_type'] == "admin" || $user['access_type'] == "super"){

                Session::put('permissions.user_type', Auth::guard('AdminLogin')->user()->user_type);

                // $user_id = session('permissions.user_type');

                // dd($user_id);
                // $request->session()->regenerate();
            	return redirect()->route('admin.home')->with('success', 'Welcome to Admin Dashboard');        

	        }else{

	            // dd("failed");

	            // return back()->withErrors(['email' => 'Invalid credentials'])->withInput($request->only('email'));

	            Auth::guard('AdminLogin')->logout();

                Session::forget('permissions');

                return redirect()->back()->with('error', 'Login Failed'); 

        	}

    	}else{

    		// $request->session()->flash('error', 'Please enter valid login details');

    		// // dd(session('error'));

	     //    return redirect('admin/login');  

    		return redirect()->back()->with('error', 'Please enter valid login details');

    	}

    }

//   public function AdminLogedIn(Request $request)
//     {
//         // Validate request input (optional but recommended)
//         $request->validate([
//             'email' => 'required|email|exists:admins,email',
//             'password' => 'required|min:6|max:15',
//         ], [
//             'email.exists' => 'This email is not registered in our system.'
//         ]);
//         $credentials = $request->only(['email', 'password']);
//         if (Auth::guard('AdminLogin')->attempt($credentials)) {
//             $request->session()->regenerate();

//             $user = Auth::guard('AdminLogin')->user();

//             if ($user->access_type === 'admin' || $user->access_type === 'super') {
//                 session([
//                     'admin_session.user_id' => $user->id,
//                     'admin_session.user_type' => $user->user_type,
//                 ]);
//                 return $all_sessions = session()->all();
//                 return redirect()->route('admin.home')->with('success', 'Welcome Admin');
//             } else {
//                 Auth::guard('AdminLogin')->logout();
//                 session()->forget('admin_session');

//                 return redirect()->back()->with('error', 'Access not permitted.');
//             }
//         }

//         return redirect()->back()->with('error', 'Invalid credentials.');
//     }




    // public function logout(Request $request)

    // {

    //     Auth::guard('AdminLogin')->logout();
    //     session()->forget('admin_session');
    //     $request->session()->invalidate();
    //     $request->session()->regenerateToken();
    //     return redirect()->route('admin.login');

    // }
     public function logout()

    {

        Auth::guard('AdminLogin')->logout();

        return redirect()->route('admin.login');

    }

    public function home(Request $request) {
        $adminId = session('admin_login_id');
        $admin = \App\Models\AdminLogin::find($adminId);

        $todayAllorder = $monthAllorder = $monthCancelorder = $pendingAllorder = $holdAllorder = 0;
        $monthTotalOrderAmt = $todayTotalOrderAmt = $lastMonthTotalOrderAmt = $lastMonthFullTotalOrderAmt = 0;

        date_default_timezone_set('Asia/Kolkata');
        $today = date("Y-m-d");
        $from_date = date("Y-m-01");
        $to_date = date("Y-m-31");

        // Today's completed orders
        $todayAllorder = Order::whereDate('purchase_date', $today)->where('payment_status', 'C')->get();
        $todayTotalOrderAmt = $todayAllorder->sum('final_ordered_amount');

        // This month's completed orders
        $monthAllorder = Order::whereBetween('purchase_date', [$from_date, $to_date])->where('payment_status', 'C')->get();
        $monthTotalOrderAmt = $monthAllorder->sum('final_ordered_amount');

        // Pending orders
        $pendingAllorder = Order::where([
            'payment_status' => 'C',
            'order_delivery_status' => 'P',
            'type' => 'order'
        ])->get();

        // Cancelled orders this month
        $monthCancelorder = Order::whereBetween('purchase_date', [$from_date, $to_date])
            ->where([
                'payment_status' => 'C',
                'order_delivery_status' => 'CL',
                'type' => 'order'
            ])->get();

        // City-wise grouping
        $citywiseTodayOrders = Order::select('sitename')->whereNotNull('sitename')->groupBy('sitename')->get();

        $tableItems = [];

        foreach ($citywiseTodayOrders as $city) {
            $sitename = $city->sitename;

            $tableItems[] = [
                'sitename' => $sitename,
                'todayOrders' => Order::whereDate('purchase_date', $today)
                    ->where('sitename', $sitename)
                    ->where('payment_status', 'C')
                    ->count(),

                'todayAmt' => Order::whereDate('purchase_date', $today)
                    ->where('sitename', $sitename)
                    ->where('payment_status', 'C')
                    ->sum('final_ordered_amount'),

                'ThisMonthOrders' => Order::whereBetween('purchase_date', [$from_date, $to_date])
                    ->where('sitename', $sitename)
                    ->where('payment_status', 'C')
                    ->count(),

                'ThisMonthAmt' => Order::whereBetween('purchase_date', [$from_date, $to_date])
                    ->where('sitename', $sitename)
                    ->where('payment_status', 'C')
                    ->sum('final_ordered_amount'),

                'PendingOrders' => Order::where('sitename', $sitename)
                    ->where([
                        'payment_status' => 'C',
                        'order_delivery_status' => 'P',
                        'type' => 'order'
                    ])->count(),

                'CancelOrder' => Order::whereBetween('purchase_date', [$from_date, $to_date])
                    ->where('sitename', $sitename)
                    ->where([
                        'payment_status' => 'C',
                        'order_delivery_status' => 'CL',
                        'type' => 'order'
                    ])->count(),
            ];
        }

        return view('admin.home', compact('admin','monthAllorder','todayAllorder','pendingAllorder','monthCancelorder','todayTotalOrderAmt','monthTotalOrderAmt','tableItems'));
    }

  
    public function orders(Request $request){

    	if(Auth::check()){
	        $order = DB::connection('mysql')->table('orders')->where('payment_status','C')->where('type','order')->get();
	        $order_details = DB::connection('mysql')->table('order_details')->get();
	        $products = DB::connection('mysql')->table('products')->get();
	        $user = DB::connection('mysql')->table('users')->get();
	        $agent_assinged = DB::connection('mysql')->table('agent_assinged')->get();
	        $agent = DB::connection('mysql')->table('agents')->get();

            $todayAllorder = $monthAllorder = $monthCancelorder = $pendingAllorder = $holdAllorder = 0;
            $monthTotalOrderAmt = $todayTotalOrderAmt = $lastMonthTotalOrderAmt = $lastMonthFullTotalOrderAmt = 0;

            date_default_timezone_set('Asia/Kolkata');
            $today = date("Y-m-d");
            $from_date = date("Y-m-1");
            $to_date = date("Y-m-31");

            return $todayAllorder = Order::whereDate('purchase_date', '=',$today)->where(['payment_status'=>'C'])->get();

            foreach($todayAllorder as $data){
                $todayTotalOrderAmt = $todayTotalOrderAmt + $data->final_ordered_amount;
            }

            $monthAllorder = Order::whereDate('purchase_date', '>=',$from_date)->whereDate('purchase_date', '<=',$to_date)->where(['payment_status'=>'C'])->get();

            foreach($monthAllorder as $data){
                $monthTotalOrderAmt = $monthTotalOrderAmt + $data->final_ordered_amount;
            }

            $pendingAllorder = Order::where(['payment_status'=>'C', 'order_delivery_status' => 'P', 'type' => 'order'])->get();

            $monthCancelorder = Order::whereDate('purchase_date', '>=',$from_date)->whereDate('purchase_date', '<=',$to_date)->where(['payment_status'=>'C', 'order_delivery_status' => 'CL', 'type' => 'order'])->get();

	        return view('admin.order',compact('order','order_details','products','user','agent_assinged','agent'));

	    }else{

            return redirect()->route('admin.login');

        }

    }



    public function viewProduct($orderId){

    	if(Auth::check()){

	        $order = DB::connection('mysql')->table('orders')->where('id',$orderId)->first();

	        $order_details = DB::connection('mysql')->table('order_details')->where('order_id',$orderId)->get();

	        $product = DB::connection('mysql')->table('products')->get();

	        $agents = DB::connection('mysql')->table('agents')->get();

            $assinged = DB::connection('mysql')->table('agent_assinged')->where('OID', $orderId)->get();	    

            $assinedCount = DB::connection('mysql')->table('agent_assinged')->where('OID', $orderId)->where('isConfirmCl', 0)->get();

            $agent_product_list =  DB::connection('mysql')->table('agent_product_list')->get();

            $user = DB::connection('mysql')->table('users')->where('id',$order->user_id)->first();

            if($user){
            	$order_messages = DB::connection('mysql')->table('order_messages')->where(['user_id' => $user->id, 'order_id'=>$order->id])->first();
            }else{
            	$order_messages = '';
            }

            // if($user){
	        //     $user_billing_address = DB::connection('mysql')->table('user_addresses')->where('user_id',$user->id)->where('address_type','BA')->first();
	        //     $user_delivery_address = DB::connection('mysql')->table('user_addresses')->where(['user_id' => $user->id, 'address_type' => 'DA', 'city_name'=>$order->delivery_city])->first();
	        //     $order_messages = DB::connection('mysql')->table('order_messages')->where(['user_id' => $user->id, 'order_id'=>$order->id])->first();
	        // }else{
	        // 	$user_billing_address ='';
	        // 	$user_delivery_address ='';
	        // 	$order_messages ='';
	        // 	$user='';
	        // }


	        $agent_details_product = [];

	        $groupByProduct = [];

	            foreach($order_details as $order_detail){

	                foreach($product as $products){

	                    if($order_detail->product_id == $products->id){

	                        $groupByProduct[] = $products;

	                    }

	                }

	            }



	        $assigned_agent_product_map = DB::connection('mysql')->table('assigned_agent_product_map')->get();

	        $groupByProductCollection = collect($groupByProduct);

	        $groupedByDeliveryType = $groupByProductCollection->groupBy('product_delivery_type');

	        // return $groupedByDeliveryType['C'];

	        $agentasGroupBy = DB::connection('mysql')

	            ->table('agent_assinged')

	            ->select('agent_order_id', 'status','track_no', DB::raw('COUNT(*) as total'))

	            ->where('OID',$orderId)

	            ->groupBy('agent_order_id', 'status','track_no')

	            ->get();



            $disable = count($assinedCount); 



            // dd($disable);

	        

	        //Filter

	        $agentsAfterCancel = [];

	        $agent_ids = [];

	        $assingedCancel = DB::connection('mysql')->table('agent_assinged')

	        				  ->where('OID', $orderId)

	        				  ->whereIn('status', ['P','PC','CL','H','D','S'])

	        				  ->get();

	        // return $assingedCancel;



	        foreach($assingedCancel as $assingedCancels){

	        	

	        	$agent_ids[]=$assingedCancels->agent_id;

	        }

	        // return $agent_ids;			  

	        

        	$agentsAfterCancel[] = DB::connection('mysql')->table('agents')

        						   ->whereNotIn('id',$agent_ids)

        						   ->get();

	         

	        return view("admin.view_product",compact('order','order_details','product','agents','assinged','groupedByDeliveryType','assigned_agent_product_map','disable','agentasGroupBy','agent_product_list','agentsAfterCancel','user','order_messages'));

	    }else{

            return redirect()->route('admin.login');

        }

    }



    public function saveProduct(Request $request){

    	if(Auth::check()){

    		// dd($request->all());

	        $agents = $request['agents'];

	        $OrderID = $request['OrderID'];

	        $OrderOriginalID = $request['OrderOriginalID'];



	        $counter = 0; 

	        foreach($agents as $agent) {

	        	if($agent['agent_id'] != null){

		            $suffix = chr(65 + $counter); 



		            $agent_assignedId = DB::connection('mysql')->table('agent_assinged')->insertGetId([

		                'agent_order_id' => $OrderID . '-' . $suffix, 

		                'OID' => $OrderOriginalID,

		                'agent_id' => $agent['agent_id'],

		                'totalPrice' => $agent['total_price'],

		                'status' => 'P',

		                'isConfirmCl' => 0,

		                'created_at' => now(),

		                'updated_at' => now(),

		            ]);



		            foreach($agent as $key => $productData) {

		                if (is_array($productData) && isset($productData['products'])) {

		                    foreach($productData['products'] as $index => $productId) {

		                    	if($productId != null && $productData['product_prices'][$index] != null && $productData['product_qty'][$index] != null){

			                        DB::connection('mysql')->table('assigned_agent_product_map')->insert([

			                            'agent_assinged_id' => $agent_assignedId,

			                            'product_id' => $productId,

			                            'price' => $productData['product_prices'][$index],

			                            'qty' => $productData['product_qty'][$index],

			                            'created_at' => now(),

			                            'updated_at' => now(),

			                        ]);

			                    }

		                    }

		                }

		            }



		            $counter++; 

		        }

	        }



	        return back();

	    }else{

            return redirect()->route('admin.login');

        }    



    }



    public function ProductByAgent(Request $request){

    	if(Auth::check()){

	        $agent_id = $request['agent_id'];

	        $products = DB::connection('mysql')->table('agent_product_list')->where('agent_id',$agent_id)->get();

	        return $products;

	    }else{

            return redirect()->route('admin.login');

        }   

    }



    public function getAgentId(Request $request){

    	if(Auth::check()){

    		// $agent_id = $request['agent_id'];

	        $agentsArray = $request['agentsArray'];

            $agentIndex = $request['agentIndex'];



	        // dd($agentsArray);



	        if($agentsArray == null){



	        	$agents = DB::connection('mysql')->table('agents')

	        		      ->get();

    		}else{



		        // $products = DB::connection('mysql')->table('agent_product_list')->where('agent_id',$agent_id)->get();

		        $agents = DB::connection('mysql')->table('agents')

		        		  ->whereNotIn('id',$agentsArray)

		        		  ->get(); 

		        // dd($agents);		  

		        // return $products;

		    } 

		       		  

	        $response = [

		        // 'products' => $products

		        'agents' => $agents,

                'agentIndex'=>$agentIndex,

		    ];



    		return response()->json($response);	

	    }else{

            return redirect()->route('admin.login');

        }   

    }



    public function GetPriceByProduct(Request $request){

    	if(Auth::check()){

	        $selectProduct = $request['product_id'];

	        $price = DB::connection('mysql')->table('agent_product_list')->where('id',$selectProduct)->first();

	        return $price;

	    }else{

            return redirect()->route('admin.login');

        }   

    }



    public function GetDeliveryType(Request $request){

    	if(Auth::check()){

	        $productqty = $request['productqty'];

	        $total = 0;

	        $Dtype = $request['Dtype'];

	        $agent_id = $request['agent_id'];

	        $productPrices = $request['productPrices'];

	        $agent_delivery_charge = DB::connection('mysql')

	        ->table('agent_delivery_charge')

	        ->where('agent_id', $agent_id)

	        ->first();

	        $i = 0;

	        foreach($productPrices as $productPrice){

	            $total+=$productPrice * $productqty[$i];

	            $i++;

	        }



	        $data = compact('agent_delivery_charge','Dtype','total','productqty','productqty');

	        return $data;

	    }else{

            return redirect()->route('admin.login');

        }   



    }



    public function getOrderID(Request $request){

    	if(Auth::check()){

	        $orderId =  $request['orderId'];

	        $reassignAggent = $request['reassignAggent'];

	        $assigned = DB::connection('mysql')->table('agent_assinged')->where('id',$orderId)->first();

	        return $assigned;

	    }else{

            return redirect()->route('admin.login');

        }    

    }



    public function ReAssignProduct(Request $request){

    	if(Auth::check()){

    		// dd($request->all());

	        $OrderID = $request['agent_order_id'];

	        $agents = $request['agents'];

	        $singleAgentAssinged = DB::connection('mysql')->table('agent_assinged')->where('agent_order_id',$OrderID)->first();

	        $agent_assinged = DB::connection('mysql')->table('agent_assinged')->where('agent_order_id',$OrderID)->get();

	        $orders = DB::connection('mysql')->table('orders')->where('id',$singleAgentAssinged->OID)->first();

	        $reassignascii = 0;

	        // return $request->all();

	        DB::connection('mysql')->table('agent_assinged')->where('agent_order_id',$OrderID)->update([

	            'isConfirmCl'=>1,

	        ]);

	        foreach($agent_assinged as $agent_assingeds){

	            $reassignascii++;

	        }

	        $counter = 0; 

	        foreach($agents as $agent) {

	            $AgentOrderId = $singleAgentAssinged->agent_order_id;

	            $lastChar = substr($AgentOrderId, -1); 

	            $AgentOrderId = rtrim($AgentOrderId, '-'.$lastChar);

	            $CharInt = ord($lastChar); 

	            $suffix = chr($CharInt + $reassignascii); 





	            $agent_assignedId = DB::connection('mysql')->table('agent_assinged')->insertGetId([

	                'agent_order_id' => $AgentOrderId . '-' . $suffix, 

	                'OID' => $orders->id,

	                'agent_id' => $agent['agent_id'],

	                'totalPrice' => $agent['total_price'],

	                'status' => 'P',

	                'isConfirmCl' => 0,

	                'created_at' => now(),

	                'updated_at' => now(),

	            ]);



	            foreach($agent as $key => $productData) {

	                if (is_array($productData) && isset($productData['products'])) {

	                    foreach($productData['products'] as $index => $productId) {

	                        DB::connection('mysql')->table('assigned_agent_product_map')->insert([

	                            'agent_assinged_id' => $agent_assignedId,

	                            'product_id' => $productId,

	                            'price' => $productData['product_prices'][$index],

	                            'qty' => $productData['product_qty'][$index],

	                            'created_at' => now(),

	                            'updated_at' => now(),

	                        ]);

	                    }

	                }

	            }



	            $counter++; 

	        }



	        return back();



	    }else{

            return redirect()->route('admin.login');

        }    



    }



    public function getReAssignPrice(Request $request){

    	if(Auth::check()){

	        $totalPrice = 0;

	        $OrderId = $request['OrderId'];

	        $reassignAggent = $request['reassignAggent'];

	        $price = DB::connection('mysql')->table('agent_assinged')->where('id',$OrderId)->first();

	        return $price->totalPrice;

	    }else{

            return redirect()->route('admin.login');

        }    

    }



    public function Reassign(Request $request){

    	if(Auth::check()){

    		// dd($request->all());

	        $counter = 0; 

	        $agent_product_list = [];

	        $OrderId=$request['OrderId'];

	        $reassignAggent=$request['reassignAggent'];

	        $re_price=$request['re_price'];

	        $assigned = DB::connection('mysql')->table('agent_assinged')->where('id',$OrderId)->first();

	        $order =  DB::connection('mysql')->table('orders')->where('id',$assigned->OID)->first();

	        $product_maped = DB::connection('mysql')->table('assigned_agent_product_map')->where('agent_assinged_id',$assigned->id)->get();

	        foreach($product_maped as $product_mapeds){

	            $agent_product_list[] = DB::connection('mysql')->table('agent_product_list')->where('id',$product_mapeds->product_id)->first();

	        }



	        DB::connection('mysql')->table('agent_assinged')->where('id',$assigned->id)->update([

	            'isConfirmCl'=>1,

	        ]);

	        $AgentOrderId = $assigned->agent_order_id;

	        $lastChar = substr($AgentOrderId, -1); 

	        $CharInt = ord($lastChar); 

	        $suffix = chr($CharInt + 5); 

	            $assinedId = DB::connection('mysql')->table('agent_assinged')->insertGetId([

	            'agent_order_id'=>  $order->unique_order_id.'-'.$suffix,

	            'OID'=>$order->id,  

	            'agent_id'=>$reassignAggent,    

	            'totalPrice'=>$re_price,    

	            'status'=>'P',

	            'isConfirmCl'=>0,

	            'created_at'=>date('Y-m-d H:i:s'),

	            'updated_at'=>date('Y-m-d H:i:s'),

	        ]);

	        foreach($product_maped as $product_mapeds){

	            $agent_product_list = DB::connection('mysql')->table('agent_product_list')->where('agent_id',$assigned->agent_id)->where('id',$product_mapeds->product_id)->first();





	            DB::connection('mysql')->table('assigned_agent_product_map')->insert([

	                'agent_assinged_id' =>$assinedId,

	                'product_id'=>  $product_mapeds->product_id,

	                'qty' =>$product_mapeds->qty,

	                'price' => $agent_product_list->price,

	                'created_at'=>date('Y-m-d H:i:s'),

	                'updated_at'=>date('Y-m-d H:i:s'),

	            ]);

	        }

	        return 'done';



	    }else{

            return redirect()->route('admin.login');

        }   

    }



    public function mailStatus(Request $request){

    	if(Auth::check()){

	        $mail_status = $request['mail_status'];

	        $OrderID = $request['OrderID'];



	        DB::connection('mysql')->table('orders')->where('id',$OrderID)->update([

	            'order_delivery_status'=>  $mail_status = $request['mail_status'],

	        ]);

	        return "done";

	    }else{

            return redirect()->route('admin.login');

        }   

    }



    public function search(Request $request){

    	if(Auth::check()){

	        // $order = DB::connection('mysql')->table('orders')

	        // ->where('payment_status', 'C')

	        // ->where('type', 'order')

	        // ->whereBetween('created_at', [$request['fromDate'], $request['toDate']])

	        // ->where('order_delivery_status', $request['status'])

	        // ->get();

	        // $order_details = DB::connection('mysql')->table('order_details')->get();

	        // $products = DB::connection('mysql')->table('products')->get();

	        // return view('admin.search',compact('order','order_details','products'));

    		$agent_assigned = DB::connection('mysql')

					          ->table('agent_assinged')

					          ->whereBetween('created_at', [$request['fromDate'], $request['toDate']])

					          ->where('status', $request['status'])

					          ->get();



	        $products = [];

	        $agent_product_list=[];

	        $assined = DB::connection('mysql')

				       ->table('agent_assinged')

				       ->whereBetween('created_at', [$request['fromDate'], $request['toDate']])

					   ->where('status', $request['status'])

				       ->get();



	        $product_maped = DB::connection('mysql')->table('assigned_agent_product_map')->get();



	        foreach($product_maped as $product_mapeds){

	            $products[] = DB::connection('mysql')->table('products')->where('id',$product_mapeds->product_id)->first();

	            $agent_product_list[] = DB::connection('mysql')->table('agent_product_list')->where('id',$product_mapeds->product_id)->first();



	        }

	        $agents = DB::connection('mysql')->table('agents')->get();

	        $order_details = DB::connection('mysql')->table('order_details')->get();

	        $orders = DB::connection('mysql')->table('orders')->get();

	        return view('admin.main', compact('agent_assigned','products','order_details','orders','agents','assined','product_maped','agent_product_list'));



	    }else{

            return redirect()->route('admin.login');

        }   

    }



    public function main(){

        if(Auth::check()){

	        $agent_assigned = DB::connection('mysql')

	        ->table('agent_assinged')

	        ->get();



	        $products = [];

	        $agent_product_list=[];

	        $assined = DB::connection('mysql')

	        ->table('agent_assinged')

	        ->get();

	        $product_maped = DB::connection('mysql')->table('assigned_agent_product_map')->get();



	        foreach($product_maped as $product_mapeds){

	            $products[] = DB::connection('mysql')->table('products')->where('id',$product_mapeds->product_id)->first();

	            $agent_product_list[] = DB::connection('mysql')->table('agent_product_list')->where('id',$product_mapeds->product_id)->first();



	        }

	        $agents = DB::connection('mysql')->table('agents')->get();

	        $order_details = DB::connection('mysql')->table('order_details')->get();

	        $orders = DB::connection('mysql')->table('orders')->get();

	        return view('admin.main', compact('agent_assigned','products','order_details','orders','agents','assined','product_maped','agent_product_list'));



	    }else{

            return redirect()->route('admin.login');

        }       

    }



    public function orderDetails($id,$agentId){

    	if(Auth::check()){

	        require_once app_path('Http/Helper.php');

	        $userResponse = OrderDetails1($id,$agentId);

	        return $userResponse;

	    }else{

            return redirect()->route('admin.login');

        }   

    }



    public function UpdateProductStatus($orderId,$agentID,Request $request){

    	if(Auth::check()){

	        // $request = Request $request;

	        require_once app_path('Http/Helper.php');

	        $userResponse = UpdateProductStatus1($orderId,$agentID,$request);

	        return $userResponse;

	    }else{

            return redirect()->route('admin.login');

        }    

    }



    public function report(Request $request)

    {

    	if(Auth::check()){

	        $agents = DB::connection('mysql')->table('agents')->get();

	        $data = "";



	        return view('admin.report', compact('agents', 'data'));

	    }else{

            return redirect()->route('admin.login');

        }   

    }



    public function reportTable(Request $request)

    {   

    	if(Auth::check()){

	        $agent_product_list = [];

	        $assigned_agent_product_map = [];

	        $agent_product_list = [];



	        $agentId = $request['agent'];

	        $startDate = $request['start-date'];

	        $endDate = $request['end-date'];



	        $agent_assinged = DB::connection('mysql')

	            ->table('agent_assinged')

	            ->where('agent_id', $agentId)

	            ->whereBetween('created_at', [$startDate, $endDate])

	            ->get();



	        // echo "<pre>";

	        // print_r($agent_assinged);

	        // die;    

	        // dd($agent_assinged);

	            

	        $agents = DB::connection('mysql')->table('agents')->where('id', $agentId)->first();

	        // $agent_product_list[] =  DB::connection('mysql')->table('agent_product_list')->where('agent_id', $agentId)->get();

	        // dd($agent_product_list);

	        // foreach ($agent_assinged as $agent_assingeds) {

	        //     $assigned_agent_product_map[] = DB::connection('mysql')->table('assigned_agent_product_map')->where('agent_assinged_id', $agent_assingeds->id)->get();

	        // }

	        // dd($assigned_agent_product_map);

	        $assigned_agent_product_map = DB::connection('mysql')->table('assigned_agent_product_map')->get();



	        foreach($assigned_agent_product_map as $product_mapeds) {

	            $agent_product_list[] = DB::connection('mysql')->table('agent_product_list')

	                                    ->where('id', $product_mapeds->product_id)

	                                    ->first();

	        }

	        // dd($agent_product_list);



	        // $data = compact('agent_assinged','agents','agent_product_list','assigned_agent_product_map');

	        return view('admin.reportSearch', compact('agent_assinged', 'agents', 'agent_product_list', 'assigned_agent_product_map'));

	    }else{

            return redirect()->route('admin.login');

        }  

    }



    public function ProfitReport()

    {

    	if(Auth::check()){

        	return view('admin.ProfitReport');

        }else{

            return redirect()->route('admin.login');

        } 	

    }



    // public function ProfitReportSearch(Request $request)

    // {

    //     $orderDetails = [];

    //     $order = [];

    //     $orderTotalPrice = [];

    //     $agentTotalPrice = [];

    //     $profit = [];

    //     $unique_order_id = [];

    //     $delivery_dates = [];

    //     $delivery_cities = [];

    //     $profitReportData = [];

    //     // $agent = [];

    //     $getAgentName = [];



    //     $profitType = $request['profitType'];

    //     $start_date = $request['start-date'];

    //     $end_date = $request['end-date'];



    //     $agent = DB::connection('mysql')->table('agents')->get();



    //     // if($agent!=''){   

    //     //     foreach ($agent as $key) {

    //     //         foreach ($key as $value) {

    //     //             $agent_name[]=[

    //     //                 // $value->OID,

    //     //                 $value->name,

    //     //             ];

    //     //         }

                

    //     //     }

    //     // }else{

    //     //     $agent_name = [];

    //     // }



        



    //     $agent_assinged = DB::connection('mysql')

    //                     ->table('agent_assinged')

    //                     ->where('status','D')

    //                     ->whereBetween('created_at', [$start_date, $end_date])

    //                     ->get();

    //     // dd($agent_assinged); 



    //     if($agent_assinged!=''){                

    //         foreach($agent_assinged as $agent_assingeds){

    //             $orderDetails[] = DB::connection('mysql')->table('order_details')->where('order_id',$agent_assingeds->OID)->get();

    //             $order[] = DB::connection('mysql')->table('orders')->where('id',$agent_assingeds->OID)->get();



    //             foreach($order as $key){

    //                 foreach($key as $value){

    //                     if($value->id == $agent_assingeds->OID){

    //                         foreach($agent as $agents){

    //                             if($agent_assingeds->agent_id == $agents->id){

    //                                 $getAgentName[$agent_assingeds->OID][] = [

    //                                     $agents->name,

    //                                 ];



    //                             }

    //                         }

    //                     }

    //                 }

    //             }

    //         }            

    //     }else{

    //         $orderDetails = [];

    //         $order = [];

    //         $getAgentName = [];

    //     }



    //     // echo "<pre>";

    //     // print_r($getAgentName);

    //     // die;



    //     $agent_name = [];



    //     if($getAgentName!=''){

    //         foreach ($getAgentName as $key => $locations) {

    //             // Flatten the sub-arrays and remove duplicates

    //             $unique_locations = array_unique(array_map(function($location) {

    //                 return $location[0];

    //             }, $locations));



    //             $agent_name[$key] = $unique_locations;

    //         }

    //     }else{

    //         $agent_name = [];

    //     }

    //     // foreach($agent_name as $key=>$value){

    //     //     $agent_name1[] = [

    //     //         $value,

    //     //     ];

    //     // }



    //     // echo "<pre>";

    //     // print_r($agent_name);

    //     // die;



    //     // // Group agent_ids by OID

    //     // $agentIdsByOID = $agent_assinged->groupBy('OID')->map(function ($items) {

    //     //     return $items->pluck('agent_id')->all();

    //     // })->all();



    //     // echo "<pre>";

    //     // print_r($agentIdsByOID);

    //     // die;



    //     // Initialize an empty array to store unique orders

    //     $uniqueOrders = [];



    //     if($order!=''){

    //         // Iterate through the array

    //         foreach ($order as $collection) {

    //             foreach ($collection as $item) {

    //                 // Use the id as the unique key

    //                 $uniqueOrders[$item->id] = $item;

    //             }

    //         }



    //         // Convert the unique orders array back to the desired format

    //         $uniqueOrders = array_values($uniqueOrders);



    //         //Unique Order Id

               

    //             foreach ($uniqueOrders as $key=>$value) {

    //                 // foreach ($key as $value) {

    //                     $unique_order_id[]=[

    //                         // $value->OID,

    //                         $value->unique_order_id,

    //                     ];

    //                 // }

    //             }

    //     }else{

    //         $unique_order_id = [];

    //     }



    //     // echo "<pre>";

    //     // print_r($unique_order_id);

    //     // die;



    //     //totalPrices order_details table

    //     $totals = [];



    //     if($orderDetails!=''){

    //         foreach ($orderDetails as $collection) {

    //             foreach ($collection as $item) {

    //                 if (!isset($totals[$item->order_id])) {

    //                     $totals[$item->order_id] = 0;

    //                 }

    //                 $totals[$item->order_id] += $item->total_price;

    //             }

    //         }



    //         // Convert the associative array to a simple array if needed

    //         $result = [];

    //         foreach ($totals as $orderId => $totalPrice) {

    //             $result[] = [

    //                 $totalPrice

    //             ];

    //         }

    //         // dd($result);



    //         foreach($result as $key=>$value){

    //             $orderTotalPrice[]=$value;

    //         }

    //     }else{

    //         $orderTotalPrice = [];

    //     }



    //     // echo "<pre>";

    //     // print_r($orderTotalPrice);

    //     // die;



    //     //totalPrices agent_assinged table

    //         $agent_assinged1[] = DB::connection('mysql')

    //         ->table('agent_assinged')

    //         ->where('status','D')

    //         ->whereBetween('created_at', [$start_date, $end_date])

    //         ->get();



    //         $totalPrices = [];



    //         if($agent_assinged1!=''){

    //             foreach ($agent_assinged1 as $collection) {

    //                 foreach ($collection as $item) {

    //                     $orderId = $item->OID;



    //                     // Initialize if not set

    //                     if (!isset($totalPrices[$orderId])) {

    //                         $totalPrices[$orderId] = 0;

    //                     }



    //                     // Add the total price of the current item

    //                     $totalPrices[$orderId] += $item->totalPrice;

    //                 }

    //             }



    //             // Convert the associative array to a simple array if needed

    //             $result = [];

    //             foreach ($totalPrices as $orderId => $totalPrice) {

    //                 $result[] = [

    //                     $totalPrice

    //                 ];

    //             }

    //             // dd($result);

    //                 foreach($result as $key=>$value){

    //                     $agentTotalPrice[]=$value;

    //                 }

    //         }else{

    //             $agentTotalPrice = [];

    //         }





    //     // echo "<pre>";

    //     // print_r($agentTotalPrice);

    //     // die;



    //         // if($agent_assinged1!=''){

    //         //     foreach ($agent_assinged1 as $key) {

    //         //         foreach ($key as $value) {

    //         //             $agentTotalPrice[]=[

    //         //                 // $value->OID,

    //         //                 $value->totalPrice,

    //         //             ];

    //         //         }

                    

    //         //     }

    //         // }else{

    //         //     $agentTotalPrice = [];

    //         // }



    //     //Profit Calculation 

    //     if($orderTotalPrice!='' &&  $agentTotalPrice!=''){   

    //         $profit = [];

    //         for ($i = 0; $i < count($orderTotalPrice); $i++) {

    //             $profit[$i][0] =  $agentTotalPrice[$i][0] / $orderTotalPrice[$i][0] *100;

    //         }

    //     }else{

    //         $profit = [];

    //     }





    //     //Delivery Dates

    //     if($orderDetails!=''){    

    //         $outputDate = [];



    //         foreach ($orderDetails as $collection) {

    //             foreach ($collection as $item) {

    //                 $orderId = $item->order_id;



    //                 // Initialize if not set

    //                 if (!isset($outputDate[$orderId])) {

    //                     $outputDate[$orderId] = null;

    //                 }



    //                 $outputDate[$orderId] = $item->delivery_date;

    //             }

    //         }



    //         $dates = [];

    //         foreach ($outputDate as $orderId => $outputDates) {

    //             $dates[] = [

    //                 $outputDates

    //             ];

    //         }

    //         // dd($dates);



    //         foreach($dates as $key=>$value){

    //             $delivery_dates[]=$value;

    //         }

    //     }else{

    //         $delivery_dates = [];

    //     }



    //     //Delivery Cities

    //     if($orderDetails!=''){    

    //         $outputCity = [];



    //         foreach ($orderDetails as $collection) {

    //             foreach ($collection as $item) {

    //                 $orderId = $item->order_id;



    //                 // Initialize if not set

    //                 if (!isset($outputCity[$orderId])) {

    //                     $outputCity[$orderId] = null;

    //                 }



    //                 $outputCity[$orderId] = $item->delivery_city_name;

    //             }

    //         }



    //         $cities = [];

    //         foreach ($outputCity as $orderId => $outputCities) {

    //             $cities[] = [

    //                 $outputCities

    //             ];

    //         }

    //         // dd($cities);



    //         foreach($cities as $key=>$value){

    //             $delivery_cities[]=$value;

    //         }

    //     }else{

    //         $delivery_cities = [];

    //     }



    //     if (($profitType == '20' && $profit >= 20 && $profit <= 30) ||

    //             ($profitType == '31' && $profit >= 31 && $profit <= 40) ||

    //             ($profitType == '41' && $profit >= 41 && $profit <= 50) ||

    //             ($profitType == '51' && $profit >= 51 && $profit <= 60) ||

    //             ($profitType == '60' && $profit >= 60) ||

    //             ($profitType == "ALL" && $profit > 0) ||

    //             !$profitType

    //         ) {



    //         $profitReportData[] = [

    //                 'unique_order_id' => $unique_order_id,

    //                 'delivery_date' => $delivery_dates ?? null,

    //                 'delivery_city_name' => $delivery_cities ?? null,

    //                 'totalOrderPrice' => $orderTotalPrice,

    //                 'placementTotal' => $agentTotalPrice,

    //                 'profit' => $profit,

    //                 'agent_name' => $agent_name,

    //                 'status' => 'DELIVERED',

    //         ];

    //     }



    //     // dd($profitReportData);

    //     // print_r($result);

    //     // return $profitReportData;

    //     // echo "<pre>";

    //     // print_r($profitReportData);

    //     // die;

            

    //     // return $profitReportData;

    //     return view('admin.ProfitReportSearch',compact('profitReportData','start_date','end_date','agent'));

    // }

    public function ProfitReportSearch(Request $request){

        if(Auth::check()){

        	// return $request->all();

            // $user = Auth::guard('AdminLogin')->user();

            // return $user->name;

    

            $order = [];

            $orderDetails = [];

            $AgentAssign = [];

            $Agent = [];

            $tableItem = [];

            $agent_name = [];

            $totalPrice = 0;

            $placementPrice = 0;



            $profitType = $request['profitType'];

            $start_date = $request['start-date'];

            $end_date = $request['end-date'];



            $agentAssigned = DB::connection('mysql')->table('agent_assinged')

                            ->where('status','D')

                            ->whereBetween('created_at', [$start_date, $end_date])

                            ->get();

            // echo "<pre>";

            // print_r($agentAssigned);

            // die;                



            $uniques = array();

                foreach ($agentAssigned as $agentAssigneds) {

                    $uniques[$agentAssigneds->OID] = $agentAssigneds->OID; 

                }



            // echo "<pre>";

            // print_r($uniques);

            // die;     

                // dd($uniques);

            foreach($uniques as $unique){

                $order[] = DB::connection('mysql')->table('orders')->where('id',$unique)->first();

                $AgentAssign[] = DB::connection('mysql')

                				->table('agent_assinged')

                				->where('OID',$unique)

                				->where('status', 'D')

                				->get();



            }

            foreach($order as $order_details){

                $orderDetails[] = DB::connection('mysql')->table('order_details')->where('order_id',$order_details->id)->get();

            }

            foreach($AgentAssign as $AgentAssigns){

                foreach($AgentAssigns as $details){

                    $Agent[] = DB::connection('mysql')->table('agents')->where('id',$details->agent_id)->get();

                }

            }  

            $tableItem = [];



            foreach ($order as $orders) {

                $delivery_date = null;

                $delivery_city_name = null;

                $totalPrice = 0;

                $placementPrice = 0;

                $agent_name = [];

            

                foreach ($orderDetails as $orderDetail) {

                    foreach ($orderDetail as $orderDet) {

                        if ($orders->id == $orderDet->order_id) {

                            $delivery_date = $orderDet->delivery_date;

                            $delivery_city_name = $orderDet->delivery_city_name;

                            $totalPrice += $orderDet->total_price;

                        }

                    }

                }

            

                foreach ($AgentAssign as $AgentAssigns) {

                    foreach ($AgentAssigns as $key => $details) {

                        if ($details->OID == $orders->id) {

                            $placementPrice += $details->totalPrice;

                

                            foreach ($Agent as $Agents) {

                                foreach ($Agents as $agented) {

                                    if ($details->agent_id == $agented->id) {

                                        $agent_name[] = $agented->name;

                                    }

                                }

                            }

                        }

                    }

                    

                }

                // foreach ($agent_name as $agent_names) {

                //     $agent_name[$agent_names->name] = $agent_names->name; 

                // }

                $agent_name=array_unique($agent_name);

            

                $profit = ($totalPrice > 0) ? ($placementPrice / $totalPrice) * 100 : 0;



                if (($profitType == '20' && $profit >= 20 && $profit <= 30) ||

                    ($profitType == '31' && $profit >= 31 && $profit <= 40) ||

                    ($profitType == '41' && $profit >= 41 && $profit <= 50) ||

                    ($profitType == '51' && $profit >= 51 && $profit <= 60) ||

                    ($profitType == '60' && $profit >= 60) ||

                    ($profitType == "ALL" && $profit > 0) ||

                    !$profitType

                ) {

                

                    $tableItem[] = [

                        'uniqueId' => $orders->unique_order_id,

                        'delivery_date' => $delivery_date,

                        'delivery_city_name' => $delivery_city_name,

                        'totalOrderPrice' => $totalPrice,

                        'placementTotal' => $placementPrice,

                        'profit' => $profit,

                        'agent_name' => $agent_name,

                        'status' => "DELIVERED",

                    ];

                }

            }

            

            // return $tableItem;

            // echo "<pre>";

            // print_r($tableItem);

            // die;

             return view('admin.ProfitReportSearch',compact('tableItem','start_date','end_date'));



        }else{

            return redirect()->route('admin.login');

        }

        

    }


    public function images(Request $request){

    	// $result = DB::table('products')
    	// 		  ->join('product_images','product_images.product_id','=','products.id')
    	// 		  ->where('products.product_type', '=', 'M')
    	// 		  ->get(["product_images.name", "product_images.thumb", "products.fnid", "products.sku"]);
    	// // dd($result);

    	$orWhere = [];

        if($request->search != null){

            $orWhere[] = ['fnid', '=', $request->search];
            $orWhere[] = ['sku', '=', $request->search];

            $search = $request->search;

        }else{
            $search = '';
        }

        $result = DB::table('products')
                ->join('product_images', 'product_images.product_id','=','products.id')
                ->when($search, function ($query, $search) {
                    $query->where(function ($subQuery) use ($search) {
                        $subQuery->orWhere('products.fnid', '=', $search)
                        		 ->orWhere('products.sku', '=', $search);	
                    });
                })
                ->where([
                    ['products.product_type', '=', 'M']
                ])
                ->orderBy('products.id', 'asc')
                ->select("product_images.name", "product_images.thumb", "products.fnid", "products.sku")
                ->paginate(100); // Change 100 to however many results per page you want

                

        return view('admin.images', ['result' => $result,  'request' => $request, 'search' => $search]);	
    }
    

}

