<?php $__env->startSection('content'); ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<!-- <script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script> -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
    <?php if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'M'): ?>
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">HomeFeatureManagement</h4>
                    <div class="ml-auto text-right">
                        <a href="<?php echo e(url('admin/homefeaturemanagement/list/')); ?>/<?php echo e(base64_encode($dataDetails->site_id)); ?>" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
		    <div class="row">
		        <div class="col-12">
		            <div class="card">
		                <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		                    <?php if(Session::has('alert-' . $msg)): ?>
		                        <h4 class="font-weight-light alert alert-<?php echo e($msg); ?>"><?php echo e(Session::get('alert-' . $msg)); ?></h4>
		                    <?php endif; ?>
		                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

		                <form action="<?php echo e(route('admin.homefeaturemanagement.edit',[base64_encode($dataDetails->id)])); ?>" method="POST" class="form-horizontal" id="formadd"  >
		                    <?php echo csrf_field(); ?>
		                    <div class="card-body">
		                        <h4 class="card-title">HomeFeatureManagement Edit</h4>
		                        
		                        <input type="hidden" name="formid" value="<?php echo $dataDetails->id; ?>">
		                        <input type="hidden" id="site_id" name="site_id" value="<?php echo $dataDetails->site_id; ?>">
		                        <div class="form-group m-t-20">
		                            <label>Title<span style="color:red;">*</span></label>
		                            <input type="text" class="form-control" id="title" name="title" placeholder="Enter Title" value="<?php echo e($dataDetails->title); ?>" required>
		                        </div>
		                        
		                        <div class="form-group m-t-20">
		                            <label>Description</label>
		                            <input type="text" class="form-control" id="description" name="description" placeholder="Enter Description"  value="<?php echo e($dataDetails->description); ?>">
		                        </div>

		                        <div class="form-group m-t-20">
		                            <label>Slug</label>
		                            <input type="text" class="form-control" id="slug" name="slug" placeholder="Enter slug" value="<?php echo e($dataDetails->slug); ?>">
		                        </div>

		                        <div class="form-group m-t-20">
		                            <label>Catagory<span style="color:red;">*</span></label>
		                            <select id="category-products" name="category" class="form-control selectpicker2" data-live-search="true" data-live-search-placeholder="Search" data-actions-box="true" required>
		                                <option value="">-Select-</option>
		                                <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		                                    <option value="<?php echo e($category->id); ?>" <?php if($category->id == $dataDetails->category_id): ?> selected <?php endif; ?> data-catid="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
		                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		                            </select>
		                        </div>
		                       
		                        <div class="form-group m-t-20">
		                            <label>Products<span style="color:red;">*</span></label>
		                            <select class="form-control selectpicker2" name="product_id[]" multiple="multiple" data-live-search="true" data-live-search-placeholder="Search" data-actions-box="true" id="product_id" required></select>
		                        </div>

		                        <div class="form-group m-t-20">
		                            <label>Data Limit<span style="color:red;">*</span></label>
		                            <input type="text" class="form-control" id="data_limit" name="data_limit" placeholder="Enter Limit" value="<?php echo e($dataDetails->data_limit); ?>" required>
		                        </div>

		                        <div class="form-group m-t-20">
		                            <label>Sort</label>
		                            <input type="number" class="form-control" id="sort" name="sort" placeholder="Enter Sort" value="<?php echo e($dataDetails->sort); ?>">
		                        </div>
		                    </div>
		                    <div class="border-top">
		                        <div class="card-body">
		                            <input class="btn btn-primary" type="submit" value="UPDATE">
		                        </div>
		                    </div>
		                </form>
		            </div>
		        </div>
		    </div>
		</div>
    <?php endif; ?>
</main>    

<script type="text/javascript">
    $.validator.setDefaults({
            submitHandler: function(form) {
                form.submit();
            }
    });
    $(function() {
        // validate the comment form when it is submitted
        $("#formadd").validate({
            ignore: [],
            errorPlacement: function(label, element) {
                label.addClass('mt-2 text-danger');
                label.insertAfter(element);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass('has-danger')
                $(element).addClass('form-control-danger')
            }
          });
    });

    <?php 
        $product_selected = implode(',',$product_selected);
	?>

    $(document).on('change', '#category-products', function(event){

    	setTimeout(function () {
            $('#category-products-error').attr("style", "display: none !important");
        },100); // 60000ms = 1 minute

        var cgnobj = this;
        var catid = $(this).val();
        var site_id = $('#site_id').val();
        
        $.ajax({
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            async: true,
            type : "POST",
            url : "<?php echo e(route('admin.homefeaturemanagement.categoryproduct')); ?>",
            data:  { 
            	catid : catid,
            	site_id : site_id 
            },
            success : function(response){
                response = JSON.parse(response);
                console.log(response);
                if(response.status == "success"){
                    $('#product_id').html(response.data);
                    $('#product_id').selectpicker('val', [<?php echo $product_selected; ?>]);

                    
                    $('.selectpicker2').selectpicker('refresh');
                }
            },
            error : function(){
            }
            
        });  
    })

    $('#category-products').trigger('change');

</script>     

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/homefeaturemanagement/edit.blade.php ENDPATH**/ ?>