<?php $__env->startSection('content'); ?>

    <main id="main" class="main">

        <?php if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA' || Session::get('permissions.user_type') == 'M'): ?>
            <div class="page-breadcrumb">
                <div class="row">
                    <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                        <h4 class="page-title">Product Ratings</h4>
                        <div class="ml-auto text-right">
                            <a href="<?php echo e(route('admin.product.productrating')); ?>" class="btn btn-success">Back</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="product-search">
                                    <div class="prod-search-title">
                                        <h5 class="card-title">
                                            Product Ratings
                                        </h5>
                                    </div>
                                    <div class="prod-search-body">
                                        <form action="<?php echo e(route('admin.product.productrating')); ?>" id="search-form" method="post">
                                            <?php echo csrf_field(); ?>
                                            <input class="form-control" id="search-field" name="search" value="<?php echo e($search); ?>" placeholder="Search By FNID">
                                            <button class="btn btn-primary" type="submit" ><i class="fa fa-search"></i></button>
                                        </form>                     
                                    </div>
                                </div>
                                <?php if(count($result) > 0): ?>
                                <div class="table-responsive">
                                    <table id="zero_config" class="table table-striped table-bordered">
                                        <thead>
                                            <tr>
                                                <th style="width: 10%"><b>No.</b></th>
                                                <th style="width: 10%"><b>FNID</b></th>
                                                <th style="width: 12%"><b>Product Name</b></th>
                                                <th style="width: 17%"><b>Review</b></th>
                                                <th style="width: 8%"><b>Rating</b></th>
                                                <th style="width: 10%"><b>Sender Name</b></th>
                                                <th style="width: 10%"><b>Delivery From</b></th>
                                                <th style="width: 10%">Created At</th>
                                                <th style="width: 10%"><b>Status</b></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i=1; ?>
                                            <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($i + $key); ?></td>
                                                <td><?php echo e($data->fnid); ?></td>
                                                <td><?php echo e($data->product_name); ?></td>
                                                <td><?php echo e($data->review); ?></td>
                                                <td><?php echo e($data->rating); ?></td>
                                                <td><?php echo e($data->user_name); ?></td>
                                                <td><?php echo e($data->sender_place); ?></td>
                                                <td><?php echo e(date('d-m-y', strtotime($data->created_at))); ?></td>
                                                <td>
                                                    <label class="switch">
                                                        <input type="checkbox" class="blockstatus" name="stat" id="stat" data-id="<?php echo e(base64_encode($data->id)); ?>" <?php if($data->is_block == 'N'): ?> checked <?php endif; ?>>
                                                        <span class="slider roundsemi"></span>
                                                    </label>
                                                    <label id="status-info-<?php echo e($data->id); ?>" class="status-stat"></label>
                                                </td>
                                                
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tfoot>
                                    </table>
                                    
                                    <div style="font-size: 15px; text-align: left; display: inline;">
                                        Showing <?php echo e($result->firstItem()); ?> to <?php echo e($result->lastItem()); ?> of <?php echo e($result->total()); ?> entries
                                    </div>
                                    <div class="text-center-pagination pagination" style="float:right;">
                                        <?php echo $result->withQueryString()->links('pagination::bootstrap-4'); ?>

                                    </div>
                                </div>
                                <?php else: ?>
                                	<div class="card">No Data Found...</div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
        <?php endif; ?>    
    </main><!-- End #main -->

    <style>
        .prod-search-body {
            display: flex;
            justify-content: flex-end; /* Align to right */
            margin: 20px 0;
        }

        #search-form {
            display: flex;
            flex-wrap: nowrap;
            align-items: center;
            gap: 10px;
            max-width: 100%;
        }

        #search-field {
            padding: 10px 12px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 6px;
            box-shadow: inset 0 1px 2px rgba(0,0,0,0.1);
        }

        #search-form .btn {
            padding: 10px 16px;
            font-size: 16px;
            border-radius: 6px;
        }

        @media (max-width: 576px) {
            #search-form {
                flex-direction: column;
                align-items: flex-end;
                gap: 8px;
            }

            #search-form .btn,
            #search-field {
                width: 100%;
            }
        }
    </style>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <script>

        /****************************************
         *       Basic Table                   *
         ****************************************/

        // $('#zero_config').DataTable({
        //     "order": [[5, "desc"]] 
        // });


        // document.addEventListener("DOMContentLoaded", function () {
        //     const table = document.querySelector("#zero_config");
        //     const dataTable = new simpleDatatables.DataTable(table, {
        //         sortable: true,
        //         fixedHeight: false,
        //         columns: [
        //             { select: 7, sort: "asc" }
        //         ]
        //     });
        // });


        $(function(){
            setTimeout(function(){ $('.alert').hide(); }, 3000);
            var status, id;
            $('#zero_config').on('change', '.blockstatus', function() {
            // $('.blockstatus').change(function(){
                if(this.checked){
                    status = 'Y';
                }else{
                    status = 'N'
                }
                id = $(this).attr('data-id');
                var ajaxurl = "<?php echo e(route('admin.product.productrating_status')); ?>"; 
                $.ajax({
                    type : 'POST',
                    url : ajaxurl,
                    data : { 'id' : id, 'status' : status },
                    headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success : function(response){
                        response = JSON.parse(response);
                        if(response.status == 1){
                            $('#status-info-'+response.id).html(response.event).fadeIn(100).delay(1000).fadeOut();
                            location.reload(true);
                        }
                    },
                    error : function(){
                        $('.selected_records_data').html('<span class="error-msg text-danger">There was an unexpected error!! Please try again later.</span>');
                    }
                });
            });
        })

    </script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/product/product_rating.blade.php ENDPATH**/ ?>