<?php $__env->startSection('content'); ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title" style="display: inline-block;padding: 0 10px 0 0;">Product Excel</h4>
                            <div class="row g-3">
                              
                                <div class="col-md-4">
                                    <select id="vendor_id" name="vendor_id" type="text" class="form-control"
                                        aria-required="true" aria-invalid="false" required>
                                        <option value="">Select Vendor</option>
                                        <?php $__currentLoopData = $vendor_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e(($list->vendor_code)); ?>"><?php echo e($list->vendor_code); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="col-md-4">
                                    <select id="specification_id" name="specification_id" type="text" class="form-control"
                                        aria-required="true" aria-invalid="false" required>
                                        <option value="">Select Specification</option>
                                        <?php $__currentLoopData = $specifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e(($list->specification_name)); ?>"><?php echo e($list->specification_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="col-md-4">
                                    <label>Delivery Type : </label><br>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="delivery_type" value="All" checked>
                                        <label class="form-check-label" for="">All</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="delivery_type" value="H">
                                        <label class="form-check-label" for="">Hand Delivery</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="delivery_type" value="C">
                                        <label class="form-check-label" for="">Courier </label>
                                    </div>
                                </div>

                                <div class="border-top">
                                    <div class="card-body">
                                        <button class="btn btn-primary" id="start-export">Import</button>
                                        <div id="export-status"></div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
</main>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

<script type="text/javascript">
    let currentPage = 1;
    let totalPages = 1;
    let vendor_id, specification_id, selectedDeliveryType;

    $('#start-export').on('click', function () {
        $('#export-status').text('Exporting... Please wait...');

        // Get current form filter values
        vendor_id = $('#vendor_id').val();
        specification_id = $('#specification_id').val();
        selectedDeliveryType = $('input[name="delivery_type"]:checked').val();

        $.get('<?php echo e(url("/admin/product/export-chunk")); ?>', {
            page: 1,
            vendor_id: vendor_id,
            specification_id: specification_id,
            delivery_type: selectedDeliveryType
        }, function (data) {
            if (data.success) {
                totalPages = data.total_pages;
                currentPage = 2; // already did page 1
                $('#export-status').text(`Processed page 1 of ${totalPages}`);
                processNextChunk();
                console.log(data.totalProducts);
            } else {
                $('#export-status').text('Failed to start export.');
            }
        });
    });

    function processNextChunk() {
        if (currentPage > totalPages) {
            $('#export-status').text('Merging files and preparing download...');
            window.location.href = '<?php echo e(url("/admin/product/download-final-excel")); ?>';
            return;
        }

        $.get('<?php echo e(url("/admin/product/export-chunk")); ?>', {
            page: currentPage,
            vendor_id: vendor_id,
            specification_id: specification_id,
            delivery_type: selectedDeliveryType
        }, function (data) {
            if (data.success) {
                $('#export-status').text(`Processed page ${currentPage} of ${totalPages}`);
                currentPage++;
                processNextChunk();
            } else {
                $('#export-status').text(`Error on page ${currentPage}`);
            }
        });
    }
</script>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/product/product_excel.blade.php ENDPATH**/ ?>