<script src="https://raw.githack.com/eKoopmans/html2pdf/master/dist/html2pdf.bundle.js"></script>

<style>
#bodyInvoice {
  font-family: Arial, sans-serif;
  margin: 0;
  padding: 0;
  
}

#invoice-container {
  width: 800px;
  margin: 0 auto;
  border: 1px solid #ccc;
  background-color: #fff;
}

#invoice-header {
  background-color: #002d72;
  color: white;
  padding: 20px;
  display: flex;
  justify-content: space-between;
}

#logo-section #company-logo {
  background-color: white;
  color: #002d72;
  padding: 10px;
  width: 140px;
  text-align: center;
  font-weight: bold;
}

#business-info h1 {
  margin: 0;
  font-size: 20px;
}

#invoice-details {
  display: flex;
  justify-content: space-between;
  padding: 20px;
  font-size: 14px;
}

#details-left p {
  margin: 5px 0;
}

#bill-to {
  text-align: right;
}

#item-table {
  width: 100%;
  border-collapse: collapse;
  margin: 0 20px;
}

#item-table th,
#item-table td {
  border-bottom: 1px solid #ccc;
  padding: 10px;
  text-align: left;
  font-size: 14px;
}

#terms-section {
  display: flex;
  justify-content: space-between;
  padding: 20px;
  font-size: 14px;
}

#terms-text {
  width: 60%;
}

#summary {
  width: 35%;
  text-align: right;
}

#summary p {
  margin: 5px 0;
}

#summary span {
  float: right;
}

#conditions {
  padding: 20px;
  font-size: 14px;
}

#footer {
  background-color: #002d72;
  color: white;
  text-align: right;
  padding: 10px 20px;
  font-size: 14px;
}

</style>
<?php $__env->startSection('content'); ?>
  <main id="main" class="main">

    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('agent.assignorder.AgentMonthPayment')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <table class="table" style="text-align:center;">
                        <thead>
                            <tr>
                                <th>From Date</th>
                                <th>To Date</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                               <td>
                                    <input type="date" name="fromDate" id="fromDate" class="form-control" value="<?php echo e($startDate ?? ''); ?>" required />
                                </td>
                                <td>
                                    <input type="date" name="toDate" id="toDate" class="form-control" value="<?php echo e($EndDate ?? ''); ?>" required />
                                </td>

                                <td><button class="btn btn-primary" type="submit">Search</button></td>
                            </tr>
                        </tbody>
                    </table>
                </form>
                <?php if($result == 1): ?>
                    <br>
                    <h3 style="text-align:center;"><b>DELIVERY REPORT</b></h3>
                    <br>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Sr No</th>
                                <th>Assign Order Id</th>
                                <th>Products</th>
                                <th>Delivery Date</th>
                                <th>Status</th>
                                <th>Price</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="myTable">
                            <?php 
                            $i = 0; 
                            $totalPrice = 0;
                            ?>
                            <?php $__empty_1 = true; $__currentLoopData = $agent_assigned; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent_assigneds): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php $i++; ?>
                                <tr>
                                    <th scope="row"><?php echo e($i); ?></th>
                                    <td><?php echo e($agent_assigneds->agent_order_id); ?></td>
                                    <td>
                                        <?php
                                            $printedProducts = [];
                                        ?>
                                        <?php $__currentLoopData = $product_maped; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $__currentLoopData = $key; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_mapeds): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($product_mapeds->agent_assinged_id == $agent_assigneds->id): ?>
                                                    <?php $__currentLoopData = $agent_product_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($product->id == $product_mapeds->product_id && !in_array($product->id, $printedProducts)): ?>
                                                            <?php echo e($product->item); ?> (QTY : <?php echo e($product_mapeds->qty); ?>)<br>
                                                            <?php
                                                                $printedProducts[] = $product->id; 
                                                            ?>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td>
                                        <?php
                                            $founddetails = false;
                                        ?>
                                        <?php $__currentLoopData = $order_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order_detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($order_detail->order_id == $agent_assigneds->OID): ?>
                                                <?php echo e($order_detail->delivery_date); ?>

                                                <?php
                                                    $founddetails = true;
                                                    break;
                                                ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td>
                                        <?php if($agent_assigneds->status=='P'): ?>
                                            <h6><span class="badge bg-danger">PENDING</span></h6>
                                        <?php elseif($agent_assigneds->status=='PC'): ?>
                                            <h6><span class="badge bg-info">PROCESSED</span></h6>
                                        <?php elseif($agent_assigneds->status=='CL'): ?>
                                            <h6><span class="badge bg-dark">CANCEL</span></h6>
                                        <?php elseif($agent_assigneds->status=='H'): ?>
                                            <h6><span class="badge bg-warning">HOLD</span></h6>
                                        <?php elseif($agent_assigneds->status=='D'): ?>
                                            <h6><span class="badge bg-success">DELIVERED</span></h6>
                                        <?php elseif($agent_assigneds->status=='S'): ?>
                                            <h6><span class="badge bg-primary">SHIPPED</span></h6>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e($agent_assigneds->totalPrice); ?>

                                    </td>
                                    <?php 
                                        $totalPrice+=$agent_assigneds->totalPrice 
                                    ?>
                                    <td>
                                        <a href="<?php echo e(url('/agent/assignorder/assign-order-view')); ?>/<?php echo e(encrypt($agent_assigneds->agent_order_id)); ?>/<?php echo e(encrypt($agent_assigneds->agent_id)); ?>" class="btn btn-dark btn-sm"><i class="ri-file-edit-fill"></i></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td colspan="7" style="text-align:center;"><span class="badge border-danger border-1 text-danger">No Data Found</span></td>
                            <?php endif; ?>
                        <tbody>
                    </table>
                    <div style="text-align:end;">
                        <button type="button" class="btn btn-primary mb-2" id="downloadInvoice">
                            Total: 
                            <span class="badge bg-white text-primary">
                                <?php echo e($totalPrice); ?> 
                                <i class="bi bi-printer-fill"></i>
                            </span>
                        </button>
                    </div>



                    <body id="bodyInvoice">
                        <div id="invoice-container" style="display:none;">
                            <div id="invoice-header">
                                <div id="logo-section">
                                    <div id="company-logo">Your Company Logo</div>
                                </div>
                                <div id="business-info">
                                    <h1>Business Name</h1>
                                    <p>Street Address Line 01<br>
                                    Street Address Line 02<br>
                                    +1 (999)-999-9999<br>
                                    Email Address<br>
                                    Website</p>
                                </div>
                            </div>

                            <div id="invoice-details">
                                <div id="details-left">
                                    <!-- <p><strong>Invoice #</strong> 0000</p> -->
                                    <p><strong>Date of Issue</strong> <?php echo e($startDate); ?> to <?php echo e($EndDate); ?></p>
                                    <!-- <p><strong>Due Date</strong> MM/DD/YYYY</p> -->
                                </div>
                                <div id="bill-to">
                                    <strong>Bill To:</strong><br>
                                    <span id="customer-name"><?php echo e($user->name); ?></span><br>
                                    Street Address Line 01<br>
                                    Street Address Line 02
                                </div>
                            </div>

                            <table id="item-table">
                            <thead>
                                <tr>
                                    <th>Sr No</th>
                                    <th>ITEM/SERVICE</th>
                                    <th>AMOUNT</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                <?php 
                                    $i = 0; 
                                    $totalPricePdf = 0;
                                ?>
                            <?php $__empty_1 = true; $__currentLoopData = $agent_assigned; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent_assigneds): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php $i++; ?>
                                <tr>
                                    <th scope="row"><?php echo e($i); ?></th>
                                      <td><?php echo e($agent_assigneds->agent_order_id); ?></td>
                                    <td>
                                        <?php echo e($agent_assigneds->totalPrice); ?>

                                    </td>
                                    <?php 
                                        $totalPricePdf+=$agent_assigneds->totalPrice 
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <td colspan="7" style="text-align:center;"><span class="badge border-danger border-1 text-danger">No Data Found</span></td>
                                <?php endif; ?>
                                </tr>
                            </tbody>
                            </table>

                            <div id="terms-section">
                            <div id="terms-text">
                                <strong>TERMS</strong><br>
                                Text Here
                            </div>
                            <div id="summary">
                                <p><strong>TOTAL : </strong> <span><?php echo e($totalPricePdf); ?></span></p>
                            </div>
                            </div>

                            <div id="conditions">
                            <strong>CONDITIONS/INSTRUCTIONS</strong><br>
                            Text Here
                            </div>

                            <div id="footer">
                            <p>FreshBooks</p>
                            </div>
                        </div>
                            <!-- <div>
                                <button type="button" class="btn btn-primary mb-2" id="downloadInvoice" style="display:none;" style="text-align:center;">
                                    <span class="badge bg-white text-primary">
                                        <i class="bi bi-printer-fill"></i>
                                    </span>
                                </button>
                            </div> -->
                    </body>
                     
                 <?php endif; ?>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->
  <script>
    document.getElementById("downloadInvoice").addEventListener("click", function () {
        // Show hidden content before converting
        const invoice = document.getElementById("invoice-container");
        invoice.style.display = "block";

        const opt = {
            margin:       0.5,
            filename:     'invoice.pdf',
            image:        { type: 'jpeg', quality: 0.98 },
            html2canvas:  { scale: 2 },
            jsPDF:        { unit: 'in', format: 'letter', orientation: 'landscape' }
        };

        html2pdf().from(invoice).set(opt).save().then(() => {
            invoice.style.display = "block"; // Hide again after saving
        });
    });
    $('#generateInvoice').click(function(){
        $('#invoice-container').css('display','block');
        $('#downloadInvoice').css('display','block');
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.agent.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/agent/AgentMonthPayment.blade.php ENDPATH**/ ?>