<!DOCTYPE html>
<html>
    <head>
        <title>Product Export</title>
    </head>
    <body>
        <table border="1" cellspacing="0" cellpadding="5">
            <thead>
                <tr>
                    <th><b>Product ID</b></th>
                    <th><b>Product Name</b></th>
                    <th><b>Product Link</b></th>
                    <th><b>Description</b></th>
                    <th><b>Content</b></th>
                    <th><b>Price</b></th>
                    <th><b>Actual Price</b></th>
                    <th><b>Block Status</b></th>
                    <th><b>Delay Days</b></th>
                    <th><b>Delivery Type</b></th>
                    <th><b>Specification</b></th>
                    <th><b>Segregation</b></th>
                    <th><b>Vendor Name</b></th>
                    <th><b>Category</b></th>
                </tr>
            </thead>
            <tbody>
                @php $rowNum = 2; @endphp
                @foreach($product as $prod)
                    @if(is_object($prod))
                        @if ($prod->has_attribute === 'Y') @php $rowStyles[] = $rowNum; @endphp @endif
                        <tr>
                            <td>{{ $prod->fnid }}</td>
                            <td>{{ $prod->product_name }}</td>
                            <td>https://www.rakhisutra.com/{{ $prod->slug }}</td>
                            <td>{{ $prod->description }}</td>
                            <td>{{ $prod->content }}</td>
                            <td>{{ $prod->price }}</td>
                            <td>{{ $prod->actual_price }}</td>
                            <td>{{ $prod->is_block }}</td>
                            <td>{{ $prod->delivery_delay_days }}</td>
                            <td>{{ $prod->delivery_type }}</td>
                            <td>{{ $prod->specification }}</td>
                            <td>{{ $prod->segregation }}</td>
                            <td>{{ $prod->vendor_name }}</td>
                            <td>
                                @foreach(App\Http\Helper1::product_relatated_category_list($prod->id) as $cat)
                                    {{ $cat }} |
                                @endforeach
                            </td>
                        </tr>
                        @php $rowNum++; @endphp

                        @if ($prod->has_attribute === 'Y' && isset($product_attribute[$prod->id]) && is_iterable($product_attribute[$prod->id]))
                            @foreach ($product_attribute[$prod->id] as $attr)
                                <tr>
                                    <td>{{ $attr->attribute_fnid }}</td>
                                    <td>{{ $prod->product_name }}</td>
                                    <td>https://www.rakhisutra.com/{{ $prod->slug }}</td>
                                    <td>{{ $prod->description }}</td>
                                    <td>{{ $attr->content }}</td>
                                    <td>{{ $attr->price }}</td>
                                    <td>{{ $attr->actual_price }}</td>
                                    <td>{{ $attr->is_block }}</td>
                                    <td>{{ $prod->delivery_delay_days }}</td>
                                    <td>{{ $prod->delivery_type }}</td>
                                    <td>{{ $prod->specification }}</td>
                                    <td>{{ $prod->segregation }}</td>
                                    <td>{{ $prod->vendor_name }}</td>
                                    <td>
                                        @foreach(App\Http\Helper1::product_relatated_category_list($prod->id) as $cat)
                                            {{ $cat }} |
                                        @endforeach
                                    </td>
                                </tr>
                                @php $rowNum++; @endphp
                            @endforeach
                        @endif
                    @endif
                @endforeach
            </tbody>
        </table>
    </body>
</html>
