@extends('layouts.admin.app')

@section('content')
@php
$query = 'Queries';
$complaint = 'Complaint';
@endphp
    <main id="main" class="main">
        @if( Session::get('permissions.user_type') == 'OP' || Session::get('permissions.user_type') == 'M')
            <div class="pagetitle">
              <h1>Dashboard</h1>
              <!-- <nav>
                <ol class="breadcrumb">
                  <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                  <li class="breadcrumb-item">Tables</li>
                  <li class="breadcrumb-item active">General</li>
                </ol>
              </nav> -->
            </div><!-- End Page Title -->
          <section class="section dashboard">
            <div class="row">
              <div class="col-lg-12">
                <div class="row">
                  
                  <!-- This Month Orders Card -->
                  <div class="col-lg-3 col-md-6">
                    <div class="card info-card sales-card">
                      <a href="{{ url('/admin/order')}}">
                        <div class="card-body">
                          <h5 class="card-title">This Month Orders <span>| {{ date('M, y') }}</span></h5>
                          <div class="d-flex align-items-center">
                            <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                              <i class="ri-file-chart-fill"></i>
                            </div>
                            <div class="ps-3">
                              <h6>{{ count($monthAllorder) }}</h6>
                              <span class="text-success small pt-1 fw-bold">Order Amount ₹{{ $monthTotalOrderAmt }}</span>
                            </div>
                          </div>
                        </div>
                      </a>
                    </div>
                  </div>

                  <!-- Orders Today Card -->
                  <div class="col-lg-3 col-md-6">
                    <div class="card info-card revenue-card">
                      <a href="{{ url('/admin/order')}}">
                        <div class="card-body">
                          <h5 class="card-title">Orders <span>| Today</span></h5>
                          <div class="d-flex align-items-center">
                            <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                              <i class="ri-edit-box-fill"></i>
                            </div>
                            <div class="ps-3">
                              <h6>{{ count($todayAllorder) }}</h6>
                            </div>
                          </div>
                        </div>
                      </a>
                    </div>
                  </div>

                  <!-- Pending Orders Card -->
                  <div class="col-lg-3 col-md-6">
                    <div class="card info-card customers-card">
                      <a href="{{ url('/admin/order?orderstatus=P')}}">
                        <div class="card-body">
                          <h5 class="card-title">Pending <span>| Orders</span></h5>
                          <div class="d-flex align-items-center">
                            <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                              <i class="ri-draft-fill"></i>
                            </div>
                            <div class="ps-3">
                              <h6>{{ count($pendingAllorder) }}</h6>
                            </div>
                          </div>
                        </div>
                      </a>
                    </div>
                  </div>

                  <!-- Cancel Orders Card -->
                  <div class="col-lg-3 col-md-6">
                    <div class="card info-card customers-card">
                      <a href="{{ url('/admin/order?orderstatus=CL')}}">
                        <div class="card-body">
                          <h5 class="card-title">Cancel Orders <span>| {{ date('M, y') }}</span></h5>
                          <div class="d-flex align-items-center">
                            <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                              <i class="ri-delete-bin-5-fill"></i>
                            </div>
                            <div class="ps-3">
                              <h6>{{ count($monthCancelorder) }}</h6>
                            </div>
                          </div>
                        </div>
                      </a>
                    </div>
                  </div>

                </div> <!-- End inner row -->
              </div> <!-- End col-lg-12 -->
            </div> <!-- End outer row -->
          </section>
            <div class="pagetitle">
              <h1>Site Order</h1>
            </div><!-- End Page Title -->
            <section class="section dashboard">
            <div class="row">
              <div class="col-lg-12">
                <div class="row">
                  @forelse($tableItems as $tableItem)
                    <a href="{{ route('admin.order.SiteNamewiseList', encrypt($tableItem['sitename'])) }}" target="_blank">
                      <div class="col-lg-3 col-md-6 mb-4">
                        <div class="card info-card sales-card shadow-sm">
                          <div class="card-body">
                            <h5 class="card-title">
                              {{ strtoupper($tableItem['sitename']) }}
                            </h5>
                            <div class="d-flex align-items-start">
                              {{-- <div class="card-icon rounded-circle d-flex align-items-center justify-content-center bg-light text-dark me-3">
                                <i class="ri-file-chart-fill fs-4"></i>
                              </div> --}}
                              <div class="ps-1">
                                <p class="mb-2 fw-bold text-dark">Today Orders: <span class="text-primary">{{ $tableItem['todayOrders'] }}</span> (₹{{ $tableItem['todayAmt'] }})</p>

                                <p class="mb-2 fw-bold text-dark">This Month Orders: <span class="text-success">{{ $tableItem['ThisMonthOrders'] }}</span> (₹{{ $tableItem['ThisMonthAmt'] }})</p>

                                <p class="mb-2 fw-bold text-dark">Pending Orders: <span class="text-danger">{{ $tableItem['PendingOrders'] }}</span></p>
                                {{-- <p class="mb-2 fw-bold text-dark">Cancel Orders: <span class="text-secondary">{{ $tableItem['CancelOrder'] }}</span></p> --}}

                                {{-- <a href="{{ route('admin.order.SiteNamewiseList', encrypt($tableItem['sitename'])) }}" class="btn btn-sm btn-outline-primary mt-2">View Orders</a> --}}
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </a>
                  @empty
                  @endforelse

                </div> 
              </div> 
            </div>
          </section>
            
        @endif 

        @if( Session::get('permissions.user_type') == 'OP' || Session::get('permissions.user_type') == 'M' || Session::get('permissions.user_type') == 'C') 
          <section class="section dashboard">
            <div class="row">
              <!-- Query Contacts -->
              <div class="col-lg-8">
                <div class="row">
                  <div class="pagetitle">
                    <h1>Query contacts</h1>
                  </div>
                  @forelse($Queriescontacts as $Queriescontact)
                    <a class="dropdown-item" href="{{ url('/admin/order/sitelabels/' . $query . '/' . $Queriescontact->countryName) }}">
                      <div class="col-xxl-4 col-md-6">
                        <div class="card info-card sales-card">
                          <div class="card-body">
                            <h5 class="card-title">{{ $Queriescontact->countryName }} <span>| unread Notifications</span></h5>
                            <div class="d-flex align-items-center">
                              <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                <i class="ri-mail-unread-fill"></i>
                              </div>
                              <div class="ps-3">
                                <h6>{{ $Queriescontact->unread ?? 0 }}</h6>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </a>
                  @empty
                    <div class="col-xxl-4 col-md-6">
                      <div class="card info-card sales-card">
                        <div class="card-body">
                          <h5 class="card-title">No Data <span>| unread Notifications</span></h5>
                          <div class="d-flex align-items-center">
                            <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                              <i class="ri-mail-unread-fill"></i>
                            </div>
                            <div class="ps-3">
                              <h6>0</h6>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  @endforelse
                </div>
              </div>
            </div>
          </section>

          <section class="section dashboard">
            <div class="row">
              <!-- Complaint Contacts -->
              <div class="col-lg-8">
                <div class="row">
                  <div class="pagetitle">
                    <h1>Complaint contacts</h1>
                  </div>
                  @forelse($Complaintcontacts as $Complaintcontact)
                    <a class="dropdown-item" href="{{ url('/admin/order/sitelabels/' . $complaint . '/' . $Complaintcontact->countryName) }}">
                      <div class="col-xxl-4 col-md-6">
                        <div class="card info-card sales-card">
                          <div class="card-body">
                            <h5 class="card-title">{{ $Complaintcontact->countryName }} <span>| unread Notifications</span></h5>
                            <div class="d-flex align-items-center">
                              <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                <i class="ri-mail-unread-fill"></i>
                              </div>
                              <div class="ps-3">
                                <h6>{{ $Complaintcontact->unread ?? 0 }}</h6>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </a>
                  @empty
                    <div class="col-xxl-4 col-md-6">
                      <div class="card info-card sales-card">
                        <div class="card-body">
                          <h5 class="card-title">No Data <span>| unread Notifications</span></h5>
                          <div class="d-flex align-items-center">
                            <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                              <i class="ri-mail-unread-fill"></i>
                            </div>
                            <div class="ps-3">
                              <h6>0</h6>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  @endforelse
                </div>
              </div>
            </div>
          </section>
        @endif  
          
        
    </main>
            
<style>
.card-body {padding: 0 4px 2px 15px;}
.card-title {padding: 10px 0 6px 0; font-size: 16px;}
.dashboard .card-icon {font-size: 27px; line-height: 0; width: 50px; height: 50px; flex-shrink: 0; flex-grow: 0; }
</style>


    

@endsection

@section('script')

<script type="text/javascript">
    /******auto refresh HTML only if there has been no activity on a page******/

    var inactivityTimeout;
    var inactivityDuration = 600000; // 10 minutes in milliseconds

    function resetInactivityTimer() {
        clearTimeout(inactivityTimeout);
        inactivityTimeout = setTimeout(refreshPage, inactivityDuration);
    }

    function refreshPage() {
        location.reload();
    }

    // Event listeners to reset the inactivity timer
    document.addEventListener('mousemove', resetInactivityTimer);
    document.addEventListener('keydown', resetInactivityTimer);
    document.addEventListener('scroll', resetInactivityTimer);

    // Initial setup of the inactivity timer
    resetInactivityTimer();
</script>

@endsection
