@extends('layouts.admin.app')

@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>

<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>

<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
    @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'M' )
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">CATEGORY</h4>
                    <div class="ml-auto text-right">
                        <a href="{{ route('admin.category.list') }}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <!-- ============================================================== -->
            <!-- Start Page Content -->
            <!-- ============================================================== -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                            @if(Session::has('alert-' . $msg))
                                <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
                            @endif
                        @endforeach
                        <form action="{{route('admin.category.add')}}" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <h4 class="card-title">Category Add</h4>

                                <div class="form-group m-t-20">
                                    <label>Category Title<span>*</span></label>
                                    <input type="text" class="form-control" id="ctitle" name="ctitle" placeholder="Enter Category Title" required>
                                    @if ($errors->has('ctitle'))
                                        <span class="error">
                                            {{ $errors->first('ctitle') }}
                                        </span>
                                    @endif
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Category Page Head<span>*</span></label>
                                    <input type="text" class="form-control" id="chead" name="chead" placeholder="Enter Category Page Heading" required>
                                </div>
                                <!-- <div class="form-group m-t-20">
                                    <label>Image</label>
                                    <input type="file" class="form-control" id="cimage" name="cimage">
                                    <p>Please upload minimum 1920px X 308px image only</p>
                                </div> -->
                                <div class="form-group m-t-20">
                                    <label>Banner Heading</label>
                                    <input type="text" class="form-control" id="cbannerhead" name="cbannerhead" placeholder="Enter Banner Heading" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Menu Head Only<span>*</span></label>
                                    <p><input type="radio" class="" id="cmenuhead" name="cmenuhead" value="N" checked>No &nbsp;&nbsp;
                                    <input type="radio" class="" id="cmenuhead" name="cmenuhead" value="Y" >Yes</p>
                                </div>
                                <div class="form-group m-t-20" >
                                    <label>Category Type<span>*</span></label>
                                    <p>
                                    	<input type="radio" class="ctype"  name="ctype" value="N" checked required>Category/Occasion Related &nbsp;&nbsp;
                                    	<input type="radio" class="ctype" name="ctype"  value="P" required>Price Related
                                    	<input type="radio" class="ctype" name="ctype"  value="CP" required>Categorywise Price Range
                                	</p>
                                </div>


                                
                                <div class="form-group m-t-20 price-range" style="display:none">
                                    <label>Price Details(Please put value USD currency)</label>
                                    <p><input type="text" id="from_price" name="from_price" placeholder="From Price">&nbsp;&nbsp; 
                                    <input type="text" id="to_price" name="to_price" placeholder="To Price">&nbsp;&nbsp;
                                        <select id="equation" name="equation">
                                           <option value="">Select Option</option>
                                           <option value="between">Between</option>
                                           <option value="greater">Greater</option>
                                           <option value="less">Less</option>
                                        </select>
                                    </p>
                                </div>

                                <div class="form-group m-t-20 cat-price-range" style="display:none">
                                    <label>Price Details(Please put value USD currency)</label>
                                    <p>
                                    	<select name="category_id" id="category_id" >
                                            @foreach($dataDetails as $cat)
                                                <option value="{{$cat->id}}">{{$cat->name}}</option>
                                            @endforeach 
                                        </select>

                                    	<input type="text" id="cat_from_price" name="cat_from_price" placeholder="From Price">&nbsp;&nbsp; 
                                    	<input type="text" id="cat_to_price" name="cat_to_price" placeholder="To Price">&nbsp;&nbsp;
                                        <select id="cat_equation" name="cat_equation">
                                           <option value="">Select Option</option>
                                           <option value="between">Between</option>
                                           <option value="greater">Greater</option>
                                           <option value="less">Less</option>
                                        </select>
                                    </p>
                                </div>



                                <div class="form-group m-t-20">
                                    <label>Content Top</label>
                                    <textarea class="form-control" rows="5" id="ccontenttop" name="ccontenttop" placeholder="Enter Content Top" ></textarea>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Content Bottom</label>
                                    <textarea class="form-control" rows="5" id="ccontentbottom" name="ccontentbottom" placeholder="Enter Content Bottom" ></textarea>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Meta Title</label>
                                    <input type="text" class="form-control" id="cmeta_title" name="cmeta_title" placeholder="Enter Meta Title" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Meta Description</label>
                                    <textarea class="form-control" rows="5" id="cmeta_description" name="cmeta_description" placeholder="Enter Meta Description" required></textarea>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Tagline</label>
                                    <input type="text" class="form-control" id="ctagline" name="ctagline" placeholder="Enter Tagline" >
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Top Head</label>
                                    <input type="text" class="form-control" id="ctophead" name="ctophead" placeholder="Enter Tophead" >
                                </div>
                            </div>
                            <div class="border-top">
                                <div class="card-body">
                                    <input class="btn btn-primary" type="submit" value="CREATE">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif 
</main>   

<script type="text/javascript">
    
    $.validator.setDefaults({
            submitHandler: function(form) {
                form.submit();
            }
    });

    $(document).ready(function () {
        setTimeout(function () {
            $('.cke_notifications_area').attr("style", "display: none !important");
        }, 1000); // 60000ms = 1 minute
    });
    
    $(function() {
        // validate the comment form when it is submitted
        $("#formadd").validate({
            ignore: [],
            errorPlacement: function(label, element) {
                label.addClass('mt-2 text-danger');
                label.insertAfter(element);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass('has-danger')
                $(element).addClass('form-control-danger')
            }
          });
    });


    CKEDITOR.replace("ccontenttop");
    CKEDITOR.replace("ccontentbottom");


    $('#title').on('blur', function(){
        var title = $.trim($(this).val());
        if(title != ''){
            //if($.trim($('#slug').val()) == ''){
                $('#slug').val(title.replace(/ /g,"-").toLowerCase());
                $('#slug-error').hide();
            //}
        }
    });
       

    // $('.ctype').click(function(){
    //     if(this.value == 'P'){
    //         $('.price-range').show();
    //         $('#from_price').attr('required', true);
    //         $('#to_price').attr('required', true);
    //         $('#equation').attr('required', true);
    //     }else{
    //         $('.price-range').hide();
    //         $('#from_price').removeattr('required', true);
    //         $('#to_price').removeattr('required', true);
    //         $('#equation').removeattr('required', true);
    //     }
       
    // });


    $('.ctype').click(function(){
        if(this.value == 'P'){
            $('.price-range').show();
            $('#from_price').attr('required', true);
            $('#to_price').attr('required', true);
            $('#equation').attr('required', true);

            $('.cat-price-range').hide();
            $('#category_id').attr('required', false);
            $('#cat_from_price').attr('required', false);
            $('#cat_to_price').attr('required', false);
            $('#cat_equation').attr('required', false);
        }else if(this.value == 'CP'){
        	$('.price-range').hide();
            $('#from_price').attr('required', false);
            $('#to_price').attr('required', false);
            $('#equation').attr('required', false);

            $('.cat-price-range').show();
            $('#category_id').attr('required', true);
            $('#cat_from_price').attr('required', true);
            $('#cat_to_price').attr('required', true);
            $('#cat_equation').attr('required', true);
        }else{
            $('.price-range').hide();
            $('#from_price').attr('required', false);
            $('#to_price').attr('required', false);
            $('#equation').attr('required', false);

            $('.cat-price-range').hide();
            $('#category_id').attr('required', false);
            $('#cat_from_price').attr('required', false);
            $('#cat_to_price').attr('required', false);
            $('#cat_equation').attr('required', false);
        }
       
    });
  
</script>    

@endsection
