@extends('layouts.admin.app')
@section('content')
<main id="main" class="main">

    <div class="pagetitle">
      <h1>Profile</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item">Home</li>
          <li class="breadcrumb-item">Users</li>
          <li class="breadcrumb-item active">Profile</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section profile">
      <div class="row">
        @php 
            $reset = 0; 
            if(session()->has('success') || session()->has('error')) {
                $reset = 1; 
            }
        @endphp
        
        <div class="col-xl-12">
          <div class="card">
            <div class="card-body pt-3">
              <!-- Bordered Tabs -->
              <ul class="nav nav-tabs nav-tabs-bordered">

                <li class="nav-item">
                  <button class="nav-link {{ $reset == 0 ? 'active' : '' }}" id="profile-overview-tab" data-bs-toggle="tab" data-bs-target="#profile-overview">Overview</button>
                </li>
                <li class="nav-item">
                  <button class="nav-link {{ $reset == 1 ? 'active' : '' }}" id="profile-change-password-tab" data-bs-toggle="tab" data-bs-target="#profile-change-password">Change Password</button>
                </li>

              </ul>
              <div class="tab-content pt-2">

                <div class="tab-pane profile-overview fade {{ $reset == 0 ? 'show active' : '' }}" id="profile-overview">
                  <h5 class="card-title">Profile Details</h5>

                  <div class="row">
                    <div class="col-lg-3 col-md-3 label ">Agent Name</div>
                    <div class="col-lg-9 col-md-9">{{$profileDetails->name}}</div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-3 label">Contact Person</div>
                    <div class="col-lg-9 col-md-9">{{$profileDetails->contact_person}}</div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-3 label">Email</div>
                    <div class="col-lg-9 col-md-9">{{$profileDetails->email}}</div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-3 label">Allternative emails</div>
                    <div class="col-lg-9 col-md-9">
                        @if(!empty($profileDetails->alternate_email))
                            @foreach(json_decode($profileDetails->alternate_email, true) ?? [] as $alt_email)
                                {{ $alt_email }}
                                @if(!$loop->last) , @endif
                            @endforeach
                        @endif
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-3 label">Phone no</div>
                    <div class="col-lg-9 col-md-9">{{$profileDetails->phone_no}}</div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-3 label">Alternative Phone no</div>
                    <div class="col-lg-9 col-md-9">
                        @if(!empty($profileDetails->alternate_phone_no))
                            @foreach(json_decode($profileDetails->alternate_phone_no, true) ?? [] as $alternate_phone_no)
                                {{ $alternate_phone_no }}
                                @if(!$loop->last) , @endif 
                            @endforeach
                        @endif
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-3 label">Address</div>
                    <div class="col-lg-9 col-md-9">{{$profileDetails->address}}</div>
                  </div>

                </div>

                <div class="tab-pane fade {{ $reset == 1 ? 'show active' : '' }}" id="profile-change-password">
                    <h5 class="card-title">Change Password</h5>
                  <!-- Change Password Form -->
                    <form id="changePasswordForm" action="{{url('/admin/agent/profile/')}}/{{encrypt($profileDetails->id)}}" method="post">
                        @csrf
                        
                        <div class="row mb-3">
                            <label for="newPassword" class="col-md-4 col-lg-3 col-form-label">New Password</label>
                            <div class="col-md-8 col-lg-9 input-group">
                            <input name="newpassword" type="password" class="form-control" id="newPassword" required>
                            <button type="button" class="btn btn-outline-secondary toggle-password" data-target="newPassword" >
                                <i class="bi bi-eye"></i>
                            </button>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label for="renewPassword" class="col-md-4 col-lg-3 col-form-label">Re-enter New Password</label>
                            <div class="col-md-8 col-lg-9 input-group">
                            <input name="renewpassword" type="password" class="form-control" id="renewPassword" required>
                            <button type="button" class="btn btn-outline-secondary toggle-password" data-target="renewPassword">
                                <i class="bi bi-eye"></i>
                            </button>
                            </div>
                        </div>
                        <div class="alert_error" id="alert_error"></div>
                       @if(session()->has('success'))
                            <div class="alert alert-success" role="alert">
                                {{ session('success') }}
                            </div>
                        @elseif(session()->has('error'))
                            <div class="alert alert-danger" role="alert">
                                {{ session('error') }}
                            </div>
                        @endif

                        <div class="text-left">
                            <button type="submit" class="btn btn-primary">Change Password</button>
                        </div>
                    </form>

                </div>

              </div><!-- End Bordered Tabs -->

            </div>
          </div>

        </div>
      </div>
    </section>

</main><!-- End #main -->

<style>
    .active{color: #2c2c2c!important;}
</style>

<script>
$(document).ready(function() {
    // Toggle password visibility
    $(document).on('click', '.toggle-password', function() {
        let targetId = $(this).data('target');
        let input = $('#' + targetId);
        let icon = $(this).find('i');

        if (input.attr('type') === 'password') {
            input.attr('type', 'text');
            icon.removeClass('bi-eye').addClass('bi-eye-slash');
        } else {
            input.attr('type', 'password');
            icon.removeClass('bi-eye-slash').addClass('bi-eye');
        }
    });

    // Check if new passwords match before submitting
    $('#changePasswordForm').on('submit', function(e) {
        let newPass = $('#newPassword').val();
        let rePass = $('#renewPassword').val();
        
        // Clear previous errors
        $('#alert_error').empty();
        
        if(!newPass || !rePass) {
            $('#alert_error').append(`
                <div class="alert alert-danger" role="alert">
                    Please fill all required fields.
                </div>
            `);
            e.preventDefault();
            return false;
        }

        if (newPass !== rePass) {
            $('#alert_error').append(`
                <div class="alert alert-danger" role="alert">
                    New Password and Re-type Password must match.
                </div>
            `);
            e.preventDefault();
            return false;
        }
    });

    // Show the change password tab if there are messages
    @if($reset == 1)
        const tab = new bootstrap.Tab(document.querySelector('#profile-change-password-tab'));
        tab.show();
    @endif
});
</script>
@endsection
