@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Edit Agent</h4>
                    <div class="ml-auto text-right">
                        <a href="{{url('/admin/agent/all-agents')}}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
		    <div class="row">
		        <div class="col-12">
		            <div class="card">
		                <form action="{{url('/admin/agent/edit')}}/{{encrypt($agentDetails->id)}}" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">
		                    @csrf
                            <div class="card-body">
                            <h4 class="card-title">Update Agent</h4>

                            <div class="form-group m-t-20">
                                <label>Agent Name</label>
                                <input type="text" class="form-control" name="name" placeholder="Enter Agent Name" value="{{$agentDetails->name}}" required>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Agent Email</label>
                                <input type="email" class="form-control" name="email" placeholder="Enter Agent Email" value="{{$agentDetails->email}}" required>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Contact Person</label>
                                <input type="text" class="form-control" name="contact_person" placeholder="Enter Contact Person" value="{{$agentDetails->contact_person}}">
                            </div>

                            <div class="form-group m-t-20">
                                <label>Alternate Email(s)</label>
                                <div id="altEmailWrapper">
                                    @if(!empty($agentDetails->alternate_email))
                                        @foreach(json_decode($agentDetails->alternate_email) as $alternateEmail)
                                            <div class="input-group mb-2">
                                                <input type="email" class="form-control" name="alt_email[]" placeholder="Enter Alternate Email" value="{{$alternateEmail}}">
                                                <button type="button" class="btn btn-success addEmail">+</button>
                                                <button type="button" class="btn btn-danger removeField">-</button>
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="input-group mb-2">
                                            <input type="email" class="form-control" name="alt_email[]" placeholder="Enter Alternate Email">
                                            <button type="button" class="btn btn-success addEmail">+</button>
                                        </div>    
                                    @endif
                                </div>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Phone No</label>
                                <input type="text" class="form-control" name="phone_no" placeholder="Enter Phone No" value="{{$agentDetails->phone_no}}" required>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Alternate Phone No(s)</label>
                                <div id="altPhoneWrapper">
                                    @if(!empty($agentDetails->alternate_phone_no))
                                        @foreach(json_decode($agentDetails->alternate_phone_no) as $alternate)
                                            <div class="input-group mb-2">
                                                <input type="text" class="form-control" name="alt_phone[]" value="{{$alternate}}" placeholder="Enter Alternate Phone No">
                                                <button type="button" class="btn btn-success addPhone">+</button>
                                                <button type="button" class="btn btn-danger removeField">-</button>
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="input-group mb-2">
                                            <input type="text" class="form-control" name="alt_phone[]" placeholder="Enter Alternate Phone No">
                                            <button type="button" class="btn btn-success addPhone">+</button>
                                        </div>     
                                    @endif
                                </div>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Address</label>
                                <textarea class="form-control" name="address" placeholder="Enter Address" value="{{$agentDetails->address}}" required>{{$agentDetails->address}}</textarea>
                            </div>

                            <div class="form-group m-t-20">
                                <label>Agent Type</label>
                                <select name="agent_type" class="form-control" required>
                                    <option value="">Select Agent Type</option>
                                    <option value="H/Hand-delivery" {{$agentDetails->agent_spec == "Hand-delivery" ? 'selected' : ''}}>Hand Delivery</option>
                                    <option value="C/Courier" {{$agentDetails->agent_spec == "Courier" ? 'selected' : ''}}>Courier</option>
                                    <option value="C/Third-party-vendor" {{$agentDetails->agent_spec == "Third-party-vendor" ? 'selected' : ''}}>Third Party Vendor</option>
                                </select>
                            </div>
                        </div>
		                    <div class="border-top">
		                        <div class="card-body">
		                            <input class="btn btn-primary" type="submit" value="UPDATE">
		                        </div>
		                    </div>
		                </form>
		            </div>
		        </div>
		    </div>
		</div>
</main> 

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
  

<script type="text/javascript">
$(document).ready(function(){
    // Add Alternate Email
    $(document).on('click', '.addEmail', function(){
        $('#altEmailWrapper').append(`
            <div class="input-group mb-2">
                <input type="email" class="form-control" name="alt_email[]" placeholder="Enter Alternate Email">
                <button type="button" class="btn btn-danger removeField">-</button>
            </div>
        `);
    });

    // Add Alternate Phone
    $(document).on('click', '.addPhone', function(){
        $('#altPhoneWrapper').append(`
            <div class="input-group mb-2">
                <input type="text" class="form-control" name="alt_phone[]" placeholder="Enter Alternate Phone No">
                <button type="button" class="btn btn-danger removeField">-</button>
            </div>
        `);
    });

    // Remove Field
    $(document).on('click', '.removeField', function(){
        $(this).closest('.input-group').remove();
    });

    // Password Match Validation
    $('#formadd').on('submit', function(){
        let pass = $('#password').val();
        let cpass = $('#cpassword').val();
        if(pass !== cpass){
            alert('Password and Confirm Password must match!');
            return false;
        }
    });
});
</script>

@endsection