@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
{{--<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>--}}
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
    @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'M')
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Addon Mapping</h4>
                    <div class="ml-auto text-right">
                        <a href="{{ route('admin.addon.addon_mapping') }}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                            @if(Session::has('alert-' . $msg))
                                <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
                            @endif
                        @endforeach
                        <form action="{{ route('admin.addon.addon_mapping_edit', base64_encode($dataDetails->id).'?redirect='.urlencode($request->fullUrl())) }}" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <h4 class="card-title">Addon Mapping Edit</h4>
                                <input type="hidden" name="formid" value="<?php echo $dataDetails->id; ?>">
                                <div class="form-group m-t-20">
                                    <label>Addon Group<span>*</span></label>
                                    <select id="addon_group_id" name="addon_group_id" type="text" class="form-control"
                                        aria-required="true" aria-invalid="false" required>
                                        <option value="">Select Addon Group</option>
                                        @foreach ($addon_group as $list)
                                            @if ($dataDetails->addon_group_id == $list->id)
                                            <option selected value="{{ $list->id }}">
                                            @else
                                                <option value="{{ $list->id }}">
                                            @endif
                                            {{ $list->title }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Addon Sub Group<span>*</span></label>
                                    <select id="addon_sub_group_id" name="addon_sub_group_id" type="text" class="form-control"
                                        aria-required="true" aria-invalid="false" required>
                                        <option value="">Select Addon Sub Group</option>
                                        @foreach ($addon_sub_group as $list)
                                            @if ($dataDetails->addon_sub_group_id == $list->id)
                                            <option selected value="{{ $list->id }}">
                                            @else
                                                <option value="{{ $list->id }}">
                                            @endif
                                            {{ $list->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Product<span>*</span></label>
                                    <select id="product_id" name="product_id" type="text" class="form-control"
                                        aria-required="true" aria-invalid="false" required>
                                        <option value="">Select Product</option>
                                        @foreach ($product as $list)
                                            @if ($dataDetails->product_id == $list->id)
                                            <option selected value="{{ $list->id }}">
                                            @else
                                                <option value="{{ $list->id }}">
                                            @endif
                                            {{ $list->product_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Sl No</label>
                                    <input type="text" class="form-control" id="sl_no" name="sl_no" value="{{$dataDetails->sl_no}}" placeholder="Enter Sl No" required>
                                </div>
                            </div>
                            <div class="border-top">
                                <div class="card-body">
                                    <input class="btn btn-primary" type="submit" value="UPDATE">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
</main>    

<script type="text/javascript">
    $.validator.setDefaults({
            submitHandler: function(form) {
                form.submit();
            }
    });
    $(function() {
        // validate the comment form when it is submitted
        $("#formadd").validate({
            ignore: [],
            errorPlacement: function(label, element) {
                label.addClass('mt-2 text-danger');
                label.insertAfter(element);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass('has-danger')
                $(element).addClass('form-control-danger')
            }

          });
    });

    // CKEDITOR.replace("cbcontenttop");
    // CKEDITOR.replace("cbcontentbottom");

    // $('#title').on('blur', function(){
    //     var title = $.trim($(this).val());
    //     if(title != ''){
    //         //if($.trim($('#slug').val()) == ''){
    //             $('#slug').val(title.replace(/ /g,"-").toLowerCase());
    //             $('#slug-error').hide();
    //         //}
    //     }

    // });

    // $('.ctype').click(function(){
    //     if(this.value == 'P'){
    //         $('.price-range').show();
    //         $('#from_price').attr('required', true);
    //         $('#to_price').attr('required', true);
    //         $('#equation').attr('required', true);
    //     }else{
    //         $('.price-range').hide();
    //         $('#from_price').removeattr('required', true);
    //         $('#to_price').removeattr('required', true);
    //         $('#equation').removeattr('required', true);
    //     }
    // })
    // if($('#cattype').val() == 'P'){
    //     $('.price-range').show();
    //     $('#from_price').attr('required', true);
    //     $('#to_price').attr('required', true);
    //     $('#equation').attr('required', true);
    // }else{
    //     $('.price-range').hide();
    //     $('#from_price').removeattr('required', true);
    //     $('#to_price').removeattr('required', true);
    //     $('#equation').removeattr('required', true);
    // }

    // var _URL = window.URL || window.webkitURL;
    // $("#image").change(function (e) {
    //     var file, img;
    //     var fuData = document.getElementById('image');
    //     var FileUploadPath1 = fuData.value;
    //     if (FileUploadPath1 == ''){
    //         alert("Please upload an image");
    //     }
    //     else{
    //         var Extension = FileUploadPath1.substring(FileUploadPath1.lastIndexOf('.') + 1).toLowerCase();
    //         if (Extension == "gif" || Extension == "png" || Extension == "bmp" || Extension == "jpeg" || Extension == "jpg" || Extension == "webp"){
    //             if ((file = this.files[0])) {
    //                 img = new Image();
    //                 img.onload = function () {

    //                     // if(this.width < 1920 || this.height < 308) {

    //                     //     //alert('Minimum upload image size 1920px X 379px');

    //                     //     alert('Minimum upload image size 1920px X 308px');

    //                     //     document.getElementById('image').value="";

    //                     //     document.getElementById('list').src="";

    //                     //     $('#list').hide();

    //                     //     return false;

    //                     // }

    //                     // else{

    //                         $('#list').show();

    //                         var output = document.getElementById('list');

    //                         output.src = URL.createObjectURL(e.target.files[0]);

    //                         document.getElementById('list').style.width="300px";

    //                         return true;

    //                     //}

    //                 };

    //                 img.src = _URL.createObjectURL(file);
    //             }
    //         }
    //     }
    // });

</script>     

@endsection