<?php

namespace App\Http;
use Illuminate\Support\Facades\DB;

// use App\Models\contact1;

// use App\Models\contact2;

// use App\Models\contact3;

// use App\Models\chat;

// use App\Models\User;

// use App\Models\Agent;

// use App\Models\AdminLogin;

use Illuminate\Http\Request;
use App\Http\Helper1;
use App\Models\User;
use App\Models\Currency;
use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\OrderMessage;
use App\Models\OrderCurrency;
use App\Models\Coupon;
use App\Models\AppliedCoupon;
use App\Models\Product;
use App\Models\ProductExtra;
use App\Models\ProductImage;
use App\Models\AssignOrderDetail;
// use Illuminate\Support\Facades\DB;

// use Illuminate\Support\Facades\Auth;

// use Illuminate\Support\Facades\Hash;

// use Illuminate\Support\Facades\Validator;



class Helper{

    
    
    public static function AssignOrderView($id,$agentId){

        $id = decrypt($id);
        $agentId = decrypt($agentId);

        $user = Auth::guard('AgentLogin')->user();

        $agent_assinged = DB::connection('mysql')->table('agent_assinged')->where('agent_order_id',$id)->where('agent_id',$agentId)->first();
        $delivered_product_image = DB::connection('mysql')->table('agent_proof_of_delivery')->where('agent_assinged_id',$agent_assinged->id)->get();

        $agents = DB::connection('mysql')->table('agents')->where('id',$agentId)->first();

        $product = [];

        //$agent_product_list=[];

        $product_maped = DB::connection('mysql')->table('assigned_agent_product_map')->where('agent_assinged_id',$agent_assinged->id)->get();

        $orders = DB::connection('mysql')->table('orders')->where('id',$agent_assinged->OID)->first();

        $order_details = DB::connection('mysql')->table('order_details')->where('order_id',$orders->id)->get();

        $orders_Msg = DB::connection('mysql')->table('order_messages')->where('order_id',$agent_assinged->OID)->first();

        // $agent_product_list = DB::connection('mysql')->table('assigned_agent_product_map')
        //         ->join('agent_product_list', 'assigned_agent_product_map.product_id', '=', 'agent_product_list.id')
        //         ->where('agent_assinged_id',$agent_assinged->id)->get();

        $agent_product_list = DB::connection('mysql')->table('assigned_agent_product_map')
                ->join('agent_product_details', 'assigned_agent_product_map.product_id', '=', 'agent_product_details.id')
                ->where('agent_assinged_id',$agent_assinged->id)->get();

        //dd($agent_product_list);


            // foreach($product_maped as $product_mapeds){

            //     if($agent_assinged->id == $product_mapeds->agent_assinged_id){

            //         // $products[] = DB::connection('mysql')->table('products')->where('id',$product_mapeds->product_id)->first();

            //          $agent_product_list[] =  DB::connection('mysql')->table('agent_product_list')->where('id',$product_mapeds->product_id)->first();



            //     }

            // }

            $data=compact('agent_assinged','product_maped','orders','order_details','orders_Msg','user','agent_product_list','agents','agentId');



            $agent_assinged=$data['agent_assinged'];

            $product_maped=$data['product_maped'];

            $orders=$data['orders'];

            $order_details=$data['order_details'];

            $orders_Msg=$data['orders_Msg'];

            $user=$data['user'];

            $agent_product_list=$data['agent_product_list'];

            $agents=$data['agents'];

            $agentId=$data['agentId'];

            // return $data['agent_assinged'];

        // return $agent_product_list;

        // return view('OrderDetails',compact('agent_assinged','product_maped','orders','order_details','user','agent_product_list','agents','agentId'));

            return view('admin.order.assign_order_view',compact('agent_assinged','product_maped','orders','order_details','orders_Msg','user','agent_product_list','agents','agentId','id','delivered_product_image'));

    }

    public static function UpdateAssignOrderStatus($orderId,$agentID,Request $request){
        
        $orderId = decrypt($orderId);
        
        $agentID = decrypt($agentID);
        
        $extra = $request['extra'];

        $deliVery = $request['deliveryCharge'];

        $reason = $request['reason'];

        $status = $request['status'];

        $track_no = $request['track_no'];

        $tracking_link =  $request['tracking_link'];

        

        $rules = ['status' => 'required'];



        if ($status == 'S') {

            $rules['track_no'] = 'required';

        } elseif (in_array($status, ['H', 'CL'])) {

            $rules['reason'] = 'required';

        }



        $messages = [

            'status.required' => 'Please enter the required field for status.',

            'track_no.required' => 'Please provide the tracking number.',

            'reason.required' => 'Please provide a reason.',

        ];



        $validator = Validator::make($request->all(), $rules, $messages);



        if ($validator->fails()) {

            return redirect()->back()->withErrors($validator)->withInput();

        }



            DB::connection('mysql')->table('agent_assinged')->where('agent_order_id',$orderId)->where('agent_id',$agentID)->update([	

                'extra'=> $extra,

                'Deliver_charge' => $deliVery,

                'reason' => $reason,

                'track_no'=>$track_no,

                'tracking_link' => $tracking_link,

                'status' => $status,

            ]);



            $handDelivery = [];
            $courier = [];
            $agent_assined_get_order_id = DB::connection('mysql')->table('agent_assinged')->where('agent_order_id', $orderId)->first();
            $agent_assigned = DB::connection('mysql')->table('agent_assinged')->where('OID', $agent_assined_get_order_id->OID)->get();
            $agent_assigned_count = DB::connection('mysql')->table('agent_assinged')->where('OID', $agent_assined_get_order_id->OID)->count();
            $agent_assinged_progress_status_count =  DB::connection('mysql')->table('agent_assinged')->where('OID', $agent_assined_get_order_id->OID)->where('status','PC')->count();
            $agent_assinged_delivery_status_count =  DB::connection('mysql')->table('agent_assinged')->where('OID', $agent_assined_get_order_id->OID)->where('status','D')->count();

            if($agent_assigned_count == $agent_assinged_progress_status_count){
                DB::connection('mysql')->table('orders')->where('id', $agent_assined_get_order_id->OID)->update([
                        'order_delivery_status' => 'PC',
                ]);
            }elseif($agent_assigned_count == $agent_assinged_delivery_status_count){
                DB::connection('mysql')->table('orders')->where('id', $agent_assined_get_order_id->OID)->update([
                        'order_delivery_status' => 'D',
                ]);
            }else{

            }


            $orderDetails = DB::table('orders')->where('id', $agent_assined_get_order_id->OID)->first();
            $siteinfo = DB::table('site_details')->where('site_sort_name', $orderDetails->sitename)->first();
            $ordered_user = DB::table('users')->where('id', $orderDetails->user_id)->first();

            require_once app_path('Helpers/zeptomail_helper.php');

            $mail_data = [
                'unique_order_id' => $orderDetails->unique_order_id,
                'customer_data'   => $ordered_user,
                'site_data'       => $siteinfo,
            ];

            $assigned_order_data = collect(); // Initialize as Collection for merging

            foreach ($agent_assigned as $assignment) {
                if ($assignment->status === $status) {
                    $orderData = DB::connection('mysql')->table('agent_assinged')->where('OID', $assignment->OID)->get();

                    $assigned_order_data = $assigned_order_data->merge($orderData);
                }

                
            }

            $userData = $mail_data;
            // return $assigned_order_data;

            $productDetails = [];
            $products = [];

            if ($assigned_order_data) {
                foreach ($assigned_order_data as $assigned_order_datas) {
                    $products = Helper1::getProductDetails($assigned_order_datas->OID);

                    // $products = Helper1::getProductDetails($agent_assined_get_order_id->OID);
                    
                    // if (!empty($products)) {
                    //     $firstProduct = $products[0]; // or $products->first() if it's a collection
                    //     $assigned_order_datas->product_name  = $firstProduct->product_name ?? '';
                    //     $assigned_order_datas->product_image = ($firstProduct->fnid ?? 'default') . '.webp';
                    // } else {
                    //     $assigned_order_datas->product_name  = '';
                    //     $assigned_order_datas->product_image = 'default.webp';
                    // }
                }
                
            }

            // return $products;
            // return $data = compact('products');


            // try {
            //     if ($status === 'S') {
            //         $subject = $siteinfo->site_domain . ' - Your order has been shipped';
            //         $htmlbody = view('admin.emails.order_shipped_email_to_customer', [
            //             'data'          => $userData,
            //             'product'       => $products,
            //         ])->render();

            //     } elseif ($status === 'D') {
            //         $subject = $siteinfo->site_domain . ' - Your order has been delivered';
            //         $htmlbody = view('admin.emails.order_complete_email_to_customer', [
            //             'data'          => $userData,
            //             'product'       => $products,
            //         ])->render();

            //     } else {
            //         throw new \Exception('Invalid order status: ' . $status);
            //     }

            //     // Send the email
            //     $userResponse = sendZeptoMail($userData['customer_data']->email,$subject,$htmlbody,$siteinfo);

            // } catch (\Exception $e) {
            //     // Log or return error
            //     // return response()->json(['error' => 'Failed to send email', 'message' => $e->getMessage(), 'file' => $e->getFile(), 'line' => $e->getLine()], 500);
            // }


            
           

            

            // foreach ($agent_assigned as $assignment) {
            //     $agent = DB::connection('mysql')->table('agents')->where('id', $assignment->agent_id)->first();
                
            //     if($assignment == 'S'){
            //         $agentData = [
            //         'name' => $agent->name,
            //         'agent_type' => $agent->agent_type,
            //         'status' => $assignment->status,
            //     ];
            //     }
                
                
                
            // }

            // return $agentData;
            // $agentDataCount = $agent_assigned->count();
            // return $agentDataCount;

            // return $data = compact('handDelivery','courier');
            // Process status checks (same for all statuses)
            // foreach ($handDelivery as $handDeliveryAgent) {
            //     foreach ($courier as $courierAgent) {
            //         $handStatus = $handDeliveryAgent['status'];
            //         $courierStatus = $courierAgent['status'];
                    
            //         if ($handStatus == "PC" && $courierStatus == "PC") {
            //             // Update order status to PC
            //             // return "both are PC";
            //             // DB::connection('mysql')->table('orders')->where('id', $agent_assined_get_order_id->OID)->update([
            //             //     'order_delivery_status' => 'PC',
            //             // ]);


            //         } 
            //         elseif ($handStatus == 'D' && $courierStatus == 'D') {
            //             // Send mail to courier
            //             // Update order status to Delivered
            //             // DB::connection('mysql')->table('orders')->where('id', $agent_assined_get_order_id->OID)->update([
            //             //     'order_delivery_status' => 'D',
            //             // ]);
            //             // return "Both are D";

            //         } elseif ($courierStatus == 'S') {
            //             // Send mail to courier
            //             // return "courierStatus are S";

            //         } elseif ($courierStatus == 'D') {
            //             // Send mail to hand delivery
            //             // return "courierStatus are D";
            //         } 
            //         elseif($handStatus == 'D'){
            //             // Send mail to  handStatus
            //             //  return "handStatus are D";
            //         }else {
            //             // Other conditions
            //         }
            //     }
            // }
      

        return back();

    }    



    public static function get_imagelink($id = null, $site = null){
        $imgDtl = DB::connection('mysql')->table('product_images')->where(['id'=>$id, 'default_image' => 'Y'])->first();

        $siteDtl = DB::table('site_details')->where(['site_sort_name'=>$site])->first();

        $result = $siteDtl->site_link.'uploaded/product/'.$imgDtl->name;
        return $result;
    }

    public static function get_item_detail($id = null, $addon_id = null){
        $result = '';
        if($id != 0){
            $result = DB::connection('mysql')->table('agent_product_details')->where(['product_id'=>$id])->first();
        }else{
            $result = DB::connection('mysql')->table('agent_product_details')->where(['product_id'=>$addon_id])->first();
        }
        return $result;
    }

    public static function get_order_messages($id = null){
        $result = DB::connection('mysql')->table('order_messages')->where(['order_id'=>$id])->first();
        return $result;
    }

}

    




