<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\Product;
use App\Models\Category;
use App\Models\ProductCategory;
use App\Models\ProductAttribute;
use App\Models\ProductImage;
use App\Models\ProductLiveStatus;
use App\Models\ProductRating;
use App\Models\Falseurl;
use App\Models\FalseurlProductSort;
use App\Imports\BulkProductUploadImport;

// use Excel;

class FalseurlController extends Controller
{
	public function list($id=null, Request $request)
	{
        $site_id=base64_decode($id);
        $result = DB::table('false_urls')
                  ->join('categories','false_urls.category_id','=','categories.id')
                  ->join('sites','false_urls.site_id','=','sites.id')
                  ->where('false_urls.site_id', '=', $site_id)
                  ->orderBy('false_urls.updated_at','desc')
                  ->get(["sites.site_name","categories.name","false_urls.*"]);
        return view('admin.falseurl.list', ['site_id' => $site_id, 'result' => $result,  'request' => $request]);
	}

    public function add($id=null, Request $request)
    {
    	// dd($request);
    	$site_id = base64_decode($id);
    	// $sites = DB::table('sites')->get();
    	$categories = DB::table('categories')->where('is_block','N')->get();
    	$product_sortorders = DB::table('falseurl_product_sortorders')->get();
        $obj = new Falseurl;

        if($request->isMethod('POST')){
            $slug_url=$request->falseurl;
            // dd($slug_url);
            $data  = DB::table('false_urls')
                    ->where(['site_id'=>$site_id])
                    ->where(['slug_url'=>$slug_url])
                    ->first();
            // dd($data);

            if($data){        
                $falseurl_id = $data->id;
                // dd($cat_ban_id);
            }else{
                $falseurl_id = 0;
            }  
            // dd($falseurl_id);
            // if ($request->post('image')) {
            //     $image_validation = "mimes:jpeg,jpg,png,webp";
            // } else {
            //     $image_validation = "required|mimes:jpeg,jpg,png,webp";
            // }

            $request->validate([
                // 'image'=>$image_validation,
                'falseurl'=>'required',
                // 'site_id_new'=>'required',
                'category_id'=>'required',
                'product_sortorder_id'=>'required',
                'falseurlmeta_title'=>'required',
                'falseurlmeta_description'=>'required',
                // 'cslug'=>'required'
            ]);

            // if ($request->hasFile('image')) {
            //     if ($cat_ban_id) {
            //         $categoryImage = DB::table('category_banners')->where(['id' => $cat_ban_id])->get();
            //         //dd($catImage[0]->category_image);
            //         // if (Storage::exists('public/upload/category_banners/' . $categoryImage[0]->image)) {

            //         //     //dd($catImage[0]->category_image);

            //         //     Storage::delete('public/upload/category_banners/' . $categoryImage[0]->image);

            //         // }

            //         $image_path = public_path('upload/category_banners/'.$categoryImage[0]->image);


            //         if(file_exists($image_path)){
            //             //File::delete($image_path);
            //             File::delete( $image_path);
            //         }

            //     }

            //     $image = $request->file('image');
            //     $ext = $image->extension();
            //     $image_name = time() . '.' . $ext;
            //     // $image->storeAs('/public/upload/category_banners/', $image_name);

            //     $request->image->move(public_path('upload/category_banners'), $image_name);

            //     // $model->image = $image_name;
            // }

            if($falseurl_id!=0){
            	
                // $update_arr['image'] = $image_name;
                $update_arr['slug_url'] = $request->falseurl;
                $update_arr['site_id'] = $request->site_id;
                $update_arr['category_id'] = $request->category_id;
                $update_arr['banner_img_alt'] = $request->banneralt;
                $update_arr['banner_heading'] = $request->bannerheading;
                $update_arr['content_top'] = $request->falseurlcontenttop;
                $update_arr['content_bottom'] = $request->falseurlcontentbottom;
                $update_arr['sort_order'] = $request->product_sortorder_id;
                $update_arr['meta_title'] = $request->falseurlmeta_title;
                $update_arr['meta_description'] = $request->falseurlmeta_description;
                $update_arr['tag_line'] = $request->falseurltagline;
                $update_arr['tophead'] = $request->falseurltophead;

                // $update_arr[''] = $image_name;

                // $update_arr[''] = $image_name;


                Falseurl::where(['id' => $falseurl_id])->update($update_arr);

                $request->session()->flash('alert-success', 'Falseurl successfully updated.');

                return redirect()->route('admin.falseurl.list', ['id' => base64_encode($site_id)]);

            }else{
            	// dd("hello");


            if($falseurl = $obj->create([
                
                'slug_url' => $request->falseurl,
                'site_id' => $request->site_id,
                'category_id' => $request->category_id,
                // 'image' => $image_name,
                'banner_img_alt' => $request->banneralt, 
                'banner_heading' => $request->bannerheading,
                'content_top' => $request->falseurlcontenttop,
                'content_bottom' => $request->falseurlcontentbottom,
                'sort_order' => $request->product_sortorder_id,
                'meta_title' => $request->falseurlmeta_title, 
                'meta_description' => $request->falseurlmeta_description,
                'tag_line' => $request->falseurltagline,
                'tophead' => $request->falseurltophead,

            ]))
          

            {

                $request->session()->flash('alert-success', 'Falseurl successfully added.');

                // return redirect()->route('admin.falseurl.list');
                return redirect()->route('admin.falseurl.list', ['id' => base64_encode($site_id)]);


            }else{

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

                return redirect()->back()->with($request->except(['_method', '_token']));

            }

        }

        }

        return view('admin.falseurl.add', ['site_id' => $site_id, 'categories' => $categories, 'product_sortorders' => $product_sortorders]);

    }


	public function edit($id = null, Request $request)
    {

    	$falseuel_id = base64_decode($id);
        $dataDetails  = Falseurl::where('id',$falseuel_id)->first();
        $siteId = $dataDetails->site_id;
        $catdata = DB::table('categories')->where('is_block','N')->get();
        $sort_order = FalseurlProductSort::all();
        $obj = new Falseurl;
         
        if($request->isMethod('POST')){
            $request->validate([
                'falseurl'=>'required',
                'category'=>'required',
                //'banneralt'=>'required',
                'bannerheading'=>'required',
                //'falseurlcontenttop'=>'required',
                //'falseurlcontentbottom'=>'required',
                'productsorder'=>'required',
                'falseurlmeta_title'=>'required',
                'falseurlmeta_description'=>'required',
                //'falseurltagline'=>'required',
                //'falseurltophead'=>'required'
            ]);
            
            $formid = $request->formid;
            $site_id = $request->site_id;

            $update_arr['site_id'] = $request->site_id;
            $update_arr['country_id'] = 99;
            $update_arr['slug_url'] = $request->falseurl;
            $update_arr['category_id'] = $request->category;
            $update_arr['banner_img_alt'] = $request->banneralt;
            $update_arr['banner_heading'] = $request->bannerheading;
            $update_arr['content_top'] = $request->falseurlcontenttop;
            $update_arr['content_bottom'] = $request->falseurlcontentbottom;
            $update_arr['sort_order'] = $request->productsorder;
            $update_arr['meta_title'] = $request->falseurlmeta_title;
            $update_arr['meta_description'] = $request->falseurlmeta_description;
            $update_arr['tag_line'] = $request->falseurltagline;
            $update_arr['tophead'] = $request->falseurltophead;  
            
            if(Falseurl::where(['id' => $request->formid])->update($update_arr)){
                   
                $request->session()->flash('alert-success', 'Falseurl successfully updated.');
                return redirect()->route('admin.falseurl.list', ['id' => base64_encode($site_id)]);
            }else{
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back()->with($request->except(['_method', '_token']));
            }
        }
        
        return view('admin.falseurl.edit', ['dataDetails' => $dataDetails, 'catdata' => $catdata, 'sort_order' => $sort_order, 'request' => $request, 'siteId' => $siteId]);
    }

    public function status(Request $request)
    {
        if($request->id == null || $request->status == null){
            // return redirect()->route('admin.category.list');
        }
        $id = base64_decode($request->id);
        switch($request->status){
            case 'N':
                $block = 'Y';
                $blockText = 'Block';
                break;
            case 'Y':
                $block = 'N';
                $blockText = 'Unblock';
                break;
            default:
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back();
        }

        if(Falseurl::where(['id' => $id])->update(['is_block' => $block])){
            $prompt = array('status' => 1, 'id' => $id, 'event' => $blockText);
            echo json_encode($prompt);
        }else{
            $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
            return redirect()->back();
        }
    }

}