<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\City;
use App\Models\Product;
use App\Models\ProductCity;
use App\Models\Site;

// use Excel;

class CityController extends Controller
{
	public function list($id=null, Request $request)
	{
        $site_id=base64_decode($id);
        $result = City::where('site_id', $site_id)->orderBy('created_at', 'desc')->get();
        $site = Site::where('id', $site_id)->first();
        return view('admin.city.list', ['result' => $result, 'request' => $request, 'site' => $site, 'site_id' => $site_id]);
	}

 	public function add($id=null, Request $request){
 		$site_id=base64_decode($id);
 		$max_sort_value = City::max('sort_order');
 		if($max_sort_value){
 			$max_sort_value = $max_sort_value+1;
 		}else{
 			$max_sort_value =10;
 		}

        $obj = new City;

        if($request->isMethod('POST')){
           
            $request->validate([
                'name'=>'required',
                'slug'=>'required',
                'ban_head'=>'required',
                //'contenttop'=>'required',
                //'contentbottom'=>'required',
                'meta_title'=>'required',
                'meta_description'=>'required',
                'metro_city'=>'required',
                'state'=>'required',
                'area_type'=>'required',
                'delay_day'=>'required',
                //'tagline'=>'required',
                //'tophead'=>'required'
            ]);

            if($city = $obj->create([
                    'country_id' => 99,
                    'name' => $request->name, 
                    'slug' => $request->slug, 
                    'banner_heading' => $request->ban_head,
                    'content' => $request->contenttop,
                    'content_bottom' => $request->contentbottom,
                    'meta_title' => $request->meta_title, 
                    'meta_description' => $request->meta_description,
                    'meta_keyword' => $request->meta_keyword,
                    'tag_line' => $request->tagline,
                    'tophead' => $request->tophead,
                    'sort_order' => $max_sort_value,
                    'delivery_delay_day' => $request->delay_day,
                    'metro_city' => $request->metro_city,
                    'state' => $request->state,
                    'area_type' => $request->area_type,
                    'site_id' => $site_id,
                ]))
            {
                $request->session()->flash('alert-success', 'City successfully added.');
                return redirect()->route('admin.city.list', ['id' => base64_encode($site_id)]);
            }else{
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back()->with($request->except(['_method', '_token']));
            }
            
        }

        return view('admin.city.add', ['request' => $request, 'site_id' => $site_id]);
    }

	public function edit($id = null, Request $request){

        $id = base64_decode($id);
		$dataDetails  = City::where('id',$id)->first();
		$siteId = $dataDetails->site_id;
		// dd($siteId);

        $obj = new City;

        if($request->isMethod('POST')){
            
            $request->validate([
                'name'=>'required',
                'slug'=>'required',
                'ban_head'=>'required',
                'meta_title'=>'required',
                'meta_description'=>'required',
                'metro_city'=>'required',
                'state'=>'required',
                'area_type'=>'required',
                'delay_day'=>'required',
            ]);
            
            $update_arr['name'] = $request->name;
            $update_arr['slug'] = $request->slug;
            $update_arr['banner_heading'] = $request->ban_head;
            $update_arr['content'] = $request->contenttop;
            $update_arr['content_bottom'] = $request->contentbottom;
            $update_arr['meta_title'] = $request->meta_title;
            $update_arr['meta_description'] = $request->meta_description;
            $update_arr['meta_keyword'] = $request->meta_keyword;
            $update_arr['tag_line'] = $request->tagline;
            $update_arr['tophead'] = $request->tophead;
            $update_arr['delivery_delay_day'] = $request->delay_day;
            $update_arr['metro_city'] = $request->metro_city;
            $update_arr['state'] = $request->state;
            $update_arr['area_type'] = $request->area_type;

            if(City::where(['id' => $request->formid])->update($update_arr)){
                   
                $request->session()->flash('alert-success', 'City successfully updated.');
                return redirect()->route('admin.city.list', ['id' => base64_encode($siteId)]);
            }else{
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back()->with($request->except(['_method', '_token']));
            }
        }

        return view('admin.city.edit', ['dataDetails' => $dataDetails, 'request' => $request, 'siteId' => $siteId]);
    }

    public function status(Request $request)
    {
        if($request->id == null || $request->status == null){
            // return redirect()->route('admin.category.list');
        }
        $id = base64_decode($request->id);
        switch($request->status){
            case 'N':
                $block = 'Y';
                $blockText = 'Block';
                break;
            case 'Y':
                $block = 'N';
                $blockText = 'Unblock';
                break;
            default:
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back();
        }

        if(City::where(['id' => $id])->update(['is_block' => $block])){
            $prompt = array('status' => 1, 'id' => $id, 'event' => $blockText);
            echo json_encode($prompt);
        }else{
            $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
            return redirect()->back();
        }
    }

    public function bulkcityupload(Request $request){
        if($request->isMethod('POST')){
            $data = $request->all();
            $value = json_decode($data['all'], true); // Convert JSON string to associative array
            
            foreach ($value as $datas) {

                // $key_slug = Str::slug($datas['Name']);
                $key_name = $datas['Name'];
                $keyword_exist = City::where('name', $key_name)->first();

                if(!$keyword_exist){
                    $keyword_data = new City;
                    $keyword_data->country_id = $datas['Country Id'];
                    $keyword_data->name = $datas['Name'];
                    $keyword_data->slug = $datas['Slug']; 
                    $keyword_data->banner_heading = $datas['Banner Heading'];
                    $keyword_data->content = $datas['Content Top'];
                    $keyword_data->content_bottom = $datas['Content Bottom'];
                    $keyword_data->meta_title = $datas['Meta Title'];
                    $keyword_data->meta_description = $datas['Meta Description'];
                    $keyword_data->meta_keyword = $datas['Meta Keyword'];
                    $keyword_data->tag_line = $datas['Tag Line'];
                    $keyword_data->tophead = $datas['Tophead'];
                    $keyword_data->sort_order = $datas['Sort Order'];
                    $keyword_data->delivery_delay_day = $datas['Delivery Delay Days'];
                    $keyword_data->metro_city = $datas['Metro City'];
                    $keyword_data->state = $datas['State'];
                    $keyword_data->area_type = $datas['Area Type'];
                    $keyword_data->site_id = $datas['Site Id'];
                    $keyword_data->save();
                }              
            }
            $request->session()->flash('alert-success', 'Excel Imported Successfully');
            return redirect()->back();
            
            // return back()->withSuccess('Excel Imported Successfully');
            
        }
        return view('admin.city.bulkcityupload');
    }

    public function bulkcityupdate(Request $request){
        if($request->isMethod('POST')){
            $data = $request->all();
            $value = json_decode($data['all'], true); // Convert JSON string to associative array
            
            foreach ($value as $datas) {

                // $key_slug = Str::slug($datas['Name']);
                $name = $datas['Name'];
                // $keyword_exist = City::where('name', $key_name)->first();
                $update_arr['country_id'] = $datas['Country Id'];
                $update_arr['name'] = $datas['Name'];
	            $update_arr['slug'] = $datas['Slug'];
	            $update_arr['banner_heading'] = $datas['Banner Heading'];
	            $update_arr['content'] = $datas['Content Top'];
	            $update_arr['content_bottom'] = $datas['Content Bottom'];
	            $update_arr['meta_title'] = $datas['Meta Title'];
	            $update_arr['meta_description'] = $datas['Meta Description'];
	            $update_arr['meta_keyword'] = $datas['Meta Keyword'];
	            $update_arr['tag_line'] = $datas['Tag Line'];
	            $update_arr['tophead'] = $datas['Tophead'];
	            $update_arr['sort_order'] = $datas['Sort Order'];
	            $update_arr['delivery_delay_day'] = $datas['Delivery Delay Days'];
	            $update_arr['metro_city'] = $datas['Metro City'];
	            $update_arr['state'] = $datas['State'];
	            $update_arr['area_type'] = $datas['Area Type'];
	            $update_arr['site_id'] = $datas['Site Id'];

	            City::where(['name' => $name])->update($update_arr);
            }
            $request->session()->flash('alert-success', 'Excel Updated Successfully');
            return redirect()->back();
            
            // return back()->withSuccess('Excel Imported Successfully');
            
        }
        return view('admin.city.bulkcityupload');
    }

    public function cityproduct($id = null, Request $request)

    {

        $connectionName = 'mysql';

        if($id == null){
            return redirect()->route('admin.home');
        }

        $id = base64_decode($id);

        $city  = City::find($id);

        if($request->isMethod('POST')){

            $val = $request->bulk_product_edit;

            if($val == "product_update_for_city"){

                if($request->alldata == 1){

                    $allProducts = Product::where(['product_type' => 'M'])->get();

                    foreach($allProducts as $data){

                        if(ProductCity::where(['product_id'=>$data->id, 'city_id' => $request->city_id])->count() == 0){

                            //DB::enableQueryLog();

                            ProductCity::create(["product_id"=>$data->id, 'city_id' => $request->city_id ]);

                            //dd(DB::getQueryLog()); 
                        }
                    }

                }else{

                    $arr = explode("\r\n",$request->field_values);

                    //dd($arr);

                    for($i=0; $i<count($arr); $i++){

                        $arrprice = explode("\t",$arr[$i]);

                        //dd($arrprice);

                        $pid = Product::where( ["fnid" => trim($arrprice[0])] )->first();

                        if($pid){

                            if(ProductCity::where(['product_id'=>$pid->id, 'city_id' => $request->city_id])->count() == 0){

                                //DB::enableQueryLog();

                                ProductCity::create(["product_id"=>$pid->id, 'city_id' => $request->city_id ]);

                                //dd(DB::getQueryLog()); 

                            }
                        }
                    }
                }

                $sqlSortField = "update product_cities set sort_order = id * 10 WHERE city_id = ".$request->city_id;

                DB::connection($connectionName)->select($sqlSortField);
            }

            if($val == "product_sort_for_city"){

                //$websiteShortCode = 'ptes';
                //$connectionName = 'mysql'.$websiteShortCode;

                //DB::enableQueryLog();


                $sqlUpdateSortField = "UPDATE product_cities SET sort_order = sort_order + 300 WHERE id IN (SELECT id FROM ( SELECT product_cities.id as id FROM product_cities where product_cities.city_id = ".$request->city_id." ORDER BY product_cities.sort_order ASC LIMIT 50 ) as temp )";


                DB::connection($connectionName)->select($sqlUpdateSortField);


                $arr = explode("\r\n",$request->field_values);

                //dd($arr);

                for($i=0; $i<count($arr); $i++){

                    $arrprice = explode("\t",$arr[$i]);

                    //dd($arrprice);

                    $pid = Product::where( ["fnid" => trim($arrprice[0])] )->first();

                    if($pid){

                        ProductCity::where(['product_id' => $pid->id, 'city_id' => $request->city_id])

                                            ->update(['sort_order' => $arrprice[1]]);

                    }
                }
            }


            $request->session()->flash('alert-success', 'Product City Product update successful.');

            return redirect()->back()->with($request->except(['_method', '_token']));
        }

        return view('admin.city.cityproduct', ['city' => $city, 'request' => $request]);

    }

}