<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\Product;
use App\Models\Addon;
use App\Models\AddonGroup;
use App\Models\AddonSubGroup;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class AddonController extends Controller

{

	public function addon_group(Request $request)
	{
        $result=AddonGroup::orderBy('updated_at', 'desc')->get();
        // dd($result);
        return view('admin.addon.addon_group_list', ['result' => $result, 'request' => $request]);
	}

    public function addon_group_add(Request $request){
        $obj = new AddonGroup;
        if($request->isMethod('POST')){
            $request->validate([
                'title'=>'required',
                'slug'=>'required',
                'type'=>'required',
            ]);
            if($addon = $obj->create([
                    'title' => $request->title, 
                    'slug' => $request->slug,
                    'type' => $request->type,
                ]))
            {
                $request->session()->flash('alert-success', 'Addon group successfully added.');
                return redirect()->route('admin.addon.addon_group');
            }else{
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back()->with($request->except(['_method', '_token']));
            }
        }
        return view('admin.addon.addon_group_add', ['request' => $request]);
    }

    public function addon_group_edit($id = null, Request $request){
        $id = base64_decode($id);
        $dataDetails  = AddonGroup::where('id',$id)->first();
        $obj = new AddonGroup;
        if($request->isMethod('POST')){
            $request->validate([
                'title'=>'required',
                'slug'=>'required',
                'type'=>'required',
            ]);

            $update_arr['title'] = $request->title;
            $update_arr['slug'] = $request->slug;
            $update_arr['type'] = $request->type;

            if(AddonGroup::where(['id' => $request->formid])->update($update_arr)){
                $request->session()->flash('alert-success', 'Addon group successfully updated.');
                // return redirect()->route('admin.addon.addon_group');
            }else{
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back()->with($request->except(['_method', '_token']));
            }
        }
        return view('admin.addon.addon_group_edit', ['dataDetails' => $dataDetails, 'request' => $request]);
    }


    public function addon_group_status(Request $request)
    {
        if($request->id == null || $request->status == null){
            return redirect()->route('admin.addon.list');
        }
        $id = base64_decode($request->id);
        switch($request->status){
            case 'N':
                $block = 'Y';
                $blockText = 'Block';
                break;
            case 'Y':
                $block = 'N';
                $blockText = 'Unblock';
                break;
            default:
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back();
        }
        if(AddonGroup::where(['id' => $id])->update(['is_block' => $block])){
            $prompt = array('status' => 1, 'id' => $id, 'event' => $blockText);
            echo json_encode($prompt);
        }else{
            $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
            return redirect()->back();
        }
    }

    public function addon_group_product_edit($id = null, Request $request){

        $id = base64_decode($id);

        $dataDetails  = AddonGroup::where('id',$id)->first();

        $addonProduct = Product::where(['product_type' => 'A', 'is_deleted' => 'N'])->get();

        $addon_selected = Addon::where(['addon_group_id' => $dataDetails->id, 
                                    'addon_sub_group_id' => 0])->pluck('product_id');
        $addon_selected = $addon_selected->toarray();

        // dd($addon_selected);

        
        if($request->isMethod('POST')){

            Addon::where(['addon_group_id' => $request->ad_grp_id, 
                            'addon_sub_group_id' => $request->ad_sub_grp_id])->delete();

            if((isset($request->product_id) && count($request->product_id)>0)){
                foreach( $request->product_id as $products_id ) {

                    $addon_data['addon_group_id'] =  $request->ad_grp_id;
                    $addon_data['addon_sub_group_id'] =  $request->ad_sub_grp_id;
                    $addon_data['product_id'] =  $products_id;
                    
                    Addon::create($addon_data);
                }
            }

            $request->session()->flash('alert-success', 'Addon Sub Group Product successfully updated.');
            return redirect()->back();

        }

         return view('admin.addon.addon_group_product_edit', ['dataDetails' => $dataDetails, 'addonProduct' =>$addonProduct, 'addon_selected' => $addon_selected, 'request' => $request]);

    }



    // public function addon_sub($id = null, Request $request){

    //     $id = base64_decode($id);

    //     // dd($id);

    //     if ($id>0){

    //         $addon_sub = DB:: table('addon_groups')

    //                         ->join('addon_sub_groups','addon_groups.id','=','addon_sub_groups.addon_group_id')

    //                         ->where(['addon_sub_groups.addon_group_id'=>$id])

    //                         ->get();

    //         // dd($addon_sub);

    //     }

    //     return view('admin.addon.addon_sub', ['addon_group_id' => $id, 'addon_sub' => $addon_sub, 'request' => $request]);
    // }

    public function addon_sub_group(Request $request){
        $result=AddonSubGroup::orderBy('updated_at', 'desc')->get();
        $result1=AddonGroup::get();
        $result2=Addon::get();
        // dd($result);
        // $ids=[];
  //       foreach($result1 as $key => $data){
  //       	// $ids[]=$data->id;
  //       	$id[]=$data->id;
  //       	$result = DB:: table('addon_groups')
	 //                    ->join('addon_sub_groups','addon_groups.id','=','addon_sub_groups.addon_group_id')
	 //                    ->where(['addon_sub_groups.addon_group_id'=>$id])
	 //                    ->get();

  //       }
  //       echo "<pre>";
		// print_r($result);
		// echo die();
        return view('admin.addon.addon_sub_group_list', ['result' => $result, 'result1' => $result1, 'result2' => $result2, 'request' => $request]);
    }

	public function addon_sub_group_add(Request $request)
    {

        // $addon_group_id = base64_decode($id);

        $addon_groups = DB::table('addon_groups')->get();

        $obj = new AddonSubGroup;

        if($request->isMethod('POST')){

            // $site_id=$request->site_id;

            // $data  = DB::table('cms_pages_sitewise')
            //         ->where(['cms_id'=>$cms_id])
            //         ->where(['site_id'=>$site_id])
            //         ->first();

            // // dd($data);

            // if($data){        
            //     $site_cms_id = $data->id;
            //     // dd($cat_ban_id);
            // }else{
            //     $site_cms_id = 0;
            // }  

            $request->validate([

                'addon_group_id'=>'required',
                'name'=>'required',
                'sort'=>'required',
            ]);

            // if($site_cms_id!=null){

            //     $update_arr['title'] = $request->title;
            //     $update_arr['slug'] = $request->slug;
            //     $update_arr['content'] = $request->content;
            //     $update_arr['meta_title'] = $request->meta_title;
            //     $update_arr['meta_description'] = $request->meta_description;
                
            //     CmsPagesSitewise::where(['id' => $site_cms_id])->update($update_arr);

            //     $request->session()->flash('alert-success', 'Site wise cms successfully updated.');

            //     return redirect()->route('admin.cms.list');

            // }else{

            if($addon_sub_group = $obj->create([

                'addon_group_id' => $request->addon_group_id,
                'name' => $request->name,
                'sort' => $request->sort, 
                // 'slug' => $request->slug,
                // 'content' => $request->content,
                // 'meta_title' => $request->meta_title, 
                // 'meta_description' => $request->meta_description,
                // 'created_by' => Auth::guard('AdminLogin')->user()->id

            ]))

            {
                $request->session()->flash('alert-success', 'Addon Sub Group successfully added.');

                return redirect()->route('admin.addon.addon_sub_group');

            }else{

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

                return redirect()->back()->with($request->except(['_method', '_token']));

            }

        // }

        }
        return view('admin.addon.addon_sub_group_add', ['addon_groups' => $addon_groups, 'request' => $request]);

    }

    public function addon_sub_group_edit($id = null, Request $request){

        $id = base64_decode($id);

        $addon_groups = DB::table('addon_groups')->get();
        $dataDetails  = AddonSubGroup::where('id',$id)->first();

        // $site=DB::table('sites')->where(['id' => $dataDetails->site_id])->first();

        // dd($site);

        // dd($dataDetails);

        if($request->isMethod('POST')){

            $request->validate([
                'addon_group_id'=>'required',
                'name'=>'required',
                'sort'=>'required',
            ]);

            $formid=$request->formid;

                $update_arr['addon_group_id'] = $request->addon_group_id;
                $update_arr['name'] = $request->name;
                $update_arr['sort'] = $request->sort;

            if(AddonSubGroup::where(['id' => $request->formid])->update($update_arr)){

                $request->session()->flash('alert-success', 'Addon Sub Group successfully updated.');

                // return redirect()->route('admin.category.list');

                return redirect()->back();

            }else{

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

                return redirect()->back()->with($request->except(['_method', '_token']));

            }

        }

         return view('admin.addon.addon_sub_group_edit', ['dataDetails' => $dataDetails, 'addon_groups' =>$addon_groups, 'request' => $request]);

    }

    public function addon_sub_group_product_edit($id = null, Request $request){

        $id = base64_decode($id);

        $addon_groups = DB::table('addon_groups')->get();

        $dataDetails  = AddonSubGroup::where('id', $id)->first();

        $addonProduct = Product::where(['product_type' => 'A', 'is_deleted' => 'N'])->get();

        $addon_selected = Addon::where(['addon_group_id' => $dataDetails->addon_group_id, 
                                        'addon_sub_group_id' => $id])->pluck('product_id');
        $addon_selected = $addon_selected->toarray();

        // dd($addon_selected);

        
        if($request->isMethod('POST')){

            Addon::where(['addon_group_id' => $request->ad_grp_id, 
                            'addon_sub_group_id' => $request->ad_sub_grp_id])->delete();

            if((isset($request->product_id) && count($request->product_id)>0)){
                foreach( $request->product_id as $products_id ) {

                    $addon_data['addon_group_id'] =  $request->ad_grp_id;
                    $addon_data['addon_sub_group_id'] =  $request->ad_sub_grp_id;
                    $addon_data['product_id'] =  $products_id;
                    
                    Addon::create($addon_data);
                }
            }

            $request->session()->flash('alert-success', 'Addon Sub Group Product successfully updated.');
            return redirect()->back();

        }

         return view('admin.addon.addon_sub_group_product_edit', ['addon_groups' => $addon_groups, 'dataDetails' => $dataDetails, 'addonProduct' =>$addonProduct, 'addon_selected' => $addon_selected, 'request' => $request]);

    }

    public function getaddon(Request $request){

        $product_data = product::where(['product_type' => 'A', 'is_deleted' => 'N'])->get();

        $html = '';

        foreach($product_data as $key => $data){

            $html .= '<option value="'.$data->id.'">'.$data->product_name.'</option>';

        }

        return json_encode(['type' => 'json', 'status' => 'success', 'data' => $html]);
    }

    // public function addon_sub1_edit($id = null, Request $request){

    //     $id = base64_decode($id);

    //     $addon_groups = DB::table('addon_groups')->get();
    //     $dataDetails  = AddonSubGroup::where('id',$id)->first();

    //     // $site=DB::table('sites')->where(['id' => $dataDetails->site_id])->first();

    //     // dd($site);

    //     // dd($dataDetails);

    //     if($request->isMethod('POST')){

    //         $request->validate([
    //             'addon_group_id'=>'required',
    //             'name'=>'required',
    //             'sort'=>'required',
    //         ]);

    //         $formid=$request->formid;

    //             $update_arr['addon_group_id'] = $request->addon_group_id;
    //             $update_arr['name'] = $request->name;
    //             $update_arr['sort'] = $request->sort;

    //         if(AddonSubGroup::where(['id' => $request->formid])->update($update_arr)){

    //             $request->session()->flash('alert-success', 'Addon Sub Group successfully updated.');

    //             // return redirect()->route('admin.category.list');

    //             return redirect()->back();

    //         }else{

    //             $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

    //             return redirect()->back()->with($request->except(['_method', '_token']));

    //         }

    //     }

    //      return view('admin.addon.addon_sub1_edit', ['dataDetails' => $dataDetails, 'addon_groups' =>$addon_groups, 'request' => $request]);

    // }

    
            

    // public function site_cms_status(Request $request)

    // {

    //     if($request->id == null || $request->status == null){

    //         return redirect()->route('admin.cms.list');

    //     }

    //     $id = base64_decode($request->id);

    //     switch($request->status){

    //         case 'N':

    //             $block = 'Y';

    //             $blockText = 'Block';

    //             break;

    //         case 'Y':

    //             $block = 'N';

    //             $blockText = 'Unblock';

    //             break;

    //         default:

    //             $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

    //             return redirect()->back();

    //     }

    //     if(CmsPagesSitewise::where(['id' => $id])->update(['is_block' => $block])){

    //         $prompt = array('status' => 1, 'id' => $id, 'event' => $blockText);

    //         echo json_encode($prompt);

    //     }else{

    //         $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

    //         return redirect()->back();

    //     }

    // }

    public function addon_mapping(Request $request){
    	$result = DB:: table('addons')
                ->join('addon_groups','addon_groups.id','=','addons.addon_group_id')
                ->join('addon_sub_groups','addon_sub_groups.id','=','addons.addon_sub_group_id')
                ->join('products','products.id','=','addons.product_id')
                ->select('addons.id as addon_id','addon_groups.title as addon_group','addon_sub_groups.name as addon_sub_group','products.id as product_id','products.product_name')
                ->orderBy('addons.id', 'asc')
                ->get();


	    // dd($addon);
	    // echo "<pre>";
	    // print_r($result);
	    // echo die();
        return view('admin.addon.addon_mapping_list', ['result' => $result, 'request' => $request]);           

    }

    public function addon_mapping_add(Request $request)
    {

        // $addon_group_id = base64_decode($id);

    	$product = Product::where(['product_type' => 'A', 'is_deleted' => 'N'])->get();
        $addon_group = AddonGroup::get();
        $addon_sub_group = AddonSubGroup::get();

        $obj = new Addon;

        if($request->isMethod('POST')){

            //dd($request);

            // $request->validate([
            //     'addon_group_id'=>'required',
            //     'addon_sub_group_id'=>'required',
            //     'product_id'=>'required',
            // ]);


            if((isset($request->product_id) && count($request->product_id)>0)){
                foreach( $request->product_id as $products_id ) {

                    $addon_data['addon_group_id'] =  $request->addon_group_id;
                    $addon_data['addon_sub_group_id'] =  $request->addon_sub_group_id;
                    $addon_data['product_id'] =  $products_id;
                    
                    Addon::create($addon_data);
                    
                    // 'product_id' => $request->products_id,

                    // $obj->create([
                    //     'addon_group_id' => $request->addon_group_id,
                    //     'addon_sub_group_id' => $request->addon_sub_group_id,
                    //     'product_id' => $request->products_id,
                    //     'sl_no' => 10
                    // ]);
                }
            }

            $request->session()->flash('alert-success', 'Addon mapping successfully added.');
            return redirect()->route('admin.addon.addon_mapping');
            

            // if($addon = $obj->create([

            //     'addon_group_id' => $request->addon_group_id,
            //     'addon_sub_group_id' => $request->addon_sub_group_id,
            //     'product_id' => $request->product_id,
            //     'sl_no' => $request->sl_no, 
            //     // 'slug' => $request->slug,
            //     // 'content' => $request->content,
            //     // 'meta_title' => $request->meta_title, 
            //     // 'meta_description' => $request->meta_description,
            //     // 'created_by' => Auth::guard('AdminLogin')->user()->id

            // ]))

            // {
            //     $request->session()->flash('alert-success', 'Addon mapping successfully added.');

            //     return redirect()->route('admin.addon.addon_mapping');

            // }else{

            //     $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

            //     return redirect()->back()->with($request->except(['_method', '_token']));

            // }

        // }

        }
        return view('admin.addon.addon_mapping_add', ['product' => $product, 'addon_group' => $addon_group, 'addon_sub_group' => $addon_sub_group, 'request' => $request]);

    }

    public function addon_mapping_edit($id = null, Request $request){

        $id = base64_decode($id);

        $product = Product::get();
        $addon_group = AddonGroup::get();
        $addon_sub_group = AddonSubGroup::get();
        $dataDetails  = Addon::where('id',$id)->first();

        // $site=DB::table('sites')->where(['id' => $dataDetails->site_id])->first();

        // dd($site);

        // dd($dataDetails);

        if($request->isMethod('POST')){

            $request->validate([
                'addon_group_id'=>'required',
                'addon_sub_group_id'=>'required',
                'product_id'=>'required',
            ]);

            $formid=$request->formid;

                $update_arr['addon_group_id'] = $request->addon_group_id;
                $update_arr['addon_sub_group_id'] = $request->addon_sub_group_id;
                $update_arr['product_id'] = $request->product_id;
                $update_arr['sl_no'] = $request->sl_no;

            if(Addon::where(['id' => $request->formid])->update($update_arr)){

                $request->session()->flash('alert-success', 'Addon mapping successfully updated.');

                // return redirect()->route('admin.category.list');

                return redirect()->back();

            }else{

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

                return redirect()->back()->with($request->except(['_method', '_token']));

            }

        }

         return view('admin.addon.addon_mapping_edit', ['dataDetails' => $dataDetails, 'addon_group' =>$addon_group, 'addon_sub_group' =>$addon_sub_group, 'product' =>$product, 'request' => $request]);

    }

    public function addon(Request $request){

        $result = Product::where(['product_type' => 'A', 'is_deleted' => 'N'])->orderBy('id', 'asc')->get();
        return view('admin.addon.addon_list',['result' => $result, 'request' => $request]);

    }

    public function addon_add(Request $request){

        $obj = new Product();

        if($request->isMethod('POST')){

            // dd($request);

            $request->validate([

                'fnid'=>'required',
                'oldid'=>'required',
                'addon_title'=>'required',
                'price'=>'required',
                'delivery_type'=>'required',
            ]);

            
            if($request->oldid){
                $product = Product::where('sku', $request->oldid)->first();
                if($product){
                    $product_sku = $product->sku;

                    if($product_sku){
                        $request->session()->flash('alert-danger', 'SKU is Already used.');
                        return redirect()->route('admin.addon.addon_add');
                    }
                }
            }


            $product_data = $obj->create([

                'fnid' => $request->fnid,
                'sku' => $request->oldid,
                'product_name' => $request->addon_title,
                'price' => $request->price,
                'actual_price' => $request->mrp,
                'delivery_type' => $request->delivery_type,


                // 'description' => $request->product_description,
                // 'content' => $request->content,
                // 'delivery_info' => $request->shipping,
                // 'has_attribute' => $request->has_attribute,
                // 'delivery_delay_days' => $request->delivery_delay_days,
                // 'alt_key' => $request->alt_keyword,
                // 'meta_title' => $request->meta_title,
                // 'meta_description' => $request->meta_description,
                // 'slug'=> Product::getUniqueSlug($request->product_title),
                // 'search_tag' => $request->search_tag,
                // 'extra_field' => $request->extra_field,
                // 'specification' => $request->specification,
                // 'segregation' => $request->segregation,
                // 'vendor_name' => $request->vendor_name,
            ]);

            if($product_data){

                $product_image['product_id'] = $product_data->id;
                $product_image['name']  = $request->fnid.'.webp';
                $product_image['thumb']  = $request->fnid.'_mob.webp';
                $product_image['default_image']  = 'Y';
                $product_image['created_at'] = date('Y-m-d H:i:s');
                $product_image['updated_at'] = date('Y-m-d H:i:s');

                ProductImage::create($product_image);


                $product_live_status['product_id'] = $product_data->id;
                $product_live_status['aof_is_block'] = 'N';
                $product_live_status['bof_is_block'] = 'N';
                $product_live_status['cof_is_block'] = 'N';
                $product_live_status['dof_is_block'] = 'N';
                $product_live_status['hof_is_block'] = 'N';
                $product_live_status['kof_is_block'] = 'N';
                $product_live_status['mof_is_block'] = 'N';
                $product_live_status['pof_is_block'] = 'N';

                ProductLiveStatus::create($product_live_status);

                $request->session()->flash('alert-success', 'Addon product successfully added.');
                return redirect()->route('admin.addon.addon');

            }else{

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back()->with($request->except(['_method', '_token']));
            }
        }

        return view('admin.addon.addon_add',['request' => $request]);
    }

    public function addon_edit($id=null, Request $request){

        $id = base64_decode($id);
        // dd($id);

        $product = Product::where('id',$id)->first();
        // dd($product);

        if($request->isMethod('POST')){
        	// dd('hello');
            $request->validate([
                'fnid' => 'required',
                'oldid' => 'required',
                'addon_title' => 'required',
                'price' => 'required',
                'delivery_type' => 'required',
            ]);

            $formid=$request->formid;
            // dd($formid);

                $update_arr['fnid'] = $request->fnid;
                $update_arr['sku'] = $request->oldid;
                $update_arr['product_name'] = $request->addon_title;
                $update_arr['price'] = $request->price;
                $update_arr['actual_price'] = $request->mrp ?? 0;
                $update_arr['delivery_type'] = $request->delivery_type;

            if(Product::where(['id' => $formid])->update($update_arr)){

                $request->session()->flash('alert-success', 'Addon product successfully updated.');

                return redirect()->route('admin.addon.addon');

                // return redirect()->back();

            }else{

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

                return redirect()->back()->with($request->except(['_method', '_token']));

            }

        }

         return view('admin.addon.addon_edit', ['product' =>$product, 'request' => $request]);
    }

    public function dragproduct(Request $request){
       
        $addon_group_id = $request->addon_group_id;
        $addon_sub_group_id = $request->addon_sub_group_id;

        $product_id=Addon::orderBy('sl_no','asc')
        			->where('addon_group_id',$addon_group_id)
        			->where('addon_sub_group_id',$addon_sub_group_id)
        			->get();
        $html = '';
        foreach($product_id as $pid){
            $productid = $pid->product_id;
            $product_name = Product::select('product_name','fnid')->where('id',$productid)->get();
            foreach($product_name as $pname){
              
                $html .= '<li class="ui-state-default addonproduct" data-id='.$productid.' data-addon_group_id = '.$addon_group_id.' data-addon_sub_group_id = '.$addon_sub_group_id.'><span class="ui-icon ui-icon-arrowthick-2-n-s"></span>'.$pname->product_name.'('.$pname->fnid.')</li>';
            }
        }  
       return $html;
    }

    public function sorthomepageproduct(Request $request){
        $response = json_decode($request->data);
        foreach($response as $value){
            Addon::where(['product_id' => $value->id, 'addon_group_id' => $value->addon_group_id, 'addon_sub_group_id' => $value->addon_sub_group_id ])->update(['sl_no' => $value->position]);
        }
        return json_encode(['status' => 'success', 'msg' => 'Updated Successfully']);
    }

}