<?php

if (!function_exists('sendZeptoMail')) {
    function sendZeptoMail($email, $subject, $htmlbody, $siteDetails)
    {
        $url = 'https://api.zeptomail.in/v1.1/email';
        $token = $siteDetails->zepto_token;

        $emailData = [
            "from" => [
                "address" => $siteDetails->site_noreply_email,
                "name" => "Do Not Reply"
            ],
            "to" => [
                [
                    "email_address" => [
                        "address" => $email
                    ]
                ]
            ],
            "bcc" => [
                [
                    "email_address" => [
                        "address" => 'raj.rtech1@gmail.com',
                    ]
                ],
                [
                    "email_address" => [
                        "address" => 'subhajit.floranet19@gmail.com',
                    ]
                ],
                // [
                //     "email_address" => [
                //         "address" => config('global.admin_email_id')
                //     ]
                // ]
            ],
            "subject" => $subject,
            "htmlbody" => $htmlbody
        ];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Authorization: $token",
            "Content-Type: application/json"
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($emailData));

        $cacertPath = public_path('cacert.pem');
        curl_setopt($ch, CURLOPT_CAINFO, $cacertPath);

        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($error) {
            \Log::error('ZeptoMail cURL Error: ' . $error);
            throw new \Exception('ZeptoMail cURL Error: ' . $error);
        }

        $jsonResponse = json_decode($response, true);

        if (json_last_error() !== JSON_ERROR_NONE) {
            \Log::error('Invalid JSON response from ZeptoMail API: ' . $response);
            throw new \Exception('Invalid JSON response from ZeptoMail: ' . $response);
        }

        if ($httpCode !== 200) {
            \Log::error('ZeptoMail API Error', ['response' => $jsonResponse]);
            throw new \Exception('ZeptoMail API Error: ' . json_encode($jsonResponse));
        }


        return $jsonResponse;
    }
}
